#include <windows.h>
#include <iostream>
#include <string>

using namespace std;
typedef unsigned long	ulong;
typedef unsigned char	byte;

static wstring GetPathEnvVar();
static int GetFileVersion( wchar_t* inDirectoryPath, VS_FIXEDFILEINFO & outFileInfo );


int
main( int argc, char* argv )
{
	int		rc;
	wstring	pathVar = GetPathEnvVar();
	wstring	cscPath;
	size_t	begin, end;
	VS_FIXEDFILEINFO fileInfo = {0};
	int		majorVersion = 0;

	// for each semi-colon-separated entries
	begin = 0;
	end = pathVar.find( ';', begin );
	while( end != -1 )
	{
		// try to get csc.exe in the directory
		cscPath = pathVar.substr( begin, end-begin ) + L"\\csc.exe";
		rc = GetFileVersion( const_cast<wchar_t*>(cscPath.c_str()), fileInfo );
		if( rc == 0 )
		{
			majorVersion = (fileInfo.dwFileVersionMS >> 16);
			break;
		}

		// get next PATH entry
		begin = end+1;
		end = pathVar.find( L';', begin );
	}

	// if succeeded to retrieve version of csc.exe in PATH, show message and return it
	if( majorVersion != 0 )
	{
		cout << "Major version of csc.exe is " << majorVersion << endl;
		return majorVersion;
	}

	cout << "csc.exe not found." << endl;
	return 0;
}

static wstring
GetPathEnvVar()
{
	int rc;
	wchar_t path[4096];

	rc = GetEnvironmentVariableW( L"PATH", path, 4096 );
	if( rc == FALSE )
	{
		return wstring();
	}

	return wstring( path );
}

static int
GetFileVersion( wchar_t* inDirectoryPath, VS_FIXEDFILEINFO & outFileInfo )
{
	int					rc = -1;
	ulong				verInfoSize;
	byte*				verInfo = NULL;
	VS_FIXEDFILEINFO*	fixedFileInfo;
	size_t				fixedFileInfoSize;

	verInfoSize = GetFileVersionInfoSizeW( inDirectoryPath, NULL );
	if( verInfoSize == 0 )
	{
		goto cleanup;
	}

	verInfo = new byte[verInfoSize];
	if( verInfo == NULL )
	{
		goto cleanup;
	}
	
	rc = GetFileVersionInfoW( inDirectoryPath, 0, verInfoSize, verInfo );
	if( rc == FALSE )
	{
		rc = -1;
		goto cleanup;
	}

	rc = VerQueryValueW( verInfo, L"\\", (void**)&fixedFileInfo, &fixedFileInfoSize );
	if( rc == FALSE )
	{
		rc = -1;
		goto cleanup;
	}

	memcpy( &outFileInfo, fixedFileInfo, fixedFileInfoSize );

	rc = 0;

cleanup:
	if( verInfo != NULL )
		delete verInfo;
	return rc;
}
