; NSIS(Nullsoft Install System) script
; for AiB Tools
; encoding: Shift_JIS

;--------------------------------
; String resources

!define D_Version                         "3.2.5"
!define D_PinBrailleVersion               "20130121"
!define D_PinBrailleInstallerName         "PinBraille-${D_PinBrailleVersion}.exe"
!define D_PinBrailleInstallerNameFilter   "PinBraille-????????.exe"

LoadLanguageFile  "${NSISDIR}\Contrib\Language files\Japanese.nlf"
LoadLanguageFile  "${NSISDIR}\Contrib\Language files\English.nlf"

LangString  S_DotNetNotInstalled          ${LANG_JAPANESE} "AiB Tools ̓ɂ .NET Framework 2.0 ȍ~Kvł"
LangString  S_DotNetNotInstalled          ${LANG_ENGLISH}  "AiB Tools needs .NET Framework 2.0 or later to be installed"
LangString  S_NotifyBeginInstallation     ${LANG_JAPANESE} "CXg[Jn܂"
LangString  S_NotifyBeginInstallation     ${LANG_ENGLISH}  "Start installation."
LangString  S_SuccessfullyInstalled       ${LANG_JAPANESE} "CXg[܂B$\nďڍׂȃCXg[ʂ\܂BmFsvȏꍇ́uv{^ďIĂB"
LangString  S_SuccessfullyInstalled       ${LANG_ENGLISH}  "Successfully installed.$\nCheck installation log on list view or press Close button to exit installer."
LangString  S_Shortcut_UninstallAibtools  ${LANG_JAPANESE} "AiB Tools 3 ACXg["
LangString  S_Shortcut_UninstallAibtools  ${LANG_ENGLISH}  "Uninstall AiB Tools 3"
LangString  S_Word_Manual                 ${LANG_JAPANESE} "}jA"
LangString  S_Word_Manual                 ${LANG_ENGLISH}  "manual"
LangString  S_Word_History                ${LANG_JAPANESE} "XV"
LangString  S_Word_History                ${LANG_ENGLISH}  "update history"
LangString  S_PathAdded                   ${LANG_JAPANESE} "PATHAiB Tools̃tH_o^܂"
LangString  S_PathAdded                   ${LANG_ENGLISH}  "Added the directory of AiB Tools to PATH."

;--------------------------------
;  Helper functions

!define StrStr "!insertmacro StrStr"

!macro StrStr ResultVar String SubString
  Push `${String}`
  Push `${SubString}`
  Call StrStr
  Pop `${ResultVar}`
!macroend

Function StrStr
  ;
  ; Usage:  ${StrStr} "ResultVar" "String" "SubString"
  ; ResultVar
  ;   Variable where the part on the right and including the SubString
  ;   found on String is returned. If SubString is not found,
  ;   an empty value is returned.
  ; String
  ;   String where to search for SubString.
  ; SubString
  ;   String to search in String.
  ;
/*After this point:
  ------------------------------------------
  $R0 = SubString (input)
  $R1 = String (input)
  $R2 = SubStringLen (temp)
  $R3 = StrLen (temp)
  $R4 = StartCharPos (temp)
  $R5 = TempStr (temp)*/
 
  ;Get input from user
  Exch $R0
  Exch
  Exch $R1
  Push $R2
  Push $R3
  Push $R4
  Push $R5
 
  ;Get "String" and "SubString" length
  StrLen $R2 $R0
  StrLen $R3 $R1
  ;Start "StartCharPos" counter
  StrCpy $R4 0
 
  ;Loop until "SubString" is found or "String" reaches its end
  loop:
    ;Remove everything before and after the searched part ("TempStr")
    StrCpy $R5 $R1 $R2 $R4
 
    ;Compare "TempStr" with "SubString"
    StrCmp $R5 $R0 done
    ;If not "SubString", this could be "String"'s end
    IntCmp $R4 $R3 done 0 done
    ;If not, continue the loop
    IntOp $R4 $R4 + 1
    Goto loop
  done:
 
/*After this point:
  ------------------------------------------
  $R0 = ResultVar (output)*/
 
  ;Remove part before "SubString" on "String" (if there has one)
  StrCpy $R0 $R1 `` $R4
 
  ;Return output to user
  Pop $R5
  Pop $R4
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0
FunctionEnd


;--------------------------------
; Installer setting

; Set compression method
SetCompressor /SOLID lzma

; enable WinXP Visual Style
XPStyle  on

; product name displayed in installer
Name  "AiB Tools"

; installer file name
OutFile  "AiBTools-${D_Version}.exe"

; the default installation directory
InstallDir  $PROGRAMFILES\AiBTools3

; show details without pressing "detail" button.
; because the button cannot be accessed with keyboard.
ShowInstDetails  show
ShowUninstDetails  show

;--------------------------------
; License agreement data

LicenseLangString  myLicenseData ${LANG_JAPANESE} "license_ja.txt"
LicenseLangString  myLicenseData ${LANG_ENGLISH}  "license.txt"

LicenseData  $(myLicenseData)


;--------------------------------
; Pages

Page  license
Page  directory
Page  instfiles  ""  MyNotifyBeginInstallation

UninstPage  uninstConfirm
UninstPage  instfiles


;--------------------------------
; Installation section

Section "Install"

	SetShellVarContext all
	
	; put files
	SetOutPath $INSTDIR\lang
	File  ..\package\lang\*
	
	SetOutPath $INSTDIR\Documents
	File  ..\package\Documents\*
	File  ..\installer\license*.txt
	
	SetOutPath $INSTDIR\icons
	File  ..\package\icons\*
	
	SetOutPath  $INSTDIR
	File  ..\package\AiBTools.CommonUtl.dll
	File  ..\package\SgRichEdit32.dll
	File  ..\package\SgRichEdit64.dll
	File  ..\package\AiBEdit.vbs
	File  ..\package\AiBEditWin.exe
	File  ..\package\AiBEditWin.exe.manifest
	File  ..\package\AiBTerminal.exe
	File  ..\package\AiBTerminal.exe.manifest
	File  ..\package\RedirectedProcess.dll
	File  ..\package\_dir.exe
	File  ..\package\RegisterTo95Reader.exe
	File  ..\package\Azuki.dll
	File  ..\package\BrailleConverter.dll
	File  ..\package\${D_PinBrailleInstallerName}
	File  ..\package\6TEN.DAT
	File  ..\package\6TENFYOM.TXT
	File  ..\package\6TENYOM.TXT
	File  ..\package\8TEN.DAT
	File  ..\package\8TENFYOM.TXT
	File  ..\package\8TENYOM.TXT
	File  ..\package\BTF.DAT
	File  ..\package\bzen.dat
	File  ..\package\KANJIYOM.TXT
	File  ..\package\nab.dat
	File  ..\package\PINCTRL.DLL
	File  ..\package\TF.DAT
	File  ..\package\untbl.dat
	
	; Write version file
	ClearErrors
	FileOpen $0 $INSTDIR\Version.ini w
	IfErrors write_version_file_end
	FileWrite     $0 "AiBTools=${D_Version}"
	FileWriteByte $0 "10"
	FileWrite     $0 "PinBraille=${D_PinBrailleVersion}"
	FileWriteByte $0 "10"
	FileClose $0
	write_version_file_end:
	
	; clean old installation
	IfFileExists  $INSTDIR\AiBEdit.FileTypes.dll  0 +2
		Delete  $INSTDIR\AiBEdit.FileTypes.dll
	IfFileExists  $INSTDIR\NBS.NBSEngine.dll  0 +2
		Delete  $INSTDIR\NBS.NBSEngine.dll
	
	; write uninstall information to registry
	WriteRegStr    HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SGRY AiBTools 3" "DisplayName" "AiB Tools ${D_Version}"
	WriteRegStr    HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SGRY AiBTools 3" "UninstallString" '"$INSTDIR\UnInstallAiBTools.exe"'
	WriteRegStr    HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SGRY AiBTools 3" "Publisher" "Suguru YAMAMOTO"
	WriteRegStr    HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SGRY AiBTools 3" "URLInfoAbout" "http://sgry.jp/aibtools/"
	WriteRegDWORD  HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SGRY AiBTools 3" "NoModify" 1
	WriteRegDWORD  HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SGRY AiBTools 3" "NoRepair" 1
	WriteUninstaller  "UnInstallAiBTools.exe"
	
	; register AiB Tools to 95Reader's MSAA target
	Exec '$INSTDIR\RegisterTo95Reader.exe'
	
	; install PinBraille
	ExecWait '$INSTDIR\${D_PinBrailleInstallerName}'
	
	; create shortcut in start menu
	CreateDirectory  "$SMPROGRAMS\AiB Tools 3"
	CreateShortCut   "$SMPROGRAMS\AiB Tools 3\$(S_Shortcut_UninstallAibtools).lnk"  "$INSTDIR\UnInstallAiBTools.exe"
	CreateShortCut   "$SMPROGRAMS\AiB Tools 3\AiB Edit.lnk"  "$INSTDIR\AiBEditWin.exe"
	CreateShortCut   "$SMPROGRAMS\AiB Tools 3\AiB Edit $(S_Word_Manual).lnk"  "$INSTDIR\Documents\AiBEdit.txt"
	CreateShortCut   "$SMPROGRAMS\AiB Tools 3\AiB Terminal.lnk"  "$INSTDIR\AiBTerminal.exe"
	CreateShortCut   "$SMPROGRAMS\AiB Tools 3\AiB Terminal $(S_Word_Manual).lnk"  "$INSTDIR\Documents\AiBTerminal.txt"
	CreateShortCut   "$SMPROGRAMS\AiB Tools 3\AiB Tools $(S_Word_Manual).lnk"  "$INSTDIR\Documents\AiBTools.txt"
	CreateShortCut   "$SMPROGRAMS\AiB Tools 3\AiB Tools $(S_Word_History).lnk"  "$INSTDIR\Documents\history.txt"

	; add PATH environment value
	ReadRegStr $0 HKLM "SYSTEM\CurrentControlSet\Control\Session Manager\Environment" "PATH"
	${StrStr} "$1" "$0" "$INSTDIR"
	StrCmp "$1" ""  0  +3
		WriteRegStr HKLM "SYSTEM\CurrentControlSet\Control\Session Manager\Environment" "PATH"  "$INSTDIR;$0"
		DetailPrint "$(S_PathAdded)"

	MessageBox MB_OK  $(S_SuccessfullyInstalled)
SectionEnd


;--------------------------------
; Uninstall section

Section "Uninstall"

	; unregister AiB Tools from 95Reader's MSAA target
	ExecWait '"$INSTDIR\RegisterTo95Reader.exe" -u'
	
	; remove setting files
	;ReadRegStr  $0  HKCU  "Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders" "Local AppData"
	RMDir /r  $APPDATA\AiBTools3
	
	; remove files and uninstaller
	Delete  $INSTDIR\AiBTools.CommonUtl.dll
	Delete  $INSTDIR\SgRichEdit32.dll
	Delete  $INSTDIR\SgRichEdit64.dll
	Delete  $INSTDIR\AiBEdit.vbs
	Delete  $INSTDIR\AiBEditWin.exe.manifest
	Delete  $INSTDIR\AiBEditWin.exe
	Delete  $INSTDIR\AiBEditIDE.exe.manifest
	Delete  $INSTDIR\AiBEditIDE.exe
	Delete  $INSTDIR\AiBTerminal.exe
	Delete  $INSTDIR\AiBTerminal.exe.manifest
	Delete  $INSTDIR\RedirectedProcess.dll
	Delete  $INSTDIR\_dir.exe
	Delete  $INSTDIR\RegisterTo95Reader.exe
	Delete  $INSTDIR\UninstallAiBTools.exe
	Delete  $INSTDIR\Azuki.dll
	Delete  $INSTDIR\BrailleConverter.dll
	Delete  $INSTDIR\${D_PinBrailleInstallerNameFilter}
	Delete  $INSTDIR\6TEN.DAT
	Delete  $INSTDIR\6TENFYOM.TXT
	Delete  $INSTDIR\6TENYOM.TXT
	Delete  $INSTDIR\8TEN.DAT
	Delete  $INSTDIR\8TENFYOM.TXT
	Delete  $INSTDIR\8TENYOM.TXT
	Delete  $INSTDIR\BTF.DAT
	Delete  $INSTDIR\bzen.dat
	Delete  $INSTDIR\KANJIYOM.TXT
	Delete  $INSTDIR\nab.dat
	Delete  $INSTDIR\PINCTRL.DLL
	Delete  $INSTDIR\TF.DAT
	Delete  $INSTDIR\untbl.dat
	Delete  $INSTDIR\Version.ini
	
	RMDir /r  $INSTDIR\lang
	RMDir /r  $INSTDIR\Documents
	RMDir /r  $INSTDIR\icons
	RMDir  $INSTDIR
	
	; remove uninstall information on registry
	DeleteRegKey  HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SGRY AiBTools 3"
	
	; remove shortcut in start menu
	SetShellVarContext all
	RMDir /r  "$SMPROGRAMS\AiB Tools 3"
	SetShellVarContext current
	RMDir /r  "$SMPROGRAMS\AiB Tools 3"

SectionEnd


;--------------------------------
; Callback hook functions

; function called dualing the initialization process
Function .onInit

	Push  ""
	Push  ${LANG_JAPANESE}
	Push  Japanese
	Push  ${LANG_ENGLISH}
	Push  English
	Push  A ; A means auto count languages
	        ; for the auto count to work the first empty push (Push "") must remain
	
	; language selection dialog
	LangDLL::LangDialog  "Installer Language" "Please select the language of the installer"
	Pop  $LANGUAGE
	StrCmp  $LANGUAGE "cancel" 0 dotnet_check
		Abort
	
	dotnet_check:
	; check version of .NET Framework installed
	ReadRegStr  $0  HKLM  "SOFTWARE\Microsoft\.NETFramework\policy\v2.0" "50727"
	StrCmp  $0 ""  0  end
		ReadRegStr  $0  HKLM  "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\NET Framework Setup\NDP\v3.0\Setup" "InstallSuccess"
		StrCmp  $0 ""  0  end
			MessageBox MB_OK  $(S_DotNetNotInstalled)
			;;;Abort
		;;;end:
	end:

FunctionEnd

Function MyNotifyBeginInstallation
	MessageBox MB_OK  $(S_NotifyBeginInstallation)
	Abort
FunctionEnd
