using System;
using System.IO;
using System.Text;

using Sgry;

class IniTest
{
	[STAThread]
	static void Main( string[] args )
	{
        // load data from file
        Ini ini = new Ini();
        
        ini.LoadFromFile( @"test.ini" );
        
        // add new entry 'NewEntry' to section 'User1' with value 'NewValue'
        ini["User1"]["NewEntry"] = "NewValue";
        
        // remove entry 'Entry1' in section 'User1' if exists
        ini["User1"]["Entry1"] = "";
        
        // remove entry 'B̃Gg[' in section 'ZNV' and also section itself
        ini["ZNV"]["B̃Gg["] = null;

        // add new entry 'NewEntry' to un-named section with value 'NewValue'
        ini[""]["NewEntry"] = "NewValue";
        
		// show all data
		Console.Error.WriteLine( "---- dump all data ----" );
        Console.Error.Write( ini.ToString() );
		Console.Error.WriteLine();
        
        // low level interface
        Console.WriteLine( "---- low level interface test ----" );
        foreach( Ini.Section section in ini.Sections )
        {
        	System.Console.WriteLine( "[{0}]", section.Name );
        	foreach( string entryName in section.EntryNames )
        	{
        		System.Console.WriteLine( "{0}={1}", entryName, section[entryName] );
        	}
        }
	}
}

