// file: Win32.cs
// brief: Sgry's Win32API glues.
// update: 2008-10-31
//=========================================================
using System;
using System.Runtime.InteropServices;
using StringBuilder = System.Text.StringBuilder;
using Point = System.Drawing.Point;
using Size = System.Drawing.Size;
using System.Windows.Forms;

namespace Sgry
{
	/// <summary>
	/// Win32API Ăяo߂̐ÓINX
	/// </summary>
	public static class Win32
	{
		#region EBhE bZ[WM
		/// <summary>
		/// Windows ̃VXebZ[W𑗐MČʂ҂
		/// </summary>
		/// <param name="hWnd">MEBhẼnh</param>
		/// <param name="msg">bZ[WID</param>
		/// <param name="wParam">bZ[Wp̒ǉ</param>
		/// <param name="lParam">bZ[Wp̒ǉ</param>
		/// <returns>bZ[WMEBhEԂĂl</returns>
		/// <remarks>bZ[W̎ނȂǂ Platform SDK  winuser.h ȂǎQ</remarks>
		[DllImport("user32", EntryPoint="SendMessageW")]
		public static extern IntPtr SendMessage( IntPtr hWnd, UInt32 msg, IntPtr wParam, IntPtr lParam );
		
		/// <summary>
		/// Windows ̃VXebZ[W𑗐MČʂ҂
		/// </summary>
		/// <param name="hWnd">MEBhẼnh</param>
		/// <param name="msg">bZ[WID</param>
		/// <param name="wParam">bZ[Wp̒ǉ</param>
		/// <param name="lParam">bZ[Wp̒ǉ</param>
		/// <returns>bZ[WMEBhEԂĂl</returns>
		/// <remarks>bZ[W̎ނȂǂ Platform SDK  winuser.h ȂǎQ</remarks>
		[DllImport("user32", EntryPoint="SendMessageW")]
		public static extern unsafe IntPtr SendMessage( IntPtr hWnd, UInt32 msg, void* wParam, void* lParam );
		#endregion

		#region GDIƃ}`fBA
		/// <summary>
		/// POINT Struct
		/// </summary>
		public struct POINT
		{
			/// <summary>X coordinate</summary>
			public Int32 x;

			/// <summary>Y coordinate</summary>
			public Int32 y;
		}
		
		/// <summary>
		/// w肵t@CĐ
		/// </summary>
		public static void PlaySound( string path, bool async )
		{
			const int SND_ASYNC = 1;
			const int SND_FILENAME = 0x00020000;
			UInt32 flags = SND_FILENAME;

			if( async )
				flags |= SND_ASYNC;

			if( System.IO.File.Exists(path) == false )
				return;

			PlaySound( path, IntPtr.Zero, flags );
		}
		
		[DllImport("winmm")]
		extern static void PlaySound( string sound, IntPtr module, UInt32 flags );

		/// <summary>
		/// Rr[v炷
		/// </summary>
		public static void BeepTriple()
		{
			const int freq = 1000;
			Beep( freq, 70 );
			Sleep( 50 );
			Beep( freq, 70 );
			Sleep( 50 );
			Beep( freq, 70 );
		}

		/// <summary>
		/// Qr[v炷
		/// </summary>
		public static void BeepDouble()
		{
			const int freq = 1000;
			Beep( freq, 70 );
			Sleep( 50 );
			Beep( freq, 70 );
		}

		/// <summary>
		/// Pr[v炷
		/// </summary>
		public static void BeepSingle()
		{
			const int freq = 1000;
			Beep( freq, 70 );
		}

		/// <summary>
		/// r[v炷
		/// </summary>
		[DllImport("kernel32")]
		public static extern int Beep( uint frequency, uint duration );
		
		/// <summary>
		/// uVXeG[v炵A[UӐ}Ɏs[Uɒm点B
		/// </summary>
		public static void MessageBeep_Error()
		{
			MessageBeep( 0x10 );
		}
		
		/// <summary>
		/// ubZ[Wixjv炵AԈႦƎԂ̕tȂ{ɍsėǂ[UɍĊmFB
		/// </summary>
		public static void MessageBeep_Warning()
		{
			MessageBeep( 0x30 );
		}
		
		/// <summary>
		/// ubZ[Wijv炵Adł͂Ȃl̂鉽[Uɒm点B
		/// </summary>
		public static void MessageBeep_Information()
		{
			MessageBeep( 0x40 );
		}
		
		/// <summary>
		/// ubZ[Wi₢킹jv炵A[Ȗ삩畛IɔI[UɌ肵Ă炤B
		/// </summary>
		public static void MessageBeep_Question()
		{
			MessageBeep( 0x20 );
		}
		
		/// <summary>
		/// uʂ̌xv炵A[ȖWقǏdvłȂʒmB
		/// </summary>
		public static void MessageBeep_Notify()
		{
			MessageBeep( 0 );
		}
		
		[DllImport("user32")]
		static extern int MessageBeep( Int32 type );
		
		/// <summary>
		/// ĂяoXbhw莞ԂubN
		/// </summary>
		[DllImport("kernel32")]
		public static extern int Sleep( Int32 milli_seconds );

		/// <summary>
		/// EBhE̕`XV~
		/// </summary>
		[DllImport("user32")]
		public static extern Int32 LockWindowUpdate( IntPtr hWnd );
		#endregion // }`fBA

		#region Window ֘A
		/// <summary>
		/// EBhËʒuݒ
		/// </summary>
		[DllImport("user32.dll")]
		public static extern bool SetWindowPos( IntPtr window, IntPtr insertAfter, Int32 x, Int32 y, Int32 width, Int32 height, Int32 flags );

		/// <summary>
		/// w肵EBhẼeLXg̒擾
		/// </summary>
		public static int GetTextLength( IntPtr window )
		{
			return SendMessage( window, WM_GETTEXTLENGTH, IntPtr.Zero, IntPtr.Zero ).ToInt32();
		}

		/// <summary>
		/// w肵EBhẼeLXgIɎ擾
		/// </summary>
		/// <param name="window">eLXg擾EBhẼnh</param>
		/// <returns>EBhẼeLXgi擾łȂnullj</returns>
		public static unsafe string GetWindowText( IntPtr window )
		{
			int gotLength;
			int textLength = GetTextLength( window );
			char * text = stackalloc char[textLength];

			gotLength = SendMessage( window, WM_GETTEXT, new IntPtr(textLength), new IntPtr(text) ).ToInt32();
			if( gotLength == 0 )
			{
				return null;
			}

			return new String( text, 0, gotLength );
		}

		/// <summary>
		/// egbvxEBhEɑ΂Ďw蓮s
		/// </summary>
		/// <param name="enumProc">egbvxEBhEɑ΂čs</param>
		/// <param name="lParam">egbvxEBhEɑ΂čs</param>
		/// <returns> 1As0</returns>
		[DllImport( "user32" )]
		public static extern Int32 EnumWindows( EnumWindowsProc enumProc, IntPtr lParam );

		/// <summary>
		/// egbvxEBhEɑ΂čs
		/// </summary>
		/// <param name="window">SEBhÊPEBhẼnh</param>
		/// <param name="lParam">EnumWindows Win32API ̌Ăяoɗ^ꂽp[^</param>
		public delegate Int32 EnumWindowsProc( IntPtr window, IntPtr lParam );

		/// <summary>
		/// EBhEő剻Ă邩
		/// </summary>
		public static bool IsWindowMaximized( IntPtr window )
		{
			Int32 style = GetWindowLong( window, GWL_STYLE );
			return ( (style & WS_MAXIMIZE) != 0 );
		}

		/// <summary>
		/// EBhEŏĂ邩
		/// </summary>
		public static bool IsWindowMinimized( IntPtr window )
		{
			Int32 style = GetWindowLong( window, GWL_STYLE );
			return ( (style & WS_MINIMIZE) != 0 );
		}

		/// <summary>
		/// EBhE\
		/// </summary>
		public static void ShowWindow( IntPtr window )
		{
			const int SW_SHOW = 5;
			ShowWindow( window, SW_SHOW );
		}

		/// <summary>
		/// EBhEB
		/// </summary>
		public static void HideWindow( IntPtr window )
		{
			const int SW_HIDE = 0;
			ShowWindow( window, SW_HIDE );
		}

		/// <summary>
		/// EBhE̋`擾
		/// </summary>
		public static unsafe Size GetWindowRect( IntPtr window )
		{
			RECT rect;
			GetWindowRect( window, &rect );
			return new Size( rect.right - rect.left, rect.bottom - rect.top );
		}

		/// <summary>
		/// EBhËʒu擾
		/// </summary>
		public static unsafe Point GetWindowLocation( IntPtr window )
		{
			RECT rect;
			GetWindowRect( window, &rect );
			return new Point( rect.left, rect.top );
		}

		/// <summary>GetWindowLong</summary>
		[DllImport("user32")]
		public static extern Int32 GetWindowLong( IntPtr hWnd, Int32 code );
		
		/// <summary>GetFocus</summary>
		[DllImport("user32")]
		public static extern IntPtr GetFocus();
		
		/// <summary>SetFocus</summary>
		[DllImport("user32")]
		public static extern IntPtr SetFocus( IntPtr hWnd );
		
		/// <summary>SetActiveWindow</summary>
		[DllImport("user32")]
		public static extern IntPtr SetActiveWindow( IntPtr hWnd );
		
		/// <summary>SetParent</summary>
		[DllImport("user32")]
		public static extern IntPtr SetParent( IntPtr hWnd, IntPtr newParent );
		
		/// <summary>BringWindowToTop</summary>
		[DllImport("user32")]
		public static extern int BringWindowToTop( IntPtr hWnd );
		
		/// <summary>GetDesktopWindow</summary>
		[DllImport("user32")]
		public static extern IntPtr GetDesktopWindow();
		
		/// <summary>FindWindow</summary>
		[DllImport("user32", EntryPoint="FindWindowW")]
		public static extern IntPtr FindWindow( string windowClassName, string windowText );

		struct RECT
		{
			public Int32 left, top, right, bottom;
		}

		/// <summary>
		/// GetWindowLong API łB
		/// </summary>
		[DllImport("user32")]
		public static extern IntPtr GetWindowLongW( IntPtr hWnd, Int32 index );

		/// <summary>
		/// SetWindowLong API łB
		/// </summary>
		[DllImport("user32")]
		public static extern IntPtr SetWindowLongW( IntPtr hWnd, Int32 index, IntPtr newLong );
		[DllImport("user32", EntryPoint="GetWindowTextW")]
		static extern Int32 GetWindowText( IntPtr hWnd, StringBuilder outText, Int32 maxTextLength );
		[DllImport("user32")]
		static extern Int32 ShowWindow( IntPtr window, Int32 command );
		[DllImport("user32")]
		static extern unsafe Int32 GetWindowRect( IntPtr window, RECT* rect );
		#endregion

		#region R}hvvg֌W
		/// <summary>
		/// vZXɊ֘AtꂽR\[ EBhẼnh擾
		/// </summary>
		public static IntPtr GetConsoleWindow()
		{
			if( Environment.OSVersion.Version.Major < 5 )
			{
				throw new NotSupportedException( "This API only supported in Windows 2000 Professional or later." );
			}
			return _GetConsoleWindow();
		}
		[DllImport("kernel32", EntryPoint="GetConsoleWindow")]
		static extern IntPtr _GetConsoleWindow();
		
		/// <summary>
		/// vZXɃR\[V蓖Ă
		/// </summary>
		[DllImport("kernel32")]
		public static extern Int32 AllocConsole();

		/// <summary>
		/// vZXɊ蓖ĂꂽR\[؂藣
		/// </summary>
		[DllImport("kernel32")]
		public static extern Int32 FreeConsole();
		#endregion

		#region TreeView ֘A
		/// <summary>
		/// c[̃m[hI
		/// </summary>
		public static bool TreeView_SelectItem( IntPtr treeHandle, IntPtr itemHandle )
		{
			int rc = SendMessage( treeHandle, Win32.TVM_SELECTITEM, new IntPtr((int)TVGN.TVGN_CARET), itemHandle ).ToInt32();
			return (rc == 0) ? false : true;
		}

		/// <summary>
		/// TVGN\
		/// </summary>
		public enum TVGN : int
		{
			/// <summary>ق</summary>
			TVGN_CARET	= 9
		}
		#endregion

		#region ListView ֘A
		/// <summary>
		/// LVITEM struct
		/// </summary>
		public struct LVITEM
		{
			/// <summary>mask</summary>
			public uint		mask;
			/// <summary>iItem</summary>
			public int		iItem;
			/// <summary>iSubItem</summary>
			public int		iSubItem;
			/// <summary>state</summary>
			public uint		state;
			/// <summary>stateMask</summary>
			public uint		stateMask;
			/// <summary>pszText</summary>
			public IntPtr	pszText;
			/// <summary>cchTextMax</summary>
			public int		cchTextMax;
			/// <summary>iImage</summary>
			public int		iImage;
			/// <summary>lParam</summary>
			public IntPtr	lParam;
			/// <summary>iIndent</summary>
			public int		iIndent;
			/// <summary>iGroupId</summary>
			public int		iGroupId;
			/// <summary>view</summary>
			public uint		cColumns; // tile view columns
			/// <summary>puColumns</summary>
			public IntPtr	puColumns;
		}

		/// <summary>
		/// LVITEM_STYLE struct
		/// </summary>
		public enum LVITEM_STYLE : uint
		{
			/// <summary>LVIS_FOCUSED</summary>
			LVIS_FOCUSED		= 0x01,
			/// <summary>LVIS_SELECTED</summary>
			LVIS_SELECTED		= 0x02,
			/// <summary>LVIS_CUT</summary>
			LVIS_CUT			= 0x04,
			/// <summary>LVIS_DROPHILITED</summary>
			LVIS_DROPHILITED	= 0x08
		}

		/*
		public static unsafe bool ListView_SetItemState( IntPtr handle, int index, LVITEM_STYLE style )
		{
			IntPtr	rc;
			LVITEM	lvItem;
MessageBox.Show( "first call of Sgry.Win32.ListView_SetItemState! :)" );

			// make LVITEM struct for using this as a bit flag for style assignment
			lvItem.state = (uint)style;

			// get LVITEM object's ptr
			void* pItem = &lvItem;

			// send message
			rc = SendMessage(
				handle,
				Win32.LVM_SETITEMSTATE,
				new IntPtr(index),
				new IntPtr(pItem) );

			return (rc == IntPtr.Zero) ? false : true;
		}
		*/
		#endregion

		#region ListBox ֘A
		/// <summary>
		/// Xg{bNXŃtH[JXĂ鍀ڂ̃CfbNX擾
		/// </summary>
		/// <param name="window">tH[JXꂽڂ̃CfbNX𒲂ׂ郊Xg{bNX̃nh</param>
		/// <returns>tH[JXꂽڂ̃CfbNXiY-1jB</returns>
		/// <remarks>IƃtH[JX͈ႤB</remarks>
		public static int ListBox_GetFocusedItemIndex( IntPtr window )
		{
			return SendMessage( window, LB_GETCARETINDEX, IntPtr.Zero, IntPtr.Zero ).ToInt32();
		}

		/// <summary>
		/// Xg{bNXŃtH[JXĂ鍀ڂύX
		/// </summary>
		public static void ListBox_SetFocusedItemIndex( IntPtr window, int index )
		{
			SendMessage( window, LB_SETCARETINDEX, new IntPtr(index), IntPtr.Zero );
		}
		#endregion

		#region svZXp̊ϐ ֘A
		/// <summary>
		/// svZXŗL̊ϐ擾
		/// </summary>
		public static string GetEnvVar( string name )
		{
			StringBuilder	str	= null;
			uint			length;
			uint			rc; // result code
			
			// get variable length
			length = GetEnvironmentVariable( name, str, (uint)0 );
			if( length == 0 )
			{
				return null; // no such variable
			}
            
			// get variable
			str = new StringBuilder( (int)length );
			rc = GetEnvironmentVariable( name, str, length );
			if( rc == 0 )
			{
				return null; // failed to get variable
			}

			return str.ToString();
		}

		/// <summary>
		/// svZXŗL̊ϐݒ
		/// </summary>
		public static void SetEnvVar( string name, string value )
		{
			bool rc; // result code
			
			rc = SetEnvironmentVariable( name, value );
			if( rc == false )
			{
#				if DEBUG
				throw new Exception( "SetEnvVar API failed." );
#				else
				SetEnvironmentVariable( name, value );
#				endif
			}
		}
		
		[DllImport("kernel32", EntryPoint="SetEnvironmentVariableW", CharSet=CharSet.Unicode)]
		static extern bool SetEnvironmentVariable( string name, string val );

		[DllImport("kernel32", EntryPoint="GetEnvironmentVariableW", CharSet=CharSet.Unicode)]
		static extern uint GetEnvironmentVariable( string name, StringBuilder str, uint strLength );
		#endregion

		#region Lbg
		/// <summary>
		/// ݂̃LbgiL[{[h͗p_j̈ʒu擾
		/// </summary>
		/// <returns>Lbgʒu</returns>
		/// <remarks>Pʂ̓LbgEBhẼNCAgWP</remarks>
		public static Point GetCaretPos()
		{
			unsafe {
				POINT point;
				Int32 rc = GetCaretPos( &point );
				if( rc == 0 )
				{
#					if DEBUG
					throw new Exception( "GetCaretPos API failed." );
#					else
					GetCaretPos( &point );
#					endif
				}

				return new Point( point.x, point.y );
			}
		}

		/// <summary>
		/// ݂̃LbgiL[{[h͗p_j̈ʒuݒ
		/// </summary>
		/// <returns>Lbgʒu</returns>
		/// <remarks>Pʂ̓LbgEBhẼNCAgWP</remarks>
		public static void SetCaretPos( Point newPos )
		{
			Int32 rc = SetCaretPos( newPos.X, newPos.Y );
			if( rc == 0 )
			{
#				if DEBUG
				throw new Exception( "SetCaretPos API failed." );
#				else
				SetCaretPos( newPos.X, newPos.Y );
#				endif
			}
		}

		[DllImport("user32")]
		static unsafe extern Int32 GetCaretPos( POINT* outPos );
		[DllImport("user32")]
		static extern Int32 SetCaretPos( Int32 x, Int32 y );

		/// <summary>
		/// Lbg쐬
		/// </summary>
		[DllImport("user32")]
		public static extern Int32 CreateCaret( IntPtr window, IntPtr hBitmap, Int32 width, Int32 height );
		
		/// <summary>
		/// Lbg\
		/// </summary>
		[DllImport("user32")]
		public static extern Int32 ShowCaret( IntPtr window );
		
		/// <summary>
		/// Lbg\
		/// </summary>
		[DllImport("user32")]
		public static extern Int32 HideCaret( IntPtr window );
		#endregion // Lbg

		#region L[Cxg
		/// <summary>
		/// ÕEBhEbZ[WMShiftL[Ă
		/// </summary>
		/// <returns>ShiftL[ĂȂtrue</returns>
		public static bool IsShiftKeyDown()
		{
			const int VK_SHIFT = 0x10;
			short state = GetKeyState( VK_SHIFT );
			return ( state < 0 );
		}

		/// <summary>
		/// ÕEBhEbZ[WMCtrlL[Ă
		/// </summary>
		/// <returns>CtrlL[ĂȂtrue</returns>
		public static bool IsControlKeyDown()
		{
			const int VK_CONTROL = 0x11;
			short state = GetKeyState( VK_CONTROL );
			return ( state < 0 );
		}

		/// <summary>
		/// ÕEBhEbZ[WMAltL[Ă
		/// </summary>
		/// <returns>AltL[ĂȂtrue</returns>
		public static bool IsAltKeyDown()
		{
			const int VK_MENU = 0x12;
			short state = GetKeyState( VK_MENU );
			return ( state < 0 );
		}

		/// <summary>
		/// ÕEBhEbZ[WMɎwL[Ă
		/// </summary>
		public static bool IsKeyDown( Keys key )
		{
			short state = GetKeyState( (int)key );
			return ( state < 0 );
		}

		/// <summary>
		/// L[Cxg𐶐
		/// </summary>
		public static void SendKeyDownEvent( System.Windows.Forms.Keys key )
		{
			keybd_event( (byte)key, 0, 0, IntPtr.Zero );
		}
		/// <summary>
		/// L[Cxg𐶐
		/// </summary>
		public static void SendKeyUpEvent( System.Windows.Forms.Keys key )
		{
			keybd_event( (byte)key, 0, 2, IntPtr.Zero );
		}
		[DllImport("user32")]
		static unsafe extern void keybd_event( byte virtualKey, byte scanCode, UInt32 flags, IntPtr extraInfo );
		[DllImport("user32")]
		static extern Int16 GetKeyState( Int32 keyCode );
		#endregion // L[Cxg

		#region Input Method Editor (IME)
		/// <summary>
		/// wEBhE IME ԃnh擾܂B
		/// </summary>
		[DllImport("imm32", EntryPoint="ImmGetContext")]
		public static unsafe extern IntPtr ImmGetContext( IntPtr hWnd );

		/// <summary>
		/// ϊ̕擾܂B
		/// </summary>
		[DllImport("imm32", EntryPoint="ImmGetCompositionStringW")]
		public static unsafe extern Int32 ImmGetCompositionString( IntPtr hIMContext, UInt32 index, void* buf, UInt32 bufLen );

		/// <summary>
		/// ϊ̕ݒ肵܂B
		/// </summary>
		[DllImport("imm32", EntryPoint="ImmSetCompositionStringW")]
		public static unsafe extern Int32 ImmSetCompositionString( IntPtr hIMContext, UInt32 index, void* data, UInt32 dataLen, void* read, UInt32 readLen );

		/// <summary>
		/// IME ԃnh܂B
		/// </summary>
		[DllImport("imm32", EntryPoint="ImmReleaseContext")]
		public static unsafe extern Int32 ImmGetContext( IntPtr hWnd, IntPtr hIMC );
		#endregion

		#region X^C֘A̒萔
		/// <summary>EBhE X^C</summary>
		public const Int32 GWL_STYLE = -16;

		/// <summary>gEBhE X^C</summary>
		public const Int32 GWL_EXSTYLE = -20;
		
		/// <summary></summary>
		public const Int32 WS_VISIBLE = 0x10000000;

		/// <summary>ő剻</summary>
		public const Int32 WS_MAXIMIZE = 0x01000000;

		/// <summary>ŏ</summary>
		public const Int32 WS_MINIMIZE = 0x01000000;
		#endregion

		#region EBhEbZ[W
		/// <summary>WM_ACTIVATE</summary>
		public const int WM_ACTIVATE		= 0x0006;
		/// <summary>WM_SETFOCUS</summary>
		public const int WM_SETFOCUS		= 0x0007;
		/// <summary>WM_GETTEXT</summary>
		public const int WM_GETTEXT			= 0x000D;
		/// <summary>WM_GETTEXTLENGTH</summary>
		public const int WM_GETTEXTLENGTH	= 0x000E;
		/// <summary>WM_CLOSE</summary>
		public const int WM_CLOSE			= 0x0010;
		/// <summary>WM_SETFONT</summary>
		public const int WM_SETFONT			= 0x0030;
		/// <summary>WM_GETFONT</summary>
		public const int WM_GETFONT			= 0x0031;
		/// <summary>WM_NOTIFY</summary>
		public const int WM_NOTIFY			= 0x004E;
		/// <summary>WM_KEYFIRST</summary>
		public const int WM_KEYFIRST		= 0x0100;
		/// <summary>WM_KEYDOWN</summary>
		public const int WM_KEYDOWN			= 0x0100;
		/// <summary>WM_KEYUP</summary>
		public const int WM_KEYUP			= 0x0101;
		/// <summary>WM_CHAR</summary>
		public const int WM_CHAR			= 0x0102;
		/// <summary>WM_SYSKEYDOWN</summary>
		public const int WM_SYSKEYDOWN		= 0x0104;
		/// <summary>WM_SYSKEYUP</summary>
		public const int WM_SYSKEYUP		= 0x0105;
		/// <summary>WM_SYSCHAR</summary>
		public const int WM_SYSCHAR			= 0x0106;
		/// <summary>WM_UNICHAR</summary>
		public const int WM_UNICHAR			= 0x0109;
		/// <summary>WM_KEYLAST</summary>
		public const int WM_KEYLAST			= 0x0109;
		/// <summary>WM_IME_STARTCOMPOSITION</summary>
		public const int WM_IME_STARTCOMPOSITION	= 0x010D;
		/// <summary>WM_IME_ENDCOMPOSITION</summary>
		public const int WM_IME_ENDCOMPOSITION		= 0x010E;
		/// <summary>WM_IME_COMPOSITION</summary>
		public const int WM_IME_COMPOSITION			= 0x010F;
		/// <summary>WM_COMMAND</summary>
		public const int WM_COMMAND			= 0x0111;
		/// <summary>WM_CUT</summary>
		public const int WM_CUT				= 0x0300;
		/// <summary>WM_COPY</summary>
		public const int WM_COPY			= 0x0301;
		/// <summary>WM_PASTE</summary>
		public const int WM_PASTE			= 0x0302;
		/// <summary>WM_CLEAR</summary>
		public const int WM_CLEAR			= 0x0303;
		/// <summary>WM_UNDO</summary>
		public const int WM_UNDO			= 0x0304;
		
		//
		// Edit Control Messages
		//
		/// <summary>EM_GETSEL</summary>
		public const int EM_GETSEL				= 0x00B0;
		/// <summary>EM_SETSEL</summary>
		public const int EM_SETSEL				= 0x00B1;
		/// <summary>EM_GETRECT</summary>
		public const int EM_GETRECT				= 0x00B2;
		/// <summary>EM_SETRECT</summary>
		public const int EM_SETRECT				= 0x00B3;
		/// <summary>EM_SETRECTNP</summary>
		public const int EM_SETRECTNP			= 0x00B4;
		/// <summary>EM_SCROLL</summary>
		public const int EM_SCROLL				= 0x00B5;
		/// <summary>EM_LINESCROLL</summary>
		public const int EM_LINESCROLL			= 0x00B6;
		/// <summary>EM_SCROLLCARET</summary>
		public const int EM_SCROLLCARET			= 0x00B7;
		/// <summary>EM_GETMODIFY</summary>
		public const int EM_GETMODIFY			= 0x00B8;
		/// <summary>EM_SETMODIFY</summary>
		public const int EM_SETMODIFY			= 0x00B9;
		/// <summary>EM_GETLINECOUNT</summary>
		public const int EM_GETLINECOUNT		= 0x00BA;
		/// <summary>EM_LINEINDEX</summary>
		public const int EM_LINEINDEX			= 0x00BB;
		/// <summary>EM_SETHANDLE</summary>
		public const int EM_SETHANDLE			= 0x00BC;
		/// <summary>EM_GETHANDLE</summary>
		public const int EM_GETHANDLE			= 0x00BD;
		/// <summary>EM_GETTHUMB</summary>
		public const int EM_GETTHUMB			= 0x00BE;
		/// <summary>EM_LINELENGTH</summary>
		public const int EM_LINELENGTH			= 0x00C1;
		/// <summary>EM_REPLACESEL</summary>
		public const int EM_REPLACESEL			= 0x00C2;
		/// <summary>EM_GETLINE</summary>
		public const int EM_GETLINE				= 0x00C4;
		//public const int EM_LIMITTEXT			= 0x00C5; // EM_SETLIMITTEXT ɕύX
		/// <summary>EM_CANUNDO</summary>
		public const int EM_CANUNDO				= 0x00C6;
		/// <summary>EM_UNDO</summary>
		public const int EM_UNDO				= 0x00C7;
		/// <summary>EM_FMTLINES</summary>
		public const int EM_FMTLINES			= 0x00C8;
		/// <summary>EM_LINEFROMCHAR</summary>
		public const int EM_LINEFROMCHAR		= 0x00C9;
		/// <summary>EM_SETTABSTOPS</summary>
		public const int EM_SETTABSTOPS			= 0x00CB;
		/// <summary>EM_SETPASSWORDCHAR</summary>
		public const int EM_SETPASSWORDCHAR		= 0x00CC;
		/// <summary>EM_EMPTYUNDOBUFFER</summary>
		public const int EM_EMPTYUNDOBUFFER		= 0x00CD;
		/// <summary>EM_GETFIRSTVISIBLELINE</summary>
		public const int EM_GETFIRSTVISIBLELINE = 0x00CE;
		/// <summary>EM_SETREADONLY</summary>
		public const int EM_SETREADONLY			= 0x00CF;
		/// <summary>EM_SETWORDBREAKPROC</summary>
		public const int EM_SETWORDBREAKPROC	= 0x00D0;
		/// <summary>EM_GETWORDBREAKPROC</summary>
		public const int EM_GETWORDBREAKPROC	= 0x00D1;
		/// <summary>EM_GETPASSWORDCHAR</summary>
		public const int EM_GETPASSWORDCHAR		= 0x00D2;
		/// <summary>EM_SETMARGINS</summary>
		public const int EM_SETMARGINS			= 0x00D3;
		/// <summary>EM_GETMARGINS</summary>
		public const int EM_GETMARGINS			= 0x00D4;
		/// <summary>EM_SETLIMITTEXT</summary>
		public const int EM_SETLIMITTEXT		= 0x00C5; // ̂ EM_LIMITTEXT
		/// <summary>EM_GETLIMITTEXT</summary>
		public const int EM_GETLIMITTEXT		= 0x00D5;
		/// <summary>EM_POSFROMCHAR</summary>
		public const int EM_POSFROMCHAR			= 0x00D6;
		/// <summary>EM_CHARFROMPOS</summary>
		public const int EM_CHARFROMPOS			= 0x00D7;
		/// <summary>EM_SETIMESTATUS</summary>
		public const int EM_SETIMESTATUS		= 0x00D8;
		/// <summary>EM_GETIMESTATUS</summary>
		public const int EM_GETIMESTATUS		= 0x00D9;
		/// <summary>EM_SETEVENTMASK</summary>
		public const int EM_SETEVENTMASK		= WM_USER + 69;
		/// <summary>EM_FINDWORDBREAK</summary>
		public const int EM_FINDWORDBREAK		= WM_USER + 76;
		/// <summary>EM_SETTEXTMODE</summary>
		public const int EM_SETTEXTMODE			= WM_USER + 89;
		/// <summary>EM_SETUNDOLIMIT</summary>
		public const int EM_SETUNDOLIMIT		= WM_USER + 82;

		//
		// RichEdit Constants
		//
		/// <summary>WB_MOVELEFT</summary>
		public const int WB_MOVELEFT			= 4;
		/// <summary>WB_MOVERIGHT</summary>
		public const int WB_MOVERIGHT			= 5;
		
		//
		// ListView Messages
		//
		/// <summary>LVM_FIRST</summary>
		public const int LVM_FIRST				= 0x1000;
		/// <summary>LVM_SCROLL</summary>
		public const int LVM_SCROLL				= LVM_FIRST + 20;
		/// <summary>LVM_SETITEMSTATE</summary>
		public const int LVM_SETITEMSTATE		= LVM_FIRST + 43;
		/// <summary>LVM_SETHOTITEM</summary>
		public const int LVM_SETHOTITEM			= LVM_FIRST + 60;

		//
		// TreeView Messages
		//
		/// <summary>TVM_FIRST</summary>
		public const int TVM_FIRST				= 0x1100;
		/// <summary>TVM_SELECTITEM</summary>
		public const int TVM_SELECTITEM			= TVM_FIRST + 11;

		//
		// ListBox Messages
		//
		/// <summary>LB_SETCARETINDEX</summary>
		public const int LB_SETCARETINDEX		= 0x019E;
		/// <summary>LB_GETCARETINDEX</summary>
		public const int LB_GETCARETINDEX		= 0x019F;
		
		/// <summary>WM_USER</summary>
		public const int WM_USER				= 0x0400;
		#endregion
	}

}
