// file: EditUtl.cs
// brief: EDIT NX̃EBhE𑀍삷 Win32API x̊֐Q
// update: 2008-09-13
//=========================================================
using System;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace Sgry
{
	/// <summary>
	/// Windows ̋ UI i EditA RichEdit 𑀍삷郍[x֐Q
	/// </summary>
	public class EditUtl
	{
		#region [eBeB
		/// <summary>
		/// ʂɕ\Ăԉ̍s̃CfbNX擾B
		/// </summary>
		public virtual int GetLastVisibleLine( IntPtr hWnd )
		{
			RECT rect;
			int lastLineHeadIndex;
System.Windows.Forms.MessageBox.Show( "untested method GetLastVisibleLine was called. be carefull..." );
			unsafe
			{
				GetWindowRect( hWnd, &rect );
			}

			lastLineHeadIndex = GetCharIndexFromPosition( hWnd, new Point(0, rect.bottom-1) );

			return GetLineIndexFromCharIndex( hWnd, lastLineHeadIndex );
		}

		/// <summary>
		/// LbgʒuݒiI͉jB
		/// </summary>
		public virtual void SetCaretIndex( IntPtr hWnd, int index )
		{
			SetSelection( hWnd, index, index );
			/*if( hWnd != null )
			{
				SetCaretPos( GetPositionFromCharIndex(hWnd, charIndex) );
			}*/
		}

		/// <summary>
		/// LbgʒuݒiI͉jB
		/// </summary>
		public virtual void SetCaretIndex( IntPtr hWnd, int line, int column )
		{
			int caretPos;
			caretPos = GetCharIndexFromLineColumnIndex( hWnd, line, column );
			SetCaretIndex( hWnd, caretPos );
		}

		/// <summary>
		/// Lbgʒu擾B
		/// </summary>
		public virtual int GetCaretIndex( TextBox textBox )
		{
			Point actualCaretPos = GetCaretPos();
			return GetCharIndexFromPosition( textBox.Handle, actualCaretPos );
		}

		/// <summary>
		/// Lbgʒu擾B
		/// </summary>
		public virtual void GetCaretIndex( TextBox textBox, out int lineIndex, out int columnIndex )
		{
			GetLineColumnIndexFromCharIndex( textBox.Handle, GetCaretIndex(textBox), out lineIndex, out columnIndex );
		}

		/// <summary>
		/// eLXgŜ̃CfbNXŎw肵AsCfbNXƌCfbNX擾B
		/// </summary>
		public virtual void GetLineColumnIndexFromCharIndex( IntPtr hWnd, int charIndex, out int lineIndex, out int columnIndex )
		{
			int lineHeadIndex;

			// sCfbNX擾
			lineIndex = GetLineIndexFromCharIndex( hWnd, charIndex );
			
			// ̍s̐擪̃CfbNX擾
			lineHeadIndex = GetLineHeadIndex( hWnd, lineIndex );

			// CfbNX擾
			columnIndex = charIndex - lineHeadIndex;
		}

		/// <summary>
		/// sCfbNXƌCfbNXŎw肵́AeLXgŜ̃CfbNX擾B
		/// </summary>
		public virtual int GetCharIndexFromLineColumnIndex( IntPtr hWnd, int lineIndex, int columnIndex )
		{
			int index;
			int lineHeadIndex, nextLineHeadIndex;
			int lineEndIndex;

			// ws݂邩mF
			if( GetLineCount(hWnd) <= lineIndex )
			{
				// wCfbNX̍s݂͑Ȃ̂ŁAŏIsƌȂ
				lineIndex = GetLineCount( hWnd ) - 1;
			}
			
			// ws̃CfbNX擾
			lineHeadIndex = GetLineHeadIndex( hWnd, lineIndex );
			nextLineHeadIndex = GetLineHeadIndex( hWnd, lineIndex+1 );
			if( nextLineHeadIndex == -1 )
			{
				lineEndIndex = GetTextLength( hWnd );
			}

			// ʒuvZ
			if( 0 < columnIndex )
			{
				index = lineHeadIndex + columnIndex;
				if( nextLineHeadIndex <= index )
				{
					index = nextLineHeadIndex - 1;
				}
			}
			else
			{
				index = lineHeadIndex;
			}

			return index;
		}

		/// <summary>
		/// I֍sĂ邩B
		/// </summary>
		public virtual bool IsSelectingToEnd( TextBox textBox )
		{
			int selStart, selEnd, selAnchor;
			GetSelection( textBox.Handle, out selStart, out selEnd );
			selAnchor = GetSelectionAnchor( textBox );

			return (selAnchor <= selStart);
		}

		/// <summary>
		/// I̊Jnʒu擾B
		/// </summary>
		public virtual int GetSelectionAnchor( TextBox textBox )
		{
			int selStart, selEnd, selAnchor;
			GetSelection( textBox.Handle, out selStart, out selEnd );

			// IȂA֌đI𒆂Ƃ
			if( selStart == selEnd )
			{
				selAnchor = selStart;
			}
			else
			{
				// I͈͂̐擪ɃLbg΁A擪ɌđILĂŒ
				if( selStart == GetCaretIndex(textBox) )
				{
					selAnchor = selEnd;
				}
				else
				{
					selAnchor = selStart;
				}
			}

			return selAnchor;
		}
		#endregion // [eBeB

		#region ȇ
		/// <summary>
		/// ͂ĂeLXg̒擾B
		/// </summary>
		public virtual int GetTextLength( IntPtr hWnd )
		{
			return SendMessage( hWnd, Win32.WM_GETTEXTLENGTH, IntPtr.Zero, IntPtr.Zero ).ToInt32();
		}
		#endregion

		#region EBhEbZ[W֐
		/// <summary>
		/// I𒆃eLXguB
		/// </summary>
		public virtual unsafe void Replace( IntPtr hWnd, string text )
		{
			fixed( char * buf = text.ToCharArray() )
			{
				SendMessage( hWnd, EM_REPLACESEL, (void*)1, buf );
			}
		}

		/// <summary>
		/// Lbg\ĂȂꍇɃLbg\悤XN[sB
		/// </summary>
		public virtual void ScrollToCaret( IntPtr hWnd )
		{
			SendMessage( hWnd, EM_SCROLLCARET, IntPtr.Zero, IntPtr.Zero );
		}

		/// <summary>
		/// ʂɕ\Ăԏ̍s̃CfbNX擾B
		/// </summary>
		public virtual int GetFirstVisibleLine( IntPtr hWnd )
		{
			return SendMessage( hWnd, EM_GETFIRSTVISIBLELINE, IntPtr.Zero, IntPtr.Zero ).ToInt32();
		}

		/// <summary>
		/// w肵CfbNX̍s̓e擾B
		/// </summary>
		public virtual string GetLine( IntPtr hWnd, int lineIndex )
		{
			string str;
			unsafe
			{
				int lineLength = GetLineLength( hWnd, lineIndex );
				char[] buf = new char[ lineLength + 1 ];
				fixed( char* pBuf = buf )
				{
					buf[0] = (char)lineLength;
					SendMessage( hWnd, EM_GETLINE, (void*)lineIndex, pBuf );
					str = new string( pBuf );
				}
			}
			return str;
		}

		/// <summary>
		/// ͂ĂeLXg̍s擾B
		/// </summary>
		public virtual int GetLineCount( IntPtr hWnd )
		{
			return SendMessage( hWnd, EM_GETLINECOUNT, IntPtr.Zero, IntPtr.Zero ).ToInt32();
		}

		/// <summary>
		/// eLXgŜł̃CfbNXŎw肵܂܂As̃CfbNX擾B
		/// </summary>
		public virtual int GetLineIndexFromCharIndex( IntPtr hWnd, int charIndex )
		{
			return SendMessage( hWnd, EM_LINEFROMCHAR, new IntPtr(charIndex), IntPtr.Zero ).ToInt32();
		}

		/// <summary>
		/// I͈͂擾B
		/// </summary>
		public virtual void GetSelection( IntPtr hWnd, out int start, out int end )
		{
			unsafe
			{
				fixed( int * pStart = &start )
					fixed( int * pEnd = &end )
						SendMessage( hWnd, EM_GETSEL, (void*)pStart, (void*)pEnd );
			}
		}

		/// <summary>
		/// I͈͂ݒB
		/// anchor0AcaretIndex-1ɂƑSIB
		/// </summary>
		public virtual void SetSelection( IntPtr hWnd, int anchor, int caretIndex )
		{
			SendMessage( hWnd, EM_SETSEL, new IntPtr(anchor), new IntPtr(caretIndex) );
		}

		/// <summary>
		/// w肵CfbNX̍s̐擪ɂ镶́AŜł̃CfbNX擾B
		/// </summary>
		public virtual int GetLineHeadIndex( IntPtr hWnd, int lineIndex )
		{
			return SendMessage( hWnd, EM_LINEINDEX, new IntPtr(lineIndex), IntPtr.Zero ).ToInt32();
		}

		/// <summary>
		/// Lbgs̐擪ɂ镶́AŜł̃CfbNX擾B
		/// </summary>
		public virtual int GetCaretLineHeadIndex( IntPtr hWnd )
		{
			return SendMessage( hWnd, EM_LINEINDEX, new IntPtr(-1), IntPtr.Zero ).ToInt32();
		}

		/// <summary>
		/// eLXgŜł̃CfbNXŎw肵܂ށAs̒擾B
		/// </summary>
		public virtual int GetLineLengthFromCharIndex( IntPtr hWnd, int charIndex )
		{
			return SendMessage( hWnd, EM_LINELENGTH, new IntPtr(charIndex), IntPtr.Zero ).ToInt32();
		}

		/// <summary>
		/// w肵CfbNX́As̒擾B
		/// </summary>
		public virtual int GetLineLength( IntPtr hWnd, int lineIndex )
		{
			return GetLineLengthFromCharIndex( hWnd, GetLineHeadIndex(hWnd, lineIndex) );
		}

		/// <summary>
		/// w肵XN[WɈԋ߂́AŜł̃CfbNX擾B
		/// </summary>
		public virtual int GetCharIndexFromPosition( IntPtr hWnd, Point position )
		{
			UInt16 lo = (UInt16)position.X;
			UInt16 hi = (UInt16)position.Y;
			
			IntPtr rc = SendMessage( hWnd, EM_CHARFROMPOS, IntPtr.Zero, new IntPtr(lo | (hi << 16)) );
			return 0xFFFF & rc.ToInt32();
		}

		/// <summary>
		/// eLXgŜł̃CfbNXẃAXN[W擾B
		/// </summary>
		public virtual Point GetPositionFromCharIndex( IntPtr hWnd, int charIndex )
		{
			// RichEdit 2.0 ȍ~ EDIT ƓC^tF[Xő\
			int coord = SendMessage( hWnd, EM_POSFROMCHAR, new IntPtr(charIndex), IntPtr.Zero ).ToInt32();
			return new Point( coord&0xFFFF, (coord>>16)&0xFFFF );
		}
		
		/*public virtual void SetMargins( IntPtr hWnd, int width )
		{
			SendMessage( hWnd, EM_SETMARGINS, new IntPtr(0x0001|0x0002), new IntPtr(width) );
		}*/

		/// <summary>
		/// ǂݎp[hǂB
		/// </summary>
		public virtual bool IsReadonly( IntPtr hWnd )
		{
			int style = (int)GetWindowLongW( hWnd, GWL_STYLE );
			return (style & ES_READONLY) != 0;
		}

		/// <summary>
		/// ǂݎp[hǂݒB
		/// </summary>
		public virtual void SetReadonly( IntPtr hWnd, bool readOnly )
		{
			if( readOnly )
				SendMessage( hWnd, EM_SETREADONLY, new IntPtr(1), IntPtr.Zero );
			else
				SendMessage( hWnd, EM_SETREADONLY, new IntPtr(0), IntPtr.Zero );
		}

		/// <summary>
		/// sҏW[hǂB
		/// </summary>
		public virtual bool IsMultiline( IntPtr hWnd )
		{
			int style = (int)GetWindowLongW( hWnd, GWL_STYLE );
			return (style & ES_MULTILINE) != 0;
		}

		/// <summary>
		/// sҏW[hǂݒB
		/// </summary>
		public virtual void SetMultiline( IntPtr hWnd, bool isMultiline )
		{
			int newStyle;

			// make new style flags
			newStyle = (int)GetWindowLongW( hWnd, GWL_STYLE );
			if( isMultiline )
			{
				newStyle |= ES_MULTILINE|WS_VSCROLL;
			}
			else
			{
				newStyle &= ~ES_MULTILINE;
			}

			// set new style
			SetWindowLong( hWnd, GWL_STYLE, newStyle );
		}

		/// <summary>
		/// ^[L[s̓͂ƌȂ[hB
		/// </summary>
		public virtual bool AcceptsReturn( IntPtr hWnd )
		{
			int style = (int)GetWindowLongW( hWnd, GWL_STYLE );
			return (style & ES_WANTRETURN) != 0;
		}

		/// <summary>
		/// ^[L[s̓͂ƌȂ[hݒB
		/// </summary>
		public virtual void SetAcceptsReturn( IntPtr hWnd, bool acceptsReturn )
		{
			int newStyle;

			// make new style flags
			newStyle = (int)GetWindowLongW( hWnd, GWL_STYLE );
			if( acceptsReturn )
			{
				newStyle |= ES_WANTRETURN;
			}
			else
			{
				newStyle &= ~ES_WANTRETURN;
			}

			// set new style
			SetWindowLong( hWnd, GWL_STYLE, newStyle );
		}
		#endregion

		#region Win32API types and constants
		/// <summary>IԂ擾B</summary>
		protected const int EM_GETSEL				= 0x00B0;
		
		/// <summary>IԂݒB</summary>
		protected const int EM_SETSEL				= 0x00B1;
		
//		protected const int EM_GETRECT				= 0x00B2;
//		protected const int EM_SETRECT				= 0x00B3;
//		protected const int EM_SETRECTNP			= 0x00B4;
//		protected const int EM_SCROLL				= 0x00B5;
//		protected const int EM_LINESCROLL			= 0x00B6;

		/// <summary>Lbgʓɕ\悤XN[B</summary>
		protected const int EM_SCROLLCARET			= 0x00B7;
//		protected const int EM_GETMODIFY			= 0x00B8;
//		protected const int EM_SETMODIFY			= 0x00B9;
		
		/// <summary>͂ĂeLXg̍s擾B</summary>
		protected const int EM_GETLINECOUNT			= 0x00BA;

		/// <summary>w肵CfbNX̍s̐擪ɂ镶́AŜł̃CfbNX擾B</summary>
		protected const int EM_LINEINDEX			= 0x00BB;
//		protected const int EM_SETHANDLE			= 0x00BC;
//		protected const int EM_GETHANDLE			= 0x00BD;
//		protected const int EM_GETTHUMB				= 0x00BE;
		
		/// <summary>w肵s̕擾B</summary>
		protected const int EM_LINELENGTH			= 0x00C1;
		
		/// <summary>I𒆃eLXguB</summary>
		protected const int EM_REPLACESEL			= 0x00C2;
		
		/// <summary>w肵s̓e擾B</summary>
		protected const int EM_GETLINE				= 0x00C4;
//		protected const int EM_CANUNDO				= 0x00C6;
//		protected const int EM_UNDO					= 0x00C7;
//		protected const int EM_FMTLINES				= 0x00C8;
		
		/// <summary>eLXgŜł̃CfbNXŎw肵܂܂As̃CfbNX擾B</summary>
		protected const int EM_LINEFROMCHAR			= 0x00C9;
//		protected const int EM_SETTABSTOPS			= 0x00CB;
//		protected const int EM_SETPASSWORDCHAR		= 0x00CC;
//		protected const int EM_EMPTYUNDOBUFFER		= 0x00CD;
		
		/// <summary>ʏԏɕ\Ăs̃CfbNX擾B</summary>
		protected const int EM_GETFIRSTVISIBLELINE	= 0x00CE;
		
		/// <summary>ǂݎp[hǂݒB</summary>
		protected const int EM_SETREADONLY			= 0x00CF;

		/// <summary>Pꌟo֐ݒB</summary>
		protected const int EM_SETWORDBREAKPROC		= 0x00D0;

		/// <summary>Pꌟo֐擾B</summary>
		protected const int EM_GETWORDBREAKPROC		= 0x00D1;
//		protected const int EM_GETPASSWORDCHAR		= 0x00D2;
//		protected const int EM_SETMARGINS			= 0x00D3;
//		protected const int EM_GETMARGINS			= 0x00D4;
//		protected const int EM_SETLIMITTEXT			= 0x00C5;
//		protected const int EM_GETLIMITTEXT			= 0x00D5;
		
		/// <summary>eLXgŜł̃CfbNXẃAXN[W擾B</summary>
		protected const int EM_POSFROMCHAR			= 0x00D6;

		/// <summary>w肵XN[WɈԋ߂́AŜł̃CfbNX擾B</summary>
		protected const int EM_CHARFROMPOS			= 0x00D7;
//		protected const int EM_SETIMESTATUS			= 0x00D8;
//		protected const int EM_GETIMESTATUS			= 0x00D9;
		
//		protected const int WM_CLEAR				= 0x0303;

		/// <summary>WM_USERłB</summary>
		protected const int WM_USER					= 0x0400;
		
//		protected const int EM_STREAMIN				= WM_USER + 73;
//		protected const int EM_STREAMOUT			= WM_USER + 74;
		/// <summary>w肵͈͂̃eLXg擾B</summary>
		protected const int EM_GETTEXTRANGE			= WM_USER + 75;
		
		/// <summary>P̋؂B</summary>
		protected const int EM_FINDWORDBREAK		= WM_USER + 76;
		
		/// <summary>蒼̏񐔂ݒB</summary>
		protected const int EM_SETUNDOLIMIT			= WM_USER + 82;
		
		/// <summary>RichEdit  EDIT G~[VLEɂB</summary>
		protected const int EM_SETTEXTMODE			= WM_USER + 89;
		
		/// <summary>RichEdit  EDIT G~[V̗LE擾B</summary>
		protected const int EM_GETTEXTMODE			= WM_USER + 90;

		/// <summary>eLXg擾B</summary>
		protected const int EM_GETTEXTEX			= WM_USER + 94;
		
		/// <summary>eLXg̒擾B</summary>
		protected const int EM_GETTEXTLENGTHEX		= WM_USER + 95;
		
		/// <summary>eLXgݒB</summary>
		protected const int EM_SETTEXTEX			= WM_USER + 97;
		#endregion

		#region ̑
		/// <summary>
		/// Lbg̃XN[W擾B
		/// </summary>
		protected virtual Point GetCaretPos()
		{
			unsafe
			{
				POINT pt = new POINT();
				GetCaretPos( &pt );
				return new Point( pt.x, pt.y );
			}
		}

		/// <summary>
		/// Lbg̈ʒuXN[WŐݒB
		/// </summary>
		public virtual bool SetCaretPos( int x, int y )
		{
			Int32 rc = SetCaretPos_( x, y );
			if( rc == 0 )
			{
				return false;
			}

			return true;
		}

		/// <summary>
		/// Lbg̈ʒuXN[WŐݒB
		/// </summary>
		public virtual bool SetCaretPos( Point newPos )
		{
			Int32 rc = SetCaretPos_( newPos.X, newPos.Y );
			if( rc == 0 )
			{
				return false;
			}

			return true;
		}

		/// <summary>
		/// RECT\̂łB
		/// </summary>
		protected struct RECT
		{
			/// <summary>̍W</summary>
			public Int32 left;
			/// <summary>̍W</summary>
			public Int32 top;
			/// <summary>E̍W</summary>
			public Int32 right;
			/// <summary>̍W</summary>
			public Int32 bottom;
		}

		/// <summary>
		/// POINT\̂łB
		/// </summary>
		protected struct POINT
		{
			/// <summary>XW</summary>
			public Int32 x;
			/// <summary>YW</summary>
			public Int32 y;
		}
		
		/// <summary>
		/// eEBhE擾B
		/// </summary>
		[DllImport("user32")]
		protected static extern unsafe IntPtr GetParent( IntPtr window );

		/// <summary>
		/// EBhE̋`擾B
		/// </summary>
		[DllImport("user32")]
		protected static extern unsafe Int32 GetWindowRect( IntPtr window, RECT* rect );
		[DllImport("user32")]
		static unsafe extern Int32 GetCaretPos( POINT* outPos );
		[DllImport("user32", EntryPoint="SetCaretPos")]
		static extern Int32 SetCaretPos_( Int32 x, Int32 y );

		/// <summary>
		/// EBhEbZ[W𑗐MB
		/// </summary>
		[DllImport("user32", EntryPoint="SendMessageW")]
		protected static extern IntPtr SendMessage( IntPtr hWnd, int msg, IntPtr wparam, IntPtr lparam );

		/// <summary>
		/// EBhEbZ[W𑗐MB
		/// </summary>
		[DllImport("user32", EntryPoint="SendMessageW")]
		protected static extern unsafe IntPtr SendMessage( IntPtr hWnd, int msg, void* wparam, void* lparam );

		[DllImport("user32")]
		static extern IntPtr GetWindowLongW( IntPtr hWnd, Int32 code );

		static int SetWindowLong( IntPtr hWnd, int code, int newLong )
		{
			return (int)SetWindowLongW( hWnd, code, new IntPtr(newLong) );
		}

		[DllImport("user32")]
		static extern IntPtr SetWindowLongW( IntPtr hWnd, Int32 code, IntPtr newLong );
		
		internal const int GWL_STYLE = -16;
		internal const int ES_READONLY = 0x0800;
		internal const int ES_MULTILINE = 0x0004;
		internal const int WS_VSCROLL = 0x00200000;
		internal const int ES_WANTRETURN = 0x1000;
		#endregion
	}
}
