// file: Debug.cs
// brief: Sgry's utilities for debug
// update: 2008-11-22
//=========================================================
using System;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Reflection;

namespace Sgry
{
	/// <summary>
	/// SGRY ̃fobOp֐Q
	/// </summary>
	public class DebugUtl
	{
		static string _LogFilePath = null;
		static Object _LockKey = null;

		static String LogPath
		{
			get
			{
				if( _LogFilePath == null )
				{
					Assembly exe = Assembly.GetExecutingAssembly();
					string exePath = exe.GetModules()[0].FullyQualifiedName;
					string exeDirPath = Path.GetDirectoryName( exePath );
					_LogFilePath = Path.Combine( exeDirPath, "log.txt" );
				}
				return _LogFilePath;
			}
		}

		/// <summary>
		/// Ăяoꂽ\
		/// </summary>
		public static void PrintTime()
		{
			Console.WriteLine( DateTime.Now.ToString("{yyyy-MM-dd hh:mm:ss.fff}") );
		}

		/// <summary>
		/// sO C:\log.txt ɏo
		/// </summary>
		/// <param name="format">obZ[W̏</param>
		/// <param name="p">p[^</param>
		public static void Log( string format, params object[] p )
		{
			try
			{
				if( _LockKey == null )
					_LockKey = new Object();
				lock( _LockKey )
				{
					int pid;
					int tid = 0;
					DateTime now = DateTime.Now;
					StreamWriter file;
					
					file = new StreamWriter( LogPath, true );
					pid = System.Diagnostics.Process.GetCurrentProcess().Id;
					tid = System.Threading.Thread.CurrentThread.ManagedThreadId;

					file.Write(
							now.ToString("[yyyy-MM-dd hh:mm.ss.fff]")
							+ String.Format(" [{0},{1}] ", pid.ToString("X4"), tid.ToString("X2"))
						);
					file.WriteLine( String.Format(format, p) );

					file.Close();
				}
			}
			catch{}
		}

		/// <summary>
		/// O C:\log.txt ɏo
		/// </summary>
		/// <param name="message">obZ[W̏</param>
		public static void Log_Raw( string message )
		{
			try
			{
				if( _LockKey == null )
					_LockKey = new Object();
				lock( _LockKey )
				{
					StreamWriter file = new StreamWriter( LogPath, true );

					file.Write( message );

					file.Close();
				}
			}
			catch{}
		}

		/// <summary>
		/// X^bNg[X擾B
		/// </summary>
		public static string GetStackTrace( int depthFrom, int depthTo )
		{
			MethodBase method;
			StringBuilder stackTrace = new StringBuilder();

			try
			{
				for( int i=depthFrom+1; i<=depthTo; i++ )
				{
					method = new StackFrame( i ).GetMethod();
					for( int j=0; j<i-1; j++ )
						stackTrace.Append( " " );
					stackTrace.AppendLine( method.ReflectedType.Name +"."+ method.Name );
				}
			}
			catch( NullReferenceException ) // no more stack frame
			{}

			return stackTrace.ToString();
		}

		/// <summary>
		/// X^bNg[X擾B
		/// </summary>
		public static string GetStackTrace( int depth )
		{
			return GetStackTrace( 1, depth+1 );
		}
	}
}
