// file   : CliOption.cs
// brief  : commandline option parser
// update : 2006-07-30
//=========================================================
using System;
using StringDictionary = System.Collections.Specialized.StringDictionary;

namespace Sgry
{
	/// <summary>
	/// R}hCIvV͂NX
	/// </summary>
	public class CliOptionParser
	{
		/// <summary>
		/// R}hC
		/// </summary>
		/// <param name="args">R}hC</param>
		/// <returns>w肳ꂽIvVƒli[</returns>
		/// <remarks>
		/// "-t=winexe --hoge=HOGE_VALUE C:\log.txt"̏ꍇ̉͗F
		/// +--------------------+---------+------------+
		/// | argument           | name    | value      |
		/// +--------------------+---------+------------+
		/// | -t=winexe          | t       | winexe     |
		/// | --hoge=HOGE_VALUE  | -hoge   | HOGE_VALUE |
		/// | C:\log.txt         | (empty) | C:\log.txt |
		/// +--------------------+---------+------------+
		/// </remarks>
		public static StringDictionary Parse( string[] args )
		{
			try
			{
				StringDictionary	options = new StringDictionary();
				string				name, value;

				// parse options
				for( int i=0; i<args.Length; i++ )
				{
					string arg = args[i];

					// if this is not an option, skip this
					if( arg[0] != '-' )
					{
						continue;
					}

					// extract the name and the value
					int equalPos = arg.IndexOf( '=' );
					if( equalPos != -1 )
					{
						// option with value
						name = arg.Substring( 1, equalPos-1 ).Trim();
						value = arg.Substring( equalPos+1 ).Trim();
						options[name] = value;
					}
					else
					{
						// option not with value
						name = arg.Substring( 1 ).Trim();
						options[name] = String.Empty;
					}
				}

				// at last, parse final token as the value of key ""
				if( args[args.Length-1].StartsWith("-") == false )
				{
					string lastArg = args[args.Length-1];

					// reparse last argument token. see [REF_1] for detail.
					if( Environment.CommandLine.EndsWith("\\\"") )
					{
						int commandLineLength = Environment.CommandLine.Length;
						int lastTokenStart = Environment.CommandLine.LastIndexOf( '\"', commandLineLength-2 ) + 1;
						if( lastTokenStart != 0 ) // 0 <-- -1 + 1
						{
							lastArg = Environment.CommandLine.Substring( lastTokenStart, commandLineLength - lastTokenStart - 1 );
						}
					}

					options[""] = lastArg;
				}

				return options;
			}
			catch( Exception )
			{
				return null; // failure
			}
			//---- [REF_1] ----
			// if the last token of the argument is like next (contains double quote)
			// "C:\"
			// .NET Framework fails parsing and returned last token as
			// C:"
			// so if this pattern appears, parse last token manually.
		}
	}
}
