﻿using System;
using System.Diagnostics;
using System.Windows.Forms;
using Assembly = System.Reflection.Assembly;
using AssemblyName = System.Reflection.AssemblyName;
using AssemblyCopyrightAttribute = System.Reflection.AssemblyCopyrightAttribute;
using System.IO;
using Path = System.IO.Path;
using Sgry.AiBTools.AT;

namespace Sgry.AiBTools.Gui
{
	/// <summary>
	/// AiB Toolsのバージョン情報を表示するダイアログ画面。
	/// </summary>
	public partial class VersionInfoForm : AiBDialogBase
	{
		/// <summary>
		/// 新しいインスタンスを初期化します。
		/// </summary>
		public VersionInfoForm()
		{
			InitializeComponent();
			Font = SystemInformation.MenuFont;
		}

		void _Button_OK_Click( object sender, EventArgs e )
		{
			Close();
		}

		void VersionInfoForm_Shown( object sender, EventArgs e )
		{
			string toolsVerStr = "???";
			string copyrightLine = "(C) 2005-2013 Suguru YAMAMOTO.";
			string editVerStr = "???";
			string termVerStr = "???";
			string commonUtlVerStr = "???";
			string pinBrailleVerStr = "???";
			string winpinVerStr = "???";
			string winpinDateStr = null;
			string pinctrlVerStr = "???";
			string pinctrlDateStr = null;

			string instDir = Path.GetDirectoryName( Assembly
													.GetExecutingAssembly()
													.Location );
			try
			{
				Ini ini = new Ini();
				ini.Load( Path.Combine(instDir, "Version.ini") );
				toolsVerStr = ini.Get( "", "AiBTools", toolsVerStr );
				string s = ini.Get( "", "PinBraille", pinBrailleVerStr );
				pinBrailleVerStr = s.Substring( 0, 4 )
								   + "-" + s.Substring( 4, 2 )
								   + "-" + s.Substring( 6, 2 );
			}
			catch {}

			try
			{
				string editPath = Path.Combine( instDir, "AiBEditWin.exe" );
				Version ver = Assembly.LoadFile(editPath).GetName().Version;
				editVerStr = String.Format( "{0}.{1}.{2}",
											ver.Major,
											ver.Minor,
											ver.Build );
			}
			catch {}

			try
			{
				string termPath = Path.Combine( instDir, "AiBTerminal.exe" );
				Version ver = Assembly.LoadFile(termPath).GetName().Version;
				termVerStr = String.Format( "{0}.{1}.{2}",
											ver.Major,
											ver.Minor,
											ver.Build );
			}
			catch {}

			try
			{
				AssemblyCopyrightAttribute attr;
				Assembly asm = Assembly.GetExecutingAssembly();
				Version ver = asm.GetName().Version;
				commonUtlVerStr = String.Format( "{0}.{1}.{2}",
											ver.Major,
											ver.Minor,
											ver.Build );

				Type type = typeof( AssemblyCopyrightAttribute );
				attr = asm.GetCustomAttributes(type, false)[0]
					   as AssemblyCopyrightAttribute;
				copyrightLine = attr.Copyright;
			}
			catch {}

			try
			{
				string winpinPath = Environment.GetFolderPath( Environment.SpecialFolder.ProgramFiles );
				winpinPath = Path.Combine( winpinPath, "NBS" );
				winpinPath = Path.Combine( winpinPath, "WinPin.exe" );
				winpinVerStr = FileVersionInfo.GetVersionInfo(winpinPath).FileVersion;
				winpinDateStr = " ("
								+ new FileInfo(winpinPath).LastWriteTime.ToString()
								+ ")";

				string pinctrlPath = Path.Combine( instDir, "PinCtrl.dll" );
				pinctrlVerStr =FileVersionInfo.GetVersionInfo(pinctrlPath).FileVersion;
				pinctrlDateStr = " ("
								 + new FileInfo(pinctrlPath).LastWriteTime.ToString()
								 + ")";
			}
			catch {}

			_VersionInfoTextBox.Text = String.Format(
				@"AiB Tools {0}
{1}
http://sgry.jp/aibtools

Component versions:
- AiB Edit {2}
- AiB Terminal {3}
- CommonUtl {4}
- Bundled PinBraille {5}
- WinPin {6}{7}
- PinCtrl {8}{9}",
				toolsVerStr,
				copyrightLine,
				editVerStr,
				termVerStr,
				commonUtlVerStr,
				pinBrailleVerStr,
				winpinVerStr,
				(winpinDateStr ?? ""),
				pinctrlVerStr,
				(pinctrlDateStr ?? "") );
			_VersionInfoTextBox.Select(0, 0);
			_TextBoxBrailler.UpdateDisplay();
		}

		/// <summary>
		/// ダイアログで使用する点字表示クライアントを初期化します。
		/// </summary>
		protected override void InstallBraillers()
		{
			_ControlBrailler.Init();
			_ControlBrailler.Add( _OkButton );

			_TextBoxBrailler.Init();
			_TextBoxBrailler.Add( _VersionInfoTextBox );
		}

		/// <summary>
		/// ダイアログで使用した点字表示クライアントのリソースを解放します。
		/// </summary>
		protected override void UninstallBraillers()
		{
			_ControlBrailler.Dispose();
			_TextBoxBrailler.Dispose();
		}

		/// <summary>
		/// ダイアログのコントロールを読み上げる内部スクリーンリーダを初期化します。
		/// </summary>
		protected override void InstallReaders()
		{
			_TextBoxReader.Add( _VersionInfoTextBox );
		}

		/// <summary>
		/// ダイアログのコントロールを読み上げる内部スクリーンリーダのリソースを解放します。
		/// </summary>
		protected override void UninstallReaders()
		{
			_TextBoxReader.Dispose();
		}

		ControlBrailler	_ControlBrailler	= new ControlBrailler();
		TextBoxBrailler	_TextBoxBrailler	= new TextBoxBrailler();
		TextBoxReader	_TextBoxReader		= new TextBoxReader();
	}
}
