// file: TextEditorFactory.cs
// brief: a class factory for switching Windows' RichEdit and Azuki
// update: 2008-11-16
//=========================================================
using System;
using System.Windows.Forms;
using Font = System.Drawing.Font;

namespace Sgry.AiBTools.Gui
{
	using AT;
	using Azuki;
	using Azuki.Windows;

	/// <summary>
	/// eLXgGfB^i̐
	/// </summary>
	public static class TextEditorFactory
	{
		/// <summary>
		/// eLXgGfB^i𐶐
		/// </summary>
		public static ITextEditor CreateEditor( string name )
		{
			if( String.Compare(name, "Azuki", true) == 0 )
			{
				AzukiEdit azuki = new AzukiEdit();

				azuki.Font = new Font(
						"MS Gothic",
						SystemInformation.MenuFont.Size
					);
				
				return azuki;
			}
			else// if( String.Compare(name, "RichEdit", true) == 0 )
			{
				SgRichEdit rich = new SgRichEdit();
				rich.WordWrap = false;
				rich.Font = new Font(
						"MS Gothic",
						SystemInformation.MenuFont.Size
					);

				return rich;
			}
		}

		/// <summary>
		/// w肵ÕeLXgGfB^ipɓ_\IuWFNg𐶐B
		/// </summary>
		public static TextEditorBrailler CreateBrailler( string name )
		{
			return TextEditorBrailler.Inst;
		}

		/// <summary>
		/// w肵ÕeLXgGfB^ipɓǂݏグIuWFNg𐶐B
		/// </summary>
		public static IControlReader<Control> CreateReader( string name )
		{
			if( String.Compare(name, "Azuki", true) == 0 )
			{
				return (IControlReader<Control>)new AzukiEditReader();
			}
			else// if( String.Compare(name, "RichEdit", true) == 0 )
			{
				return new DummyReader();
			}
		}
	}
}
