// file: ITextEditor.cs
// brief: interface for text editor used in AiB Tools
// update: 2012-03-25
//=========================================================
using System;
using System.Drawing;
using KeyEventHandler = System.Windows.Forms.KeyEventHandler;

namespace Sgry.AiBTools.Gui
{
	/// <summary>
	/// End Of Line code.
	/// </summary>
	public enum EolCode
	{
		/// <summary>CR+LF</summary>
		CRLF,

		/// <summary>CR only</summary>
		CR,

		/// <summary>LF only</summary>
		LF
	}

	/// <summary>
	/// Cfg[h\܂B
	/// int ɃLXgƃCfg̃xlɂȂ܂B
	/// </summary>
	public enum AutoIndentMode : int
	{
		/// <summary>
		/// Cfgs܂B
		/// </summary>
		None = 0,

		/// <summary>
		/// Os̃CfgƓCfgōs[hłB
		/// </summary>
		General = 1,

		/// <summary>
		/// X}[gCfg[hłB
		/// \𔻒fčœKȎCfgs܂B
		/// </summary>
		Smart = 2
	}

	/// <summary>
	/// AiB Tools ŗpeLXgGfB^ĩC^tF[X
	/// </summary>
	public interface ITextEditor
	{
		#region Init / Dispose
		/// <summary>
		/// gpĂ郊\[X
		/// </summary>
		void Dispose();
		#endregion

		#region Modes
		/// <summary>
		/// ҏWeǂݎpǂ擾܂͐ݒ肵܂B
		/// </summary>
		bool ReadOnly
		{
			get; set;
		}

		/// <summary>
		/// ㏑[hǂ擾܂͐ݒ肵܂B
		/// </summary>
		bool IsOverwriteMode
		{
			get; set;
		}

		/// <summary>
		/// Home L[ōsł͂Ȃŏ̔󔒕ɃLbgړ邩ǂ
		/// </summary>
		bool UseSmartHome
		{
			get; set;
		}

		/// <summary>
		/// wt@Cʗp̃[hɐ؂ւB
		/// Ή̎ʖw肷ƕW[hɂȂB
		/// </summary>
		void SetFileType( string typeName, AutoIndentMode indentMode );
		#endregion

		#region GUI
		/// <summary>
		/// Rg[\
		/// </summary>
		void Show();

		/// <summary>
		/// Rg[\ɂ
		/// </summary>
		void Hide();

		/// <summary>
		/// Rg[ANeBuɂ
		/// </summary>
		void Select();

		/// <summary>
		/// Rg[ɓ̓tH[JXݒ
		/// </summary>
		/// <returns>̓tH[JXݒłꍇ true</returns>
		bool Focus();

		/// <summary>
		/// ̃Rg[ɓ̓tH[JX邩ǂ
		/// </summary>
		bool Focused
		{
			get;
		}

		/// <summary>
		/// Lbg\悤ɃXN[
		/// </summary>
		void ScrollToCaret();
		#endregion

		/// <summary>
		/// ҏWԂǂ擾܂͐ݒ肵܂B
		/// </summary>
		bool IsDirty
		{
			get; set;
		}

		#region Text
		/// <summary>
		/// ݓ͂ĂeLXg擾܂͐ݒ肵܂B
		/// 擾̓eLXgobt@Rs[܂B
		/// </summary>
		string Text
		{
			get; set;
		}
		
		/// <summary>
		/// ݓ͂ĂeLXg̕擾
		/// </summary>
		/// <returns>͂ĂeLXg̕</returns>
		int TextLength
		{
			get;
		}

		/// <summary>
		/// wʒu̕擾
		/// </summary>
		/// <exception cref="ArgumentOutOfRangeException">CfbNXLȔ͈͂ɂ܂B</exception>
		char GetCharAt( int index );

		/// <summary>
		/// ݓ͂ĂeLXgw肵sR[hŎ擾
		/// </summary>
		string GetText( EolCode eolCode );

		/// <summary>
		/// Replace currently selected text into the specified text.
		/// If nothing selected, specified text will be inserted at caret pos.
		/// </summary>
		void Replace( string text );

		/// <summary>
		/// eLXgׂč폜
		/// </summary>
		void Clear();
		#endregion

		#region Selection
		/// <summary>
		/// ݑIĂeLXg
		/// </summary>
		string SelectedText
		{
			get; set;
		}

		/// <summary>
		/// IւƍsĂ邩ǂ
		/// </summary>
		bool SelectingToEnd
		{
			get;
		}
		
		/// <summary>
		/// I̋N_̃CfbNX擾
		/// </summary>
		int SelectionAnchor
		{
			get;
		}
		
		/// <summary>
		/// eLXg̑I͈͂uȏ㖢vŎ擾B
		/// SetSelection ƈႢAJ[\AJ[̈ʒu͊֌WȂB
		/// </summary>
		/// <param name="begin">IĂŏ̃̕CfbNX</param>
		/// <param name="end">IĂŌ̃̕CfbNX</param>
		void GetSelection( out int begin, out int end );

		/// <summary>
		/// eLXg̑IԂݒ
		/// </summary>
		/// <param name="anchor">ĨAJ[̃CfbNX</param>
		/// <param name="caretIndex">Lbg̃CfbNX</param>
		void SetSelection( int anchor, int caretIndex );

		/// <summary>
		/// ͂Ă邷ׂẴeLXgI
		/// </summary>
		void SelectAll();
		#endregion

		#region Events
		/// <summary>
		/// ̓tH[JX󂯎Ɣ܂B
		/// </summary>
		event EventHandler GotFocus;

		/// <summary>
		/// ̓tH[JXƔ܂B
		/// </summary>
		event EventHandler Leave;

		/// <summary>
		/// ̓tH[JX鎞ɃL[Ɣ܂B
		/// </summary>
		event KeyEventHandler KeyDown;

		/// <summary>
		/// ̓tH[JX鎞ɃL[Ɣ܂B
		/// </summary>
		event KeyEventHandler KeyUp;
		
		/// <summary>
		/// eωƔ܂B
		/// </summary>
		event EventHandler ContentChanged;
		
		/// <summary>
		/// IԂωƔ܂B
		/// IԂŃLbgړĂ܂B
		/// </summary>
		event EventHandler SelectionChanged;

		/// <summary>
		/// IsDirty vpeBύXꂽɔ܂B
		/// </summary>
		event EventHandler DirtyStateChanged;
		#endregion

		#region Edit action
		/// <summary>
		/// UNDO s
		/// </summary>
		void Undo();
		
		/// <summary>
		/// UNDO obt@NA
		/// </summary>
		void ClearUndo();

		/// <summary>
		/// IĂeLXg؂
		/// </summary>
		void Cut();
		
		/// <summary>
		/// IĂeLXgNbv{[hɃRs[
		/// </summary>
		void Copy();

		/// <summary>
		/// IĂeLXg폜
		/// </summary>
		void Delete();
		
		/// <summary>
		/// Nbv{[h̓e\t
		/// </summary>
		void Paste();
		#endregion

		#region Line level action
		/// <summary>
		/// ǂݍłt@C̍s擾
		/// </summary>
		/// <returns>t@C̍s</returns>
		int GetLineCount();

		/// <summary>
		/// ws̒ij擾
		/// </summary>
		/// <param name="lineIndex">擾s̃CfbNX</param>
		/// <returns>s̒ij</returns>
		int GetLineLength( int lineIndex );
		
		/// <summary>
		/// ws擾
		/// </summary>
		/// <param name="lineIndex">擾s̃CfbNX</param>
		/// <returns>ws̓e</returns>
		string GetLineContent( int lineIndex );
		
		/// <summary>
		/// ws̐擪́AeLXgŜł̃CfbNX擾
		/// </summary>
		/// <param name="lineIndex">sCfbNX擾s̔ԍ</param>
		/// <returns>CfbNXis:-1j</returns>
		int GetLineHeadIndex( int lineIndex );

		/// <summary>
		/// w肵CfbNXw܂ލs̔ԍ擾
		/// </summary>
		/// <param name="index">̃CfbNXw܂ލs̔ԍ擾܂B</param>
		/// <returns>sԍ</returns>
		int GetLineIndexFromCharIndex( int index );
		#endregion

		#region Word level action
		/// <summary>
		/// w肵CfbNX܂ޒP擾
		/// </summary>
		/// <param name="index">CfbNX</param>
		/// <returns>P</returns>
		string GetWordAt( int index );
		#endregion

		#region Caret
		/// <summary>
		/// LbgʒũCfbNX擾
		/// </summary>
		int GetCaretIndex();

		/// <summary>
		/// LbgʒũCfbNX擾
		/// </summary>
		/// <param name="lineIndex">Lbg̍sCfbNX</param>
		/// <param name="columnIndex">LbǧCfbNX</param>
		void GetCaretIndex( out int lineIndex, out int columnIndex );

		/// <summary>
		/// Lbgʒuݒ
		/// </summary>
		/// <param name="lineIndex">Lbgړ̍sCfbNX</param>
		/// <param name="columnIndex">Lbgړ̌CfbNX</param>
		void SetCaretIndex( int lineIndex, int columnIndex );
		#endregion

		/// <summary>
		/// ֘AÂꂽCӂ̃IuWFNgݒ܂͎擾܂B
		/// </summary>
		object Tag
		{
			get; set;
		}
	}
}
