// file: AiBFormBase.cs
// brief: base class of a form with braille device control logic.
// update: 2008-12-20
//=========================================================
using System;
using System.Windows.Forms;

namespace Sgry.AiBTools.Gui
{
	using AT;

	/// <summary>
	/// _\֘A@\tH[B
	/// E[h^A[hɓ_\E\̏^̃ev[g\bhĂяo
	/// EANeBuɂȂ鎞ɓ_T[oɃA^b`ELl
	/// EANeBuɂȂ鎞ɐL
	/// </summary>
	public abstract class AiBFormBase : Form
	{
		#region Init / Dispose
		/// <summary>
		/// GUI ̏I̓B
		/// </summary>
		protected override void OnLoad( EventArgs e )
		{
			// 蓮̑Oɓ_E̕\CXg[B
			// ȋOłȂƁAqNXƎɕ`悵ꍇɖĂ܂j
			InstallBraillers();
			InstallReaders();

			// 蓮s
			base.OnLoad( e );
		}

		/// <summary>
		/// \[X܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			UninstallReaders();
			UninstallBraillers();

			base.Dispose( disposing );
		}
		#endregion

		#region UI Cxgnh
		/// <summary>
		/// _CAOANeBuɂȂ̓B
		/// </summary>
		protected override void OnActivated( EventArgs e )
		{
			// _fBXvC̐ɍĊJ
			try
			{
				NbsEngine.Instance.AttachToServer();
				NbsEngine.Instance.Lock();
			}
			catch( NbsException )
			{
				//DO_NOT//NbsMessageBox.Show( this, ex.Message, MessageBoxButtons.OK, MessageBoxIcon.Information );
			}

			base.OnActivated( e );
		}

		/// <summary>
		/// _CAOANeBułȂȂ̓B
		/// </summary>
		protected override void OnDeactivate( EventArgs e )
		{
			base.OnDeactivate( e );

			// _fBXvC̎gp
			if( NbsEngine.Instance.IsAttached )
			{
				NbsEngine.Instance.Unlock();
			}
		}
		#endregion

		#region Template Methods
		/// <summary>
		/// _CAOŎgp_\NCAg܂B
		/// </summary>
		protected abstract void InstallBraillers();

		/// <summary>
		/// _CAOŎgp_\NCAg̃\[X܂B
		/// </summary>
		protected abstract void UninstallBraillers();

		/// <summary>
		/// _CAÕRg[ǂݏグXN[[_܂B
		/// </summary>
		protected abstract void InstallReaders();

		/// <summary>
		/// _CAÕRg[ǂݏグXN[[_̃\[X܂B
		/// </summary>
		protected abstract void UninstallReaders();
		#endregion
	}
}
