// file: AiBDialogBase.cs
// brief: base class of a dialog window with braille device control logic.
// update: 2010-01-28
//=========================================================
using System;
using System.Windows.Forms;

namespace Sgry.AiBTools.Gui
{
	using AT;

	/// <summary>
	/// _\Ȃǂ̊{@\_CAÕx[XNXB
	/// AiBFormBase ̋@\ɉĎ̋@\B
	/// EeEBhE̒ʒuŕ\
	/// Eȓ_\LɈꎞύX
	/// EEscape L[ł̏I
	/// </summary>
	public abstract class AiBDialogBase : AiBFormBase
	{
		BrailleConfig _OriginalConfig = null;

		#region Init / Dispose
		/// <summary>
		/// VCX^X𐶐܂B
		/// </summary>
		public AiBDialogBase()
		{
			StartPosition = FormStartPosition.CenterParent;
			ShowInTaskbar = false;
		}

		/// <summary>
		/// GUI ̏I̓B
		/// </summary>
		protected override void OnLoad( EventArgs e )
		{
			base.OnLoad( e );

			if( NbsEngine.Instance.IsAttached )
			{
				// W̓_̌nɐݒ
				_OriginalConfig = NbsEngine.Instance.BrailleConfig;
				NbsEngine.Instance.BrailleConfig = new BrailleConfig();
			}
		}
		#endregion

		#region UI Cxgnh
		/// <summary>
		/// _CAO̓B
		/// </summary>
		protected override void OnClosed( EventArgs e )
		{
			base.OnClosed( e );

			// _CAO\O̓_\Ľnɖ߂
			if( _OriginalConfig != null )
			{
				NbsEngine.Instance.BrailleConfig = _OriginalConfig;
			}
		}

		/// <summary>
		/// _CAÕtH[JXȂǂs߂̃L[B
		/// </summary>
		protected override bool ProcessDialogKey( Keys keyData )
		{
			if( keyData == Keys.Escape )
			{
				this.DialogResult = DialogResult.Cancel;
				this.Close();
				return true;
			}

			return base.ProcessDialogKey( keyData );
		}
		#endregion
	}
}
