﻿// file: ResultItem.cs
// brief: represents one item of compilation result.
// encoding: UTF-8
// update: 2008-12-07
//=========================================================
using System;

namespace Sgry.AiBTools.Compilation
{
	/// <summary>
	/// コンパイル結果として出力される情報の一項目を表します。
	/// </summary>
	public class ResultItem
	{
		#region Fields
		string		_Message;
		string		_FilePath;
		int			_LineIndex;
		int			_ColumnIndex;
		ResultType	_Type;
		#endregion

		#region Init / Dispose
		/// <summary>
		/// 新しいインスタンスを生成します。
		/// </summary>
		public ResultItem( string message, string filePath, int lineIndex, int columnIndex, ResultType type )
		{
			_Message = message;
			_FilePath = filePath;
			_LineIndex = lineIndex;
			_ColumnIndex = columnIndex;
			_Type = type;
		}
		#endregion

		#region Property
		/// <summary>
		/// コンパイラからのメッセージを取得します。
		/// </summary>
		public string Message
		{
			get{ return _Message; }
		}

		/// <summary>
		/// コンパイル対象ファイルのパスを取得します。
		/// </summary>
		public string FilePath
		{
			get{ return _FilePath; }
		}
		
		/// <summary>
		/// コンパイル結果の位置の行インデックスを取得します。
		/// </summary>
		public int LineIndex
		{
			get{ return _LineIndex; }
		}

		/// <summary>
		/// コンパイル結果の位置の行インデックスを取得します。
		/// </summary>
		public int ColumnIndex
		{
			get{ return _ColumnIndex; }
		}

		/// <summary>
		/// コンパイル結果の種類を取得します。
		/// </summary>
		public ResultType Type
		{
			get{ return _Type; }
		}
		#endregion
	}

	/// <summary>
	/// コンパイル結果項目の種類を表します。
	/// </summary>
	public enum ResultType
	{
		/// <summary>警告を表します。</summary>
		Warning,

		/// <summary>エラーを表します。</summary>
		Error
	}
}
