// file: OutputForm.cs
// brief: dialog box to show output log.
// encoding: UTF-8
// update: 2008-12-07
//=========================================================
using System;
using System.Drawing;
using System.Windows.Forms;

namespace Sgry.AiBTools.Compilation
{
	using Gui;
	using AT;

	/// <summary>
	/// o͂ꂽO\_CAO{bNXB
	/// </summary>
	public class OutputForm : AiBDialogBase
	{
		#region Init / Dispose
		/// <summary>
		/// tH[
		/// </summary>
		/// <param name="output">\镶</param>
		public OutputForm( string output )
		{
			InitializeComponent();

			// localize UI
			Localizer localizer = new Localizer();
			localizer.LoadResourceFile( "CommonUtl" );
			this.Text = localizer.TryGetString( "OutputForm.Text", "_csc output" );

			_Edit_Output.Text = output;
			_Edit_Output.SetSelection( 0, 0 );
		}
		#endregion

		#region tH[JX
		void Form_Shown( object sender, EventArgs e )
		{
			if( JawsSpeaker.IsAlive() )
			{
				JawsSpeaker.Instance.Stop();
			}
		}
		#endregion

		#region UI Component Initialization
		/// <summary>
		/// _CAOŎgp_\NCAg܂B
		/// </summary>
		protected override void InstallBraillers()
		{
			TextEditorBrailler.Inst.Add( _Edit_Output );
			_ControlBrailler.Init();
			_ControlBrailler.Add( _Button_Close );
		}

		/// <summary>
		/// _CAOŎgp_\NCAg̃\[X܂B
		/// </summary>
		protected override void UninstallBraillers()
		{
			TextEditorBrailler.Inst.Remove( _Edit_Output );
			_ControlBrailler.Dispose();
		}

		/// <summary>
		/// _CAÕRg[ǂݏグXN[[_܂B
		/// </summary>
		protected override void InstallReaders()
		{}

		/// <summary>
		/// _CAÕRg[ǂݏグXN[[_̃\[X܂B
		/// </summary>
		protected override void UninstallReaders()
		{}

		void InitializeComponent()
		{
			_Button_Close = new Button();
			SuspendLayout();
			// 
			// _Edit_Output
			// 
			_Edit_Output.Anchor = AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right;
			_Edit_Output.Font = new Font("MS Gothic", 10);
			_Edit_Output.Location = new Point(0, 0);
			_Edit_Output.Multiline = true;
			_Edit_Output.AcceptsTab = false;
			_Edit_Output.Name = "_Edit_Output";
			_Edit_Output.ReadOnly = true;
			_Edit_Output.Size = new Size(632, 416);
			_Edit_Output.TabIndex = 0;
			_Edit_Output.Text = "";
			// 
			// _Button_Close
			// 
			_Button_Close.Anchor = AnchorStyles.Bottom;
			_Button_Close.DialogResult = DialogResult.Cancel;
			_Button_Close.Location = new Point(268, 424);
			_Button_Close.Name = "_Button_Close";
			_Button_Close.Size = new Size(104, 23);
			_Button_Close.TabIndex = 1;
			_Button_Close.Text = "&Close";
			// 
			// OutputForm
			// 
			AcceptButton = _Button_Close;
			AutoScaleBaseSize = new Size(5, 12);
			CancelButton = _Button_Close;
			ClientSize = new Size(632, 453);
			Controls.Add( _Edit_Output );
			Controls.Add( _Button_Close );
			Name = "OutputForm";
			Text = "OutputForm";
			Shown += Form_Shown;
			ResumeLayout(false);
		}
		#endregion
		
		#region UI Components
		SgRichEdit		_Edit_Output = new SgRichEdit();
		Button			_Button_Close;
		ControlBrailler	_ControlBrailler = new ControlBrailler();
		#endregion
	}
}
