// file: NowCompilingForm.cs
// brief: dialog box to show "now compiling".
// encoding: UTF-8
// update: 2010-05-09
//=========================================================
using System;
using System.Windows.Forms;

namespace Sgry.AiBTools.Compilation
{
	using AT;

	/// <summary>
	/// RpCł邱Ƃ\_CAO{bNXB
	/// </summary>
	public class NowCompilingForm : Form
	{
		Label _Label = new Label();
		Compiler _Compiler;
		Localizer _Localizer = new Localizer();

		/// <summary>
		/// VCX^X𐶐܂B
		/// </summary>
		public NowCompilingForm( Compiler compiler )
		{
			InitializeComponent();
			LocalizeComponents();

			Activated += Form_Activated;
			Deactivate += Form_Deactivate;
			Shown += Form_Shown;

			_Compiler = compiler;
		}

		void Form_Activated( object sender, EventArgs e )
		{
			if( JawsSpeaker.IsAlive() )
			{
				ISpeaker speaker = JawsSpeaker.Instance;
				speaker.Stop();
				speaker.Speak( Text );
			}
			NbsEngine.Instance.AttachToServer();
			NbsEngine.Instance.Lock();
			NbsEngine.Instance.CursorMode = CursorMode.None;
			NbsEngine.Instance.Write( Text, 0, 0, null, LineEndMark.None );
		}

		void Form_Deactivate( object sender, EventArgs e )
		{
			NbsEngine.Instance.Unlock();
		}

		void Form_Shown( object sender, EventArgs e )
		{
			Refresh();
			_Compiler.Compile();
			Close();
		}

		#region UI Component Initialization
		/// <summary>
		/// [JCY
		/// </summary>
		void LocalizeComponents()
		{
			_Localizer.LoadResourceFile( "CommonUtl" );
			_Localizer.TryGetString( "NowCompilingForm.Text", this );
			_Localizer.TryGetString( "NowCompilingForm._Label.Text", _Label );
		}

		void InitializeComponent()
		{
			this.SuspendLayout();
			// 
			// _Label
			// 
			_Label.Dock = DockStyle.Fill;
			_Label.Name = "_Label";
			_Label.TabIndex = 0;
			_Label.Text = "Now compiling...";
			_Label.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// NowCompilingForm
			// 
			ClientSize = new System.Drawing.Size(232, 88);
			ControlBox = false;
			Text = "Now compiling...";
			Controls.Add( _Label );
			MaximizeBox = false;
			MinimizeBox = false;
			Name = "NowCompilingForm";
			ResumeLayout(false);
   		}
		#endregion
	}
}
