// file: AiBExceptionHandler.cs
// brief: custom exception handler for AiB Tools
// encoding: UTF-8
// update: 2012-03-25
//=========================================================
using System;
using System.Threading;
using System.Windows.Forms;
using CultureInfo = System.Globalization.CultureInfo;

namespace Sgry.AiBTools
{
	using Gui;

	/// <summary>
	/// ̓ANZVuȗOʒm_CAOONX
	/// </summary>
	public class AiBExceptionHandler
	{
		/// <summary>
		/// Xbhł̖O郁\bh
		/// </summary>
		public static void OnThreadException( object sender, ThreadExceptionEventArgs e )
		{
			Form dialog;
			DialogResult result;
			
			dialog = new AiBExceptionDialog( e.Exception );
			result = dialog.ShowDialog();
			if( result == DialogResult.Abort )
			{
				Application.Exit();
			}
			/*else if( result == DialogResult.Ignore )
			{
				;
			}*/
		}
	}

	/// <summary>
	/// AiB Tools p̃JX^Oʒm_CAOB
	/// ShowDialog ̕Ԓl Ignore ȂpAAbort ȂIB
	/// </summary>
	class AiBExceptionDialog : Form
	{
		static readonly char[] EolChars = new char[]{ '\r', '\n' };
		string _TitleString = Application.ProductName + " - Exception occured.";

		#region Init / Dispose
		/// <summary>
		/// VCX^X𐶐
		/// </summary>
		public AiBExceptionDialog( Exception ex )
		{
			InitializeComponent();
			LocalizeComponent();
			ParseException( ex );
			
			AcceptButton = _ContinueButton;
			CancelButton = _ContinueButton;
			this.Font
				= _TypeTextBox.Font
				= _MessageTextBox.Font
				= _StacktraceTextBox.Font = SystemInformation.MenuFont;
			this.DialogResult = DialogResult.Ignore;
		}

		void ParseException( Exception ex )
		{
			// O\
			_TypeTextBox.Text = ex.GetType().ToString();
			_TypeTextBox.SetSelection( 0, 0 );
			_TypeTextBox.ScrollToCaret();
			
			// bZ[W\
			_MessageTextBox.Text = ex.Message;
			_MessageTextBox.SetSelection( 0, 0 );
			_MessageTextBox.ScrollToCaret();
			
			// X^bNg[XsƂɃXg֒ǉ
			_StacktraceTextBox.Text = ex.StackTrace;
			_StacktraceTextBox.SetSelection( 0, 0 );
			_StacktraceTextBox.ScrollToCaret();

			// _CAÕ^Cgݒ
			Text = _TitleString;
		}
		#endregion

		#region UI Event Handlers
		void _QuitButton_Click( object sender, EventArgs e )
		{
			this.DialogResult = DialogResult.Abort;
			this.Close();
		}

		void _ContinueButton_Click( object sender, EventArgs e )
		{
			this.Close();
		}
		#endregion

		#region UI Component Initialization
		void InitializeComponent()
		{
			this._QuitButton = new Button();
			this._StacktraceLabel = new Label();
			this._ContinueButton = new Button();
			this._MessageLabel = new Label();
			this._TypeLabel = new Label();
			this._TypeTextBox = new SgRichEdit();
			this._StacktraceTextBox = new SgRichEdit();
			this._MessageTextBox = new SgRichEdit();
			this.SuspendLayout();
			// 
			// _QuitButton
			// 
			this._QuitButton.Anchor = AnchorStyles.Bottom | AnchorStyles.Right;
			this._QuitButton.DialogResult = DialogResult.Cancel;
			this._QuitButton.Location = new System.Drawing.Point( 386, 271 );
			this._QuitButton.Margin = new Padding( 0 );
			this._QuitButton.Name = "_QuitButton";
			this._QuitButton.Size = new System.Drawing.Size( 90, 24 );
			this._QuitButton.TabIndex = 7;
			this._QuitButton.Text = "&Quit";
			this._QuitButton.UseVisualStyleBackColor = true;
			this._QuitButton.Click += new System.EventHandler( this._QuitButton_Click );
			// 
			// _StacktraceLabel
			// 
			this._StacktraceLabel.Anchor = AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right;
			this._StacktraceLabel.Location = new System.Drawing.Point( 14, 144 );
			this._StacktraceLabel.Name = "_StacktraceLabel";
			this._StacktraceLabel.Size = new System.Drawing.Size( 460, 17 );
			this._StacktraceLabel.TabIndex = 4;
			this._StacktraceLabel.Text = "Stack trace";
			this._StacktraceLabel.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// _ContinueButton
			// 
			this._ContinueButton.Anchor = AnchorStyles.Bottom | AnchorStyles.Right;
			this._ContinueButton.DialogResult = DialogResult.Cancel;
			this._ContinueButton.Location = new System.Drawing.Point( 285, 271 );
			this._ContinueButton.Margin = new Padding( 0 );
			this._ContinueButton.Name = "_ContinueButton";
			this._ContinueButton.Size = new System.Drawing.Size( 90, 24 );
			this._ContinueButton.TabIndex = 6;
			this._ContinueButton.Text = "&Continue";
			this._ContinueButton.UseVisualStyleBackColor = true;
			this._ContinueButton.Click += new System.EventHandler( this._ContinueButton_Click );
			// 
			// _MessageLabel
			// 
			this._MessageLabel.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
			this._MessageLabel.Location = new System.Drawing.Point( 16, 67 );
			this._MessageLabel.Name = "_MessageLabel";
			this._MessageLabel.Size = new System.Drawing.Size( 460, 17 );
			this._MessageLabel.TabIndex = 2;
			this._MessageLabel.Text = "Message";
			this._MessageLabel.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// _TypeLabel
			// 
			this._TypeLabel.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
			this._TypeLabel.Location = new System.Drawing.Point( 16, 9 );
			this._TypeLabel.Margin = new Padding( 3, 9, 3, 3 );
			this._TypeLabel.Name = "_TypeLabel";
			this._TypeLabel.Size = new System.Drawing.Size( 460, 17 );
			this._TypeLabel.TabIndex = 0;
			this._TypeLabel.Text = "Exception type";
			this._TypeLabel.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// _TypeTextBox
			// 
			this._TypeTextBox.AcceptsReturn = false;
			this._TypeTextBox.AcceptsTab = false;
			this._TypeTextBox.AccessibleName = "Exception Type";
			this._TypeTextBox.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
			this._TypeTextBox.BackColor = System.Drawing.Color.Red;
			this._TypeTextBox.EnableMsaa = false;
			this._TypeTextBox.Font = new System.Drawing.Font( "MS UI Gothic", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(128)) );
			this._TypeTextBox.Location = new System.Drawing.Point( 16, 29 );
			this._TypeTextBox.Multiline = false;
			this._TypeTextBox.Name = "_TypeTextBox";
			this._TypeTextBox.ReadOnly = true;
			this._TypeTextBox.SelectedText = "";
			this._TypeTextBox.Size = new System.Drawing.Size( 460, 35 );
			this._TypeTextBox.TabIndex = 1;
			// 
			// _StacktraceTextBox
			// 
			this._StacktraceTextBox.AcceptsReturn = false;
			this._StacktraceTextBox.AcceptsTab = false;
			this._StacktraceTextBox.AccessibleName = "Stacktrace";
			this._StacktraceTextBox.Anchor = AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right;
			this._StacktraceTextBox.BackColor = System.Drawing.Color.Red;
			this._StacktraceTextBox.EnableMsaa = false;
			this._StacktraceTextBox.Font = new System.Drawing.Font( "MS UI Gothic", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(128)) );
			this._StacktraceTextBox.Location = new System.Drawing.Point( 16, 164 );
			this._StacktraceTextBox.Name = "_StacktraceTextBox";
			this._StacktraceTextBox.ReadOnly = true;
			this._StacktraceTextBox.SelectedText = "";
			this._StacktraceTextBox.Size = new System.Drawing.Size( 460, 95 );
			this._StacktraceTextBox.TabIndex = 5;
			// 
			// _MessageTextBox
			// 
			this._MessageTextBox.AcceptsReturn = false;
			this._MessageTextBox.AcceptsTab = false;
			this._MessageTextBox.AccessibleName = "Message";
			this._MessageTextBox.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
			this._MessageTextBox.BackColor = System.Drawing.Color.Red;
			this._MessageTextBox.EnableMsaa = false;
			this._MessageTextBox.Font = new System.Drawing.Font( "MS UI Gothic", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(128)) );
			this._MessageTextBox.Location = new System.Drawing.Point( 16, 87 );
			this._MessageTextBox.Name = "_MessageTextBox";
			this._MessageTextBox.ReadOnly = true;
			this._MessageTextBox.SelectedText = "";
			this._MessageTextBox.Size = new System.Drawing.Size( 460, 52 );
			this._MessageTextBox.TabIndex = 3;
			this._MessageTextBox.WordWrap = true;
			// 
			// AiBExceptionDialog
			// 
			this.AccessibleRole = AccessibleRole.Dialog;
			this.AutoScaleDimensions = new System.Drawing.SizeF( 6F, 12F );
			this.AutoScaleMode = AutoScaleMode.Font;
			this.ClientSize = new System.Drawing.Size( 492, 307 );
			this.Controls.Add( this._TypeLabel );
			this.Controls.Add( this._TypeTextBox );
			this.Controls.Add( this._MessageLabel );
			this.Controls.Add( this._MessageTextBox );
			this.Controls.Add( this._StacktraceLabel );
			this.Controls.Add( this._StacktraceTextBox );
			this.Controls.Add( this._ContinueButton );
			this.Controls.Add( this._QuitButton );
			this.MinimizeBox = false;
			this.Name = "AiBExceptionDialog";
			this.SizeGripStyle = SizeGripStyle.Hide;
			this.StartPosition = FormStartPosition.CenterScreen;
			this.Text = "Exception occured";
			this.ResumeLayout( false );

		}
		
		void LocalizeComponent()
		{
			if( CultureInfo.CurrentUICulture.Name.StartsWith("ja") )
			{
				_TitleString = Application.ProductName + " - O܂";
				_TypeLabel.Text = "Ǒ^";
				_MessageLabel.Text = "bZ[W";
				_StacktraceLabel.Text = "X^bN g[X";
				_ContinueButton.Text = "p(&C)";
				_QuitButton.Text = "I(&Q)";
			} 
		}
		#endregion

		#region UI Components
		Label _TypeLabel;
		SgRichEdit _TypeTextBox;
		Label _MessageLabel;
		SgRichEdit _MessageTextBox;
		Label _StacktraceLabel;
		SgRichEdit _StacktraceTextBox;
		Button _ContinueButton;
		Button _QuitButton;
		#endregion
	}
}
