﻿// file: IControlReader.cs
// brief: a common interface for control readers
// encoding: UTF-8
// update: 2007-08-21
//=========================================================
using System;
using Control = System.Windows.Forms.Control;

namespace Sgry.AiBTools.AT
{
	/// <summary>
	/// GUI 部品のイベントを監視して、
	/// その内容を音声読み上げするオブジェクトが持つインタフェース
	/// </summary>
	public interface IControlReader<T> : IDisposable where T : Control
	{
		/// <summary>
		/// 監視するコントロールを追加。
		/// </summary>
		/// <param name="control">監視対象のコントロール</param>
		void Add( T control );

		/// <summary>
		/// 監視対象をすべて登録解除。
		/// </summary>
		void Clear();
	}
}
