﻿// file: ComboBoxReader.cs
// brief: internal screen reader for System.Windows.Forms.ComboBox
// encoding: UTF-8
// update: 2008-09-14
//=========================================================
using System;
using System.Collections.Generic;
using System.Windows.Forms;
using Debug = System.Diagnostics.Debug;

namespace Sgry.AiBTools.AT
{
	/// <summary>
	/// コンボボックスを音声読み上げする内部スクリーンリーダー
	/// </summary>
	// XPReader は MSAA の通知に対応していないのか？イベントに反応しないので、
	// このクラスでイベントが発生するタイミングで外部制御する
	public class ComboBoxReader : IControlReader<ComboBox>
	{
		List<ComboBox> _Controls = new List<ComboBox>();

		#region Init / Dispose
		/// <summary>
		/// リソースを解放
		/// </summary>
		public void Dispose()
		{
			Clear();
		}
		#endregion

		#region IControlReader interface
		/// <summary>
		/// 読み上げ対象のコントロールを追加
		/// </summary>
		public void Add( ComboBox control )
		{
			control.SelectedIndexChanged += Target_SelectedIndexChanged;

			_Controls.Add( control );
		}

		/// <summary>
		/// 読み上げ対象をすべて登録解除
		/// </summary>
		public void Clear()
		{
			foreach( ComboBox comboBox in _Controls )
			{
				comboBox.SelectedIndexChanged -= Target_SelectedIndexChanged;
			}
			_Controls.Clear();
		}
		#endregion

		#region Event handlers for target controls
		void Target_SelectedIndexChanged( object sender, EventArgs e )
		{
			ComboBox comboBox = (ComboBox)sender;

			if( comboBox.Focused != true )
				return;

			if( XpReaderSpeaker.IsAlive() )
			{
				XpReaderSpeaker.Instance.Stop();
				XpReaderSpeaker.Instance.Speak( comboBox.Text );
			}
		}
		#endregion
	}
}
