// 2010-01-24
using System;
using System.Drawing;
using System.Windows.Forms;
using CultureInfo = System.Globalization.CultureInfo;

namespace Sgry.AiBTools.AT
{
	class NbsMessageBoxForm : Form
	{
		const int PaddingBetweenButtons = 6; // K
		const int PaddingInsideForm = 10;
		NbsMessageBoxFormBrailler _Brailler = null;
		MessageBoxIcon _MessageBoxIcon;
		BrailleConfig _OriginalConfig;
		string _MessageNativeStr = "Message";
		
		public string Message
		{
			get{ return _Label.Text; }
		}

		#region Init / Dispose
		/// <summary>
		/// tH[
		/// </summary>
		public NbsMessageBoxForm( IWin32Window owner, string caption, string text, MessageBoxButtons buttons, MessageBoxIcon icon )
		{
			_MessageBoxIcon = icon;
			SuspendLayout();

			// setup message label
			_Label.Location = new System.Drawing.Point( PaddingInsideForm, PaddingInsideForm );
			_Label.TabIndex = 0;
			_Label.Text = text;
			Controls.Add( _Label );

			// setup dialog size
			using( Button dummyButton = new Button() )
			{
				// set panel for buttons
				_ButtonsPanel.Height = dummyButton.Height + PaddingInsideForm;
				_ButtonsPanel.TabIndex = 1;
				Controls.Add( _ButtonsPanel );
			}

			// setup buttons
			SetupButtons( buttons );

			// setup reader
			if( NbsEngine.Instance.IsAttached )
			{
				_OriginalConfig = NbsEngine.Instance.BrailleConfig;
				NbsEngine.Instance.BrailleConfig = new BrailleConfig();
				
				_Brailler = new NbsMessageBoxFormBrailler( this );
				foreach( Button button in _ButtonsPanel.Controls )
				{
					_Brailler.Add( button );
				}
			}

			// setup dialog
			this.Text = caption;
			this.FormBorderStyle = FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.StartPosition = FormStartPosition.CenterParent;
			this.AccessibleRole = AccessibleRole.Dialog;
			this.AccessibleName = text;
			this.Activated += new EventHandler( Form_Activated );
			this.Deactivate += new EventHandler( Form_Deactivate );

			ResumeLayout();
		}

		protected override void OnLoad( EventArgs e )
		{
			// calc size of rendered message
			using( Graphics g = this.CreateGraphics() )
			{
				_Label.Size = g.MeasureString( _Label.Text, this.Font, Width ).ToSize();
				_Label.Width = (int)( 1.5 * _Label.Width );
				_Label.Height += PaddingInsideForm;
				this.Width = (SystemInformation.Border3DSize.Width*2)
					+ _Label.Size.Width
					+ (PaddingInsideForm * 2);
			}
			
			// reset position and size of components
			_ButtonsPanel.Location = new System.Drawing.Point( 0, PaddingInsideForm*2 + _Label.Height );
			_ButtonsPanel.Width = Width - PaddingInsideForm;
			this.Height = SystemInformation.CaptionHeight + _Label.Height + _ButtonsPanel.Height + PaddingInsideForm*3;

			// resize UI with system font
			AutoScaleMode = AutoScaleMode.Font;
			this.Font = SystemInformation.MenuFont;

			// bZ[W{bNX̎ނɉĉo
			if( _MessageBoxIcon == MessageBoxIcon.None )
			{
				Win32.MessageBeep_Notify();
			}
			else if( _MessageBoxIcon == MessageBoxIcon.Error )
			{
				Win32.MessageBeep_Error();
			}
			else if( _MessageBoxIcon == MessageBoxIcon.Question )
			{
				Win32.MessageBeep_Question();
			}
			else if( _MessageBoxIcon == MessageBoxIcon.Warning )
			{
				Win32.MessageBeep_Warning();
			}
			else if( _MessageBoxIcon == MessageBoxIcon.Information )
			{
				Win32.MessageBeep_Information();
			}

			base.OnLoad( e );
		}
		
		protected override void Dispose( bool disposing )
		{
			if( _Brailler != null )
			{
				_Brailler.Dispose();
			}
			base.Dispose( disposing );
		}
		
		protected override void OnClosed( EventArgs e )
		{
			base.OnClosed( e );
			
			// _CAO\O̓_\Ľnɖ߂
			if( _OriginalConfig != null )
			{
				NbsEngine.Instance.BrailleConfig = _OriginalConfig;
			}
		}
		#endregion // Init / Dispose

		#region tH[JX
		void Form_Activated( object sender, EventArgs e )
		{
			// _fBXvC̐ĊJ
			try
			{
				NbsEngine.Instance.AttachToServer();
				NbsEngine.Instance.Lock();
				//DO_NOT//_Brailler.UpdateDisplay(); // updates on GotFocus.
			}
			catch( NbsException )
			{}
			
			// ̃EBhE Win32 ̃_CAOłȂ
			// ǂݏグXN[[_[̊OŎs
			if( AutoSpeaker.IsAlive() )
			{
				AutoSpeaker.Instance.Stop();
				if( XpReaderSpeaker.IsAlive() == false )
				{
					// 95 Reader ͘AŔƌ㑱鎖
					AutoSpeaker.Instance.Speak( _MessageNativeStr );
				}
				AutoSpeaker.Instance.Speak( _Label.Text );
			}
		}

		void Form_Deactivate( object sender, EventArgs e )
		{
			// _fBXvC̎gp
			if( NbsEngine.Instance.IsAttached )
			{
				try
				{
					NbsEngine.Instance.Unlock();
				}
				catch( NbsException )
				{}
			}
		}
		#endregion

		#region {^̒ǉ
		void SetupButtons( MessageBoxButtons type )
		{
			Button button = null;

			// {^x𐶐
			string okLabel = "OK";
			string cancelLabel = "&Cancel";
			string yesLabel = "&Yes";
			string noLabel = "&No";
			string retryLabel = "&Retry";
			string abortLabel = "&Abort";
			string ignoreLabel = "&Ignore";
			if( CultureInfo.CurrentUICulture.Name.StartsWith("ja") )
			{
				cancelLabel = "LZ";
				yesLabel = "͂(&Y)";
				noLabel = "(&N)";
				retryLabel = "Ďs(&R)";
				abortLabel = "~(&A)";
				ignoreLabel = "(&I)";
			}

			// {^ǉ
			switch( type )
			{
				case MessageBoxButtons.OKCancel:
					button = AddButton( okLabel, new EventHandler(_OkButton_Click) );
					button.TabIndex = 0;
					button.AccessibleRole = AccessibleRole.PushButton;
					button.FlatStyle = FlatStyle.System;
					this.AcceptButton = button;
					
					button = AddButton( cancelLabel, new EventHandler(_CancelButton_Click) );
					button.TabIndex = 1;
					button.AccessibleRole = AccessibleRole.PushButton;
					button.FlatStyle = FlatStyle.System;
					this.CancelButton = button;
					break;
				case MessageBoxButtons.YesNo:
					button = AddButton( yesLabel, new EventHandler(_YesButton_Click) );
					button.TabIndex = 0;
					button.FlatStyle = FlatStyle.System;
					this.AcceptButton = button;
					
					button = AddButton( noLabel, new EventHandler(_NoButton_Click) );
					button.FlatStyle = FlatStyle.System;
					button.TabIndex = 1;
					break;
				case MessageBoxButtons.YesNoCancel:
					button = AddButton( yesLabel, new EventHandler(_YesButton_Click) );
					button.TabIndex = 0;
					button.FlatStyle = FlatStyle.System;
					this.AcceptButton = button;
					
					button = AddButton( noLabel, new EventHandler(_NoButton_Click) );
					button.TabIndex = 1;
					button.FlatStyle = FlatStyle.System;

					button = AddButton( cancelLabel, new EventHandler(_CancelButton_Click) );
					button.TabIndex = 2;
					button.FlatStyle = FlatStyle.System;
					this.CancelButton = button;
					break;
				case MessageBoxButtons.RetryCancel:
					button = AddButton( retryLabel, new EventHandler(_RetryButton_Click) );
					button.TabIndex = 0;
					button.FlatStyle = FlatStyle.System;
					this.AcceptButton = button;

					button = AddButton( cancelLabel, new EventHandler(_CancelButton_Click) );
					button.TabIndex = 1;
					button.FlatStyle = FlatStyle.System;
					this.CancelButton = button;
					break;
				case MessageBoxButtons.AbortRetryIgnore:
					button = AddButton( abortLabel, new EventHandler(_AbortButton_Click) );
					button.TabIndex = 0;
					button.FlatStyle = FlatStyle.System;
					this.AcceptButton = button;

					button = AddButton( retryLabel, new EventHandler(_RetryButton_Click) );
					button.TabIndex = 1;
					button.FlatStyle = FlatStyle.System;

					button = AddButton( ignoreLabel, new EventHandler(_IgnoreButton_Click) );
					button.TabIndex = 2;
					button.FlatStyle = FlatStyle.System;
					break;
				default:
					button = AddButton( okLabel, new EventHandler(_OkButton_Click) );
					button.TabIndex = 0;
					button.FlatStyle = FlatStyle.System;
					this.AcceptButton = button;
					this.CancelButton = button;
					break;
			}

			// ǉ{^̐ɉătH[Ŝ̃TCY𒲐
			int width = 0;
			foreach( Button b in _ButtonsPanel.Controls )
			{
				width += b.Width + PaddingBetweenButtons;
			}
			Size minimumSize = this.MinimumSize;
			this.MinimumSize = new Size( width + PaddingInsideForm*2, minimumSize.Height );
		}

		/// <summary>
		/// {^ǉ
		/// </summary>
		/// <param name="label">x</param>
		/// <param name="eventHandler">NbÑCxgnh</param>
		/// <returns>ǉ{^</returns>
		Button AddButton( string label, EventHandler eventHandler )
		{
			int left;

			// zuʒuZo
			left = PaddingInsideForm;
			foreach( Button b in _ButtonsPanel.Controls )
			{
				left += b.Width + PaddingBetweenButtons;
			}

			// {^𐶐Aǉ
			Button button = new Button();
			button.Width = 88;
			button.Text = label;
			button.Left = left;
			button.Click += new EventHandler( eventHandler );
			_ButtonsPanel.Controls.Add( button );

			return button;
		}
		#endregion // {^̒ǉ

		#region {^̔
		void _OkButton_Click( object sender, EventArgs e )
		{
			DialogResult = DialogResult.OK;
			this.Close();
		}
		void _CancelButton_Click( object sender, EventArgs e )
		{
			DialogResult = DialogResult.Cancel;
			this.Close();
		}
		void _YesButton_Click( object sender, EventArgs e )
		{
			DialogResult = DialogResult.Yes;
			this.Close();
		}
		void _NoButton_Click( object sender, EventArgs e )
		{
			DialogResult = DialogResult.No;
			this.Close();
		}
		void _RetryButton_Click( object sender, EventArgs e )
		{
			DialogResult = DialogResult.Retry;
			this.Close();
		}
		void _AbortButton_Click( object sender, EventArgs e )
		{
			DialogResult = DialogResult.Abort;
			this.Close();
		}
		void _IgnoreButton_Click( object sender, EventArgs e )
		{
			DialogResult = DialogResult.Ignore;
			this.Close();
		}
		#endregion // {^̔

		#region UI Components
		Panel _ButtonsPanel = new Panel();
		Label _Label = new Label();
		#endregion
	}
}
