// 2010-05-09
using System;
using System.Collections;
using System.Diagnostics;
using System.Windows.Forms;

using System.Text.RegularExpressions;

namespace Sgry.AiBTools.AT
{
	class NbsMessageBoxFormBrailler : IControlBrailler<Control>
	{
		NbsMessageBoxForm _MessageBoxForm;
		ArrayList _Controls = new ArrayList();
		Control	_ActiveButton = null;
		int _CaretByteIndex = 0;

		/// <summary>
		/// [_[B
		/// gpDisposeĂԎB
		/// </summary>
		public NbsMessageBoxFormBrailler( NbsMessageBoxForm messageBoxForm )
		{
			Debug.Assert( NbsEngine.Instance != null );
			_MessageBoxForm = messageBoxForm;

			// install event watcher
			NbsEngine.Instance.WinPinMessageReceived += _NbsEngine_WinPinMessageReceived;
			NbsEngine.Instance.TouchCursorPressed += _NbsEngine_TouchCursorPressed;
		}

		/// <summary>
		/// \[X
		/// </summary>
		public void Dispose()
		{
			// uninstall event watcher
			NbsEngine.Instance.WinPinMessageReceived -= _NbsEngine_WinPinMessageReceived;
			NbsEngine.Instance.TouchCursorPressed -= _NbsEngine_TouchCursorPressed;
			foreach( Control control in _Controls )
			{
				control.GotFocus -= Control_GotFocus;
				control.TextChanged -= Control_TextChanged;
			}
		}
		
		#region C^tF[X IControlBrailler
		/// <summary>
		/// ĎRg[ǉ
		/// </summary>
		/// <param name="control">ĎΏۂ̃Rg[</param>
		public void Add( Control control )
		{
			// Ώۂɒǉ
			_Controls.Add( control );
			
			// Cxgnhݒ
			control.GotFocus += Control_GotFocus;
			control.TextChanged += Control_TextChanged;
		}

		/// <summary>
		/// ĎΏۂׂēo^
		/// </summary>
		public void Clear()
		{
			_ActiveButton = null;
			
			// o^Cxgnh폜
			foreach( Control control in _Controls )
			{
				control.GotFocus -= Control_GotFocus;
				control.TextChanged -= Control_TextChanged;
			}
		}

		/// <summary>
		/// ݂̏Ԃ_fBXvCɍďo
		/// </summary>
		public void UpdateDisplay()
		{
			if( _ActiveButton == null
				|| _ActiveButton.Focused != true )
			{
				return;
			}

			string displayingText = _ActiveButton.Text;

			// _fBXvCɕ\
			NbsEngine.Instance.CursorMode = CursorMode.None;
			NbsEngine.Instance.Write(
					NbsEngine.ToSjisEncoding(MakeDisplayText()),
					_CaretByteIndex,
					_CaretByteIndex,
					null,
					LineEndMark.None
				);
		}
		#endregion // C^tF[X IControlBrailler

		#region Rg[̃Cxg
		/// <summary>
		/// ĎΏۃRg[tH[JX𓾂̓B
		/// Rg[TextvpeB\B
		/// </summary>
		void Control_GotFocus( object sender, EventArgs e )
		{
			// ܂ŃtH[JXĂRg[łȂ
			// zLbgʒuZbg
			if( _ActiveButton == null
				|| _ActiveButton != (Control)sender )
			{
				// \Ώۂς̂ŉzLbgʒuZbg
				_CaretByteIndex = 0;
				_ActiveButton = (Control)sender;
			}

			// eLXg\
			UpdateDisplay();
		}

		void Control_TextChanged( object sender, EventArgs e )
		{
			if( _ActiveButton == null
				|| _ActiveButton.Focused != true )
			{
				return;
			}

			UpdateDisplay();
		}
		#endregion // Rg[̃Cxg

		#region NBSGW̑
		/// <summary>
		/// Lbgʒu{I͈͂ԂI[o[Ch
		/// </summary>
		protected void _NbsEngine_TouchCursorPressed( object sender, NbsEngine.TouchCursorPressedEventArgs e )
		{
			if( _ActiveButton == null
				|| _ActiveButton.Focused != true )
			{
				return;
			}

			// ^b`J[\ꂽʒuL
			_CaretByteIndex = e.ByteIndex;

			// ĕ\
			UpdateDisplay();
		}

		void _NbsEngine_WinPinMessageReceived( object sender, NbsEngine.WinPinMessageEventArgs e )
		{
			if( _ActiveButton == null
				|| _ActiveButton.Focused != true )
			{
				return;
			}

			// IԂ̏DLLɓ]
			NbsEngine.Instance.SendDataToDll(
				e.WParam, _CaretByteIndex, _CaretByteIndex
			);
		}
		#endregion // NBSGW̑

		string MakeDisplayText()
		{
			string buttonText = _ActiveButton.Text;

			// j[jbN
			if( Regex.IsMatch( buttonText, @"\(&.\)$" ) ) // (&?)
			{
				buttonText = buttonText.Substring( 0, buttonText.Length - 4 );
			}
			else if( Regex.IsMatch( buttonText, "&[^&]" ) ) // PƂ&
			{
				int mnemonicPos = buttonText.IndexOf( '&' );
				buttonText = buttonText.Substring( 0, mnemonicPos )
					+ buttonText.Substring( mnemonicPos + 1, buttonText.Length - mnemonicPos - 1 );
			}

			return buttonText + " " + _MessageBoxForm.Message;
		}
	}
}
