// file: DeviceConfig.cs
// brief: setting of the braille display Device
// encoding: Shift_JIS
//=========================================================
using System;
using System.Collections;
using System.Diagnostics;
using System.IO;
using System.Xml.Serialization;
using System.Reflection;
using CultureInfo = System.Globalization.CultureInfo;

namespace Sgry.AiBTools.AT
{
	/// <summary>
	/// _fBXvC̋@ݒ
	/// </summary>
	public class DeviceConfig
	{
		int _ComPort = 0;
		BrailleDevice _Device = BrailleDevice.None;
		int _CellCount = 0;

		/// <summary>
		/// gp COM |[g̒ʐMx
		/// </summary>
		public int PortSpeed = 9600;

		#region Init / Dispose
		/// <summary>
		/// VCX^X𐶐
		/// </summary>
		public DeviceConfig()
		{}

		/// <summary>
		/// VCX^X𐶐
		/// </summary>
		public DeviceConfig( DeviceConfig another )
		{
			Device = another.Device;
			ComPort = another.ComPort;
			PortSpeed = another.PortSpeed;
		}
		#endregion

		#region Properties
		/// <summary>
		/// _fBXvC̋@
		/// </summary>
		public BrailleDevice Device
		{
			get{ return _Device; }
			set
			{
				if( value == null )
					throw new ArgumentNullException();
				_Device = value;
			}
		}

		/// <summary>
		/// _fBXvCs̓_Z̐擾܂B
		/// </summary>
		public int CellCount
		{
			get{ return _CellCount; }
		}

		/// <summary>
		/// _fBXvCڑĂ COM |[gԍ
		/// </summary>
		public int ComPort
		{
			get{ return _ComPort; }
			set
			{
				if( value == NbsEngine.UsbPortID )
				{
					if( Device.IsUsbDevice == false )
						throw new InvalidOperationException( "USBΉfł͂܂B" );
				}
				_ComPort = value;
			}
		}
		#endregion

		#region VA
		/// <summary>
		/// e INI t@CɋL^iXML `Ɩʂɒx̂ŁjB
		/// L^͌^̊S̃ZNVAL^܂iSgry.Nbs.BrailleConfigjB
		/// </summary>
		/// <param name="ini">f[^ǋL INI IuWFNg</param>
		public void Serialize( Ini ini )
		{
			string sectionName;

			// serialize data
			sectionName = this.GetType().FullName;
			ini.Set( sectionName, "Device", this.Device.ID );
			ini.Set( sectionName, "ComPort", this.ComPort );
			ini.Set( sectionName, "PortSpeed", this.PortSpeed );
		}

		/// <summary>
		/// INI t@CeǂݎăCX^X𐶐B
		/// </summary>
		/// <param name="ini">f[^ǋL INI IuWFNg</param>
		/// <returns>ꂽIuWFNg</returns>
		public static DeviceConfig Deserialize( Ini ini )
		{
			DeviceConfig obj = new DeviceConfig();
			string sectionName;

			// serialize data
			sectionName = obj.GetType().FullName;
			obj.Device = BrailleDevice.FromID( ini.Get<int>(sectionName, "Device", 0) );
			obj.ComPort = ini.Get( sectionName, "ComPort", obj.ComPort );
			obj.PortSpeed = ini.Get( sectionName, "PortSpeed", obj.PortSpeed );

			return obj;
		}
		#endregion // VA
	}


	/// <summary>
	/// _fBXvC̋@\܂B
	/// </summary>
	public class BrailleDevice
	{
		#region Instance members
		/// <summary>@ID</summary>
		public int ID;

		/// <summary>Ă_Z̐</summary>
		public int CellCount;

		/// <summary>VA(COM|[g)ڑ\ǂ</summary>
		public bool IsSerialDevice;

		/// <summary>USBڑ\ǂ</summary>
		public bool IsUsbDevice;

		string _Name;

		BrailleDevice( int id, int cellCount,
					   bool isSerialDevice, bool isUsbDevice, string name )
		{
			this.ID = id;
			this.CellCount = cellCount;
			this.IsSerialDevice = isSerialDevice;
			this.IsUsbDevice = isUsbDevice;
			this._Name = name;
		}

		/// <summary>@̕\</summary>
		public string Name
		{
			get
			{
				if( CultureInfo.CurrentUICulture.Name.StartsWith("ja") )
				{
					switch( ID )
					{
						case 1:		return "uCm[g40A";
						case 2:		return "irQ[^[";
						case 3:		return "uCm[g20A";
						case 4:		return "p[uC40";
						case 5:		return "TDC32C";
						case 6:		return "uCm[g46C";
						case 7:		return "uCCg";
						case 8:		return "Ao20";
						case 9:		return "Ao40";
						case 10:	return "Ao80";
						case 11:	return "irQ[^[80";
						case 12:	return "uC16";
						case 13:	return "uCCg40";
						case 14:	return "uCm[g46X";
						case 18:	return "";
						case 20:	return "uC24";
						case 21:	return "pbNCg20";
						case 22:	return "pbNCg40";
						case 23:	return "uCZX";
						case 24:	return "uC32";
						case 25:	return "Focus 40 Blue";
						case 26:	return "uCZXEInh";
						case 27:	return "80";
						case 28:	return "؃~j";
						default:	return "gȂ";
					}
				}

				return Name;
			}
		}
		#endregion

		#region Staic members
		static BrailleDevice[] _AllDevices = null;
		class MyComparer : IComparer
		{
			public int Compare( object x, object y )
			{
				BrailleDevice xDevice = x as BrailleDevice;
				BrailleDevice yDevice = y as BrailleDevice;
				int xID = (xDevice != null) ? xDevice.ID : (int)x;
				int yID = (yDevice != null) ? yDevice.ID : (int)y;

				return xID - yID;
			}
		}

		/// <summary>
		/// @ID@擾܂B
		/// </summary>
		public static BrailleDevice FromID( int id )
		{
			int index = Array.BinarySearch( AllDevices, id, new MyComparer() );
			if( index < 0 )
				return None;
			else
				return AllDevices[index];
		}

		/// <summary>
		/// ׂĂ̋@擾܂B
		/// </summary>
		public static BrailleDevice[] AllDevices
		{
			get
			{
				if( _AllDevices == null )
				{
					_AllDevices = new BrailleDevice[] {
						None, BrailleNote40A, Navigator, BrailleNote20A,
						PowerBraille40, TDC32C, BrailleNote46C, BrailleLite,
						ALBA20, ALBA40, ALBA80, Navigator80, BrailleMemo16,
						BrailleLite40, BrailleNote46X, Seika, BrailleMemo24,
						PacMate20, PacMate40, BrailleSense, BM32, Focus40Blue,
						BrailleSenseOnHand, Seika80, SeikaMini
					};
				}
				return _AllDevices;
			}
		}
		#endregion

		#region Enum
		/// <summary>_fBXvCgȂɎw肵܂B</summary>
		public static BrailleDevice None
			= new BrailleDevice( 0, 40, true, false, "No display" );

		/// <summary>uCm[g40AgɎw肵܂B</summary>
		public static BrailleDevice BrailleNote40A
			= new BrailleDevice( 1, 40, true, false, "Braille Note 40A" );

		/// <summary>irQ[^[gɎw肵܂B</summary>
		public static BrailleDevice Navigator
			= new BrailleDevice( 2, 40, true, false, "Navigator" );

		/// <summary>uCm[g20AgɎw肵܂B</summary>
		public static BrailleDevice BrailleNote20A
			= new BrailleDevice( 3, 20, true, false, "Braille Note 20A" );

		/// <summary>p[uC40gɎw肵܂B</summary>
		public static BrailleDevice PowerBraille40
			= new BrailleDevice( 4, 40, true, false, "Power Braille 40" );

		/// <summary>TDC32CgɎw肵܂B</summary>
		public static BrailleDevice TDC32C
			= new BrailleDevice( 5, 32, true, false, "TDC32C" );

		/// <summary>uCm[g46CgɎw肵܂B</summary>
		public static BrailleDevice BrailleNote46C
			= new BrailleDevice( 6, 46, true, false, "Braille Note 46C" );

		/// <summary>uCCggɎw肵܂B</summary>
		public static BrailleDevice BrailleLite
			= new BrailleDevice( 7, 18, true, false, "Braille Lite" );

		/// <summary>Ao20gɎw肵܂B</summary>
		public static BrailleDevice ALBA20
			= new BrailleDevice( 8, 20, true, false, "ALBA20" );

		/// <summary>Ao40gɎw肵܂B</summary>
		public static BrailleDevice ALBA40
			= new BrailleDevice( 9, 40, true, false, "ALBA40" );

		/// <summary>Ao80gɎw肵܂B</summary>
		public static BrailleDevice ALBA80
			= new BrailleDevice( 10, 80, true, false, "ALBA80" );

		/// <summary>irQ[^[80gɎw肵܂B</summary>
		public static BrailleDevice Navigator80
			= new BrailleDevice( 11, 80, true, false, "Navigator 80" );

		/// <summary>uC16gɎw肵܂B</summary>
		public static BrailleDevice BrailleMemo16
			= new BrailleDevice( 12, 16, true, false, "Braile Memo 16" );

		/// <summary>uCCg40gɎw肵܂B</summary>
		public static BrailleDevice BrailleLite40
			= new BrailleDevice( 13, 40, true, false, "Braille Lite 40" );

		/// <summary>uCm[g46XgɎw肵܂B</summary>
		public static BrailleDevice BrailleNote46X
			= new BrailleDevice( 14, 46, true, false, "Braille Note 46X" );

		/// <summary>؂gɎw肵܂B</summary>
		public static BrailleDevice Seika
			= new BrailleDevice( 18, 40, true, false, "Seika" );

		/// <summary>uC24gɎw肵܂B</summary>
		public static BrailleDevice BrailleMemo24
			= new BrailleDevice( 20, 24, true, false, "Braille Memo 24" );

		/// <summary>pbNCg20gɎw肵܂B</summary>
		public static BrailleDevice PacMate20
			= new BrailleDevice( 21, 20, true, true, "PAC Mate 20" );

		/// <summary>pbNCg40gɎw肵܂B</summary>
		public static BrailleDevice PacMate40
			= new BrailleDevice( 22, 40, true, true, "PAC Mate 40" );

		/// <summary>uCZXgɎw肵܂B</summary>
		public static BrailleDevice BrailleSense
			= new BrailleDevice( 23, 32, true, true, "Braille Sense" );

		/// <summary>BM32gɎw肵܂B</summary>
		public static BrailleDevice BM32
			= new BrailleDevice( 24, 32, true, false, "Braille Memo 32" );

		/// <summary>Focus40BluegɎw肵܂B</summary>
		public static BrailleDevice Focus40Blue
			= new BrailleDevice( 25, 40, true, true, "Focus 40 Blue" );

		/// <summary>uCZXInhgɎw肵܂B</summary>
		public static BrailleDevice BrailleSenseOnHand
			= new BrailleDevice( 26, 18, true, true, "Braille Sense On Hand" );

		/// <summary>80gɎw肵܂B</summary>
		public static BrailleDevice Seika80
			= new BrailleDevice( 27, 80, true, false, "Seika 80" );

		/// <summary>؃~jgɎw肵܂B</summary>
		public static BrailleDevice SeikaMini
			= new BrailleDevice( 28, 16, true, true, "Seika mini" );
		#endregion
	}
}
