// file: BrlCvt.cs
// brief: Wrapper class to invoke BrailleConverter.dll
// author: SGRY (YAMAMOTO Suguru)
// update: 2010-01-30
//=========================================================
using System;
using System.Text;
using System.IO;
using System.Runtime.InteropServices;

namespace Sgry.AiBTools.AT
{
	/// <summary>
	/// nt@C_t@C֕ϊ郉CułB
	/// </summary>
	public static class BrlCvt
	{
		static bool _Installed = false;
		static bool _Initialized = false;

		#region Init / Dispose
		/// <summary>
		/// BrailleConverter.dll ܂B
		/// </summary>
		/// <exception cref="DllNotFoundException">BrailleConverter.dll ܂B</exception>
		/// <exception cref="BrlCvtException">BrailleConverter.dll ̏Ɏs܂B</exception>
		public static void Init()
		{
			int rc;

			try
			{
				// ܂DLL̊֐ĂяoĂ݂āA΃CXg[Ăƕ
				rc = BrlCvt_Init();
				_Installed = true;

				// Ԓl𔻒肵AG[NĂȂΏƂ
				if( rc != BRLCVT_E_OK )
				{
					throw new BrlCvtException( rc );
				}
				_Initialized = true;
			}
			catch( DllNotFoundException ex )
			{
				throw ex;
			}
		}

		/// <summary>
		/// BrailleConverter.dll gpĂ\[X܂B
		/// </summary>
		public static void Term()
		{
			BrlCvt_Term();
		}
		#endregion

		#region Public interface
		/// <summary>
		/// BrailleConverter.dll 𗘗pł邩ǂ擾܂B
		/// </summary>
		public static bool Available
		{
			get{ return (Installed && Initialized); }
		}

		/// <summary>
		/// BrailleConverter.dll CXg[Ă邩ǂ擾܂B
		/// </summary>
		public static bool Installed
		{
			get{ return _Installed; }
		}

		/// <summary>
		/// BrailleConverter.dll ς݂ǂ擾܂B
		/// </summary>
		public static bool Initialized
		{
			get{ return _Initialized; }
		}

		/// <summary>
		/// 샍Ȍoݒ肵܂B
		/// </summary>
		public static void SetLogFilePath( string logFilePath )
		{
			if( Available == false )
				return;

			BrlCvt_SetLogFilePath( logFilePath );
		}

		/// <summary>
		/// _t@Č`ϊ܂B
		/// </summary>
		/// <exception cref="BrlCvtException">BrailleConverter.dllŃG[܂B</exception>
		public static void ConvertFromKanji(
			string inputPath, string outputPath,
			 FileFormat outputFormat, BrlCvtParam param )
		{
			if( Available == false )
				return;

			unsafe
			{
				int rc;
				BrlCvtParam* p = &param;

				// DLLŕϊs
				rc = BrlCvt_ConvertFromKanji(
					inputPath, outputPath, outputFormat, p
				);
				if( rc != BRLCVT_E_OK )
				{
					if( rc == BRLCVT_E_IOERROR )
						throw new IOException();
					else if( rc == BRLCVT_E_FILE_NOT_FOUND )
						throw new FileNotFoundException();
					else if( rc == BRLCVT_E_NULL_ARGS )
						throw new ArgumentNullException();
					else if( rc == BRLCVT_E_INVALID_ARGS )
						throw new ArgumentException();
					else
						throw new BrlCvtException( rc );
				}
			}
		}
		#endregion

		#region O
		/// <summary>
		/// BrailleConverter.dll ̗O
		/// </summary>
		public class BrlCvtException : NbsException
		{
			int _ErrorCode;

			/// <summary>
			/// VCX^X𐶐܂B
			/// </summary>
			/// <param name="errorCode">BrailleConverter.dll ̃G[R[h</param>
			public BrlCvtException( int errorCode )
			{
				_ErrorCode = errorCode;
			}

			/// <summary>
			/// O̓ebZ[W擾܂B
			/// </summary>
			public override string Message
			{
				get
				{
					StringBuilder msg = new StringBuilder(1024);

					// bZ[W擾
					if( BrlCvt.Installed )
					{
						BrlCvt_GetErrorMessage( _ErrorCode, msg, msg.Capacity );
					}

					// CXg[bZ[W擾s̓bZ[WύX
					if( msg.Length <= 0 )
					{
						msg.Append( "(failed to get error description)." );
					}

					return msg.ToString();
				}
			}
		}
		#endregion

		#region Native API
		const int BRLCVT_E_OK				= 0;		// 
		const int BRLCVT_E_UNEXPECTED		= 1000;		// zÕG[
		const int BRLCVT_E_NOMEMORY			= 1001;		// [s
		const int BRLCVT_E_IOERROR			= 1002;		// I/OG[
		const int BRLCVT_E_FILE_NOT_FOUND	= 1003;		// t@CȂ
		const int BRLCVT_E_BAD_ENV			= 1004;		// s
		const int BRLCVT_E_BAD_DATA			= 1005;		// [U͂f[^s
		const int BRLCVT_E_USER_CANCEL		= 2000;		// [UɃLZꂽ
		const int BRLCVT_E_PARTIALLY_FAILED	= 2001;		// ꕔ̏Ɏs
		const int BRLCVT_E_INTERNAL			= 9000;		// G[ioOȂǁj
		const int BRLCVT_E_NULL_ARGS		= 9001;		// KvȈNULL
		const int BRLCVT_E_INVALID_ARGS		= 9002;		// s
		const int BRLCVT_E_KTOA_ERROR_BASE	= 20000;	// WKtoA.dll ̃G[R[hɏ悹鍷l
		const int BRLCVT_E_KTOB_ERROR_BASE	= 30000;	// WKtoB.dll ̃G[R[hɏ悹鍷l


		[DllImport("BrailleConverter.dll", CharSet=CharSet.Ansi)]
		extern static unsafe Int32 BrlCvt_Init();

		[DllImport("BrailleConverter.dll", CharSet=CharSet.Ansi)]
		extern static unsafe Int32 BrlCvt_Term();

		[DllImport("BrailleConverter.dll", CharSet=CharSet.Ansi)]
		extern static unsafe void BrlCvt_GetErrorMessage(
				Int32 errorCode, StringBuilder out_errMsg, Int32 errMsgMaxLen
			);

		[DllImport("BrailleConverter.dll", CharSet=CharSet.Ansi)]
		extern static unsafe Int32 BrlCvt_ConvertFromKanji( string inputPath, string outputPath, FileFormat outputFormat, BrlCvtParam* param );

		[DllImport("BrailleConverter.dll", CharSet=CharSet.Ansi)]
		extern static void BrlCvt_SetLogFilePath( string logFilePath );
		#endregion
	}
}
