// file: TreeViewBrailler.cs
// brief: control brailler for TreeView
// encoding: Shift_JIS
// update: 2010-05-09
//=========================================================
using System;
using System.Collections;
using System.Diagnostics;
using System.Windows.Forms;
using StringBuilder = System.Text.StringBuilder;

namespace Sgry.AiBTools.AT
{
	/// <summary>
	/// TreeView ̍ڂǂݎA_fBXvCɕ\NX
	/// </summary>
	public class TreeViewBrailler : ControlBraillerBase<TreeView>
	{
		TreeNode	_ActiveNode = null;

		#region ControlBraillerBase<T>  Template Method 
		/// <summary>
		/// ݂̏Ԃ_fBXvCɍďo
		/// </summary>
		public override void OnUpdateDisplay()
		{
			string str;

			// \eLXg𐶐
			if( _ActiveNode != null )
			{
				str = Utl.MakeDisplayText( _ActiveNode );
			}
			else
			{
				str = String.Empty;
			}

			// _fBXvCɕ\
			NbsEngine.Instance.CursorMode = CursorMode.None;
			NbsEngine.Instance.Write(
					NbsEngine.ToSjisEncoding(str),
					_CaretByteIndex,
					_CaretByteIndex,
					null,
					LineEndMark.None
				);
		}

		/// <summary>
		/// ΏۃRg[ŗL̃CxgnhCXg[܂B
		/// </summary>
		protected override void InstallSpecialEventHandlers( TreeView control )
		{
			control.GotFocus += TreeView_GotFocus;
			control.AfterSelect += TreeView_AfterSelect;
		}

		/// <summary>
		/// ΏۃRg[ŗL̃CxgnhACXg[܂B
		/// </summary>
		protected override void UninstallSpecialEventHandlers( TreeView control )
		{
			control.GotFocus -= TreeView_GotFocus;
			control.AfterSelect -= TreeView_AfterSelect;
		}

		/// <summary>
		/// ݕ\eLXgɂI͈͂擾܂B
		/// </summary>
		protected override void GetSelectionRange( out int begin, out int end )
		{
			begin = end = _CaretByteIndex;
		}

		/// <summary>
		/// _fBXvC̃^b`J[\ꂽɌĂ΂܂B
		/// </summary>
		protected override void OnTouchCursorPressed( NbsEngine.TouchCursorPressedEventArgs e )
		{
			UpdateDisplay();
		}

		/// <summary>
		/// _fBXvC̑삪̍sփVtgȂ΂ȂȂȂɌĂ΂܂B
		/// </summary>
		protected override void OnShiftToNextLine()
		{}

		/// <summary>
		/// _fBXvC̑삪O̍sփVtgȂ΂ȂȂȂɌĂ΂܂B
		/// </summary>
		protected override void OnShiftToPreviousLine()
		{}

		/// <summary>
		/// _fBXvC̃L[ꂽɌĂ΂܂B
		/// Ȃ^b`J[\L[ƃVtgL[ꂽɂ͌Ă΂܂B
		/// </summary>
		protected override void OnKeyDown( KeyEventArgs e )
		{
			Win32.SendKeyDownEvent( e.KeyCode );
			Win32.SendKeyUpEvent( e.KeyCode );
			UpdateDisplay();
		}
		#endregion

		#region Rg[ŗL̃Cxg
		/// <summary>
		/// c[r[ɃtH[JX̓
		/// </summary>
		void TreeView_GotFocus( object sender, EventArgs e )
		{
			TreeView senderView = (TreeView)sender;

			_ActiveNode = senderView.SelectedNode;

			//NO_NEED//UpdateDisplay();
		}

		/// <summary>
		/// c[̑Iὠ
		/// </summary>
		void TreeView_AfterSelect( object sender, TreeViewEventArgs e )
		{
			TreeView senderView = (TreeView)sender;

			// \Ώۂςꍇ͉zLbgʒuZbg
			if( _ActiveNode == null
				|| _ActiveNode != senderView.SelectedNode )
			{
				_CaretByteIndex = 0;
				_ActiveNode = senderView.SelectedNode;
			}

			// ĕ\
			UpdateDisplay();
		}
		#endregion

		#region 
		static class Utl
		{
			public static string MakeDisplayText( TreeNode node )
			{
				TreeView	treeView = node.TreeView;
				string		nodePath = node.FullPath;
				string		text;

				// pXZp[^ݒ肳ĂȂpXtǂ݂
				if( treeView.PathSeparator != null
					&& 0 < treeView.PathSeparator.Length )
				{
					text = Utl.ReversePath( nodePath, treeView.PathSeparator );
				}
				else
				{
					text = treeView.SelectedNode.Text;
				}

				return text;
			}

			public static string ReversePath( string path, string pathSeparator )
			{
				int				beginPos, endPos;
				StringBuilder	reversedPath = new StringBuilder( path.Length );

				// Ԑ[m[h珇ɂ̂ڂĖOĂ
				endPos = path.Length - 1;
				beginPos = path.LastIndexOf( pathSeparator, endPos );
				while( beginPos != -1 ) // Ԗڂɐ[m[hɓBH
				{
					// ̃m[hǉ
					reversedPath.Append(
							path.Substring(beginPos+1, endPos-beginPos)
						);
					reversedPath.Append( pathSeparator );
					
					// ̃m[h
					endPos = beginPos - 1;
					beginPos = path.LastIndexOf( pathSeparator, endPos );
				}

				// Ԑ[m[h̖O
				reversedPath.Append(
						path.Substring(0, endPos+1)
					);

				return reversedPath.ToString();
			}

			public static int CountChar( string str, char ch )
			{
				int count = 0;
				for( int i=0; i<str.Length; i++ )
				{
					if( str[i] == ch )
					{
						count++;
					}
				}
				return count;
			}
		}
		#endregion
	}
}
