// file: TextBoxBrailler.cs
// brief: control brailler for TextBox
// update: 2010-05-09
//=========================================================
using System;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

namespace Sgry.AiBTools.AT
{
	/// <summary>
	/// TextBox p̓_fBXvCNX
	/// </summary>
	public class TextBoxBrailler : ControlBraillerBase<TextBox>
	{
		static EditUtl	NativeApi	= new EditUtl();

		#region Rg[ŗL̃Cxg
		void TextBox_KeyUp( object sender, KeyEventArgs e )
		{
			TextBox textBox = (TextBox)sender;
			
			Keys key = e.KeyCode;
			
			if( key == Keys.Left || key == Keys.Up
				|| key == Keys.Right || key == Keys.Down
				|| key == Keys.Home || key == Keys.End
				|| key == Keys.PageUp || key == Keys.PageDown
				|| key == Keys.Delete || key == Keys.Back )
			{
				UpdateDisplay();
				return;
			}

			char ch = (char)e.KeyCode;
			if( Char.IsControl(ch) && ch != '\\' && ch != '|' )
			{
				return;
			}
			
			if( textBox.AcceptsTab && '\t' == (char)e.KeyCode && e.Alt == false && e.Control == false )
			{
				UpdateDisplay();
			}
			else if( textBox.AcceptsReturn && key == Keys.Enter )
			{
				UpdateDisplay();
			}

			UpdateDisplay();
		}
		#endregion

		#region ControlBraillerBase<T>  Template Method 
		/// <summary>
		/// ݂̏Ԃ_fBXvCɍďóB
		/// Lbĝs\B
		/// </summary>
		public override void OnUpdateDisplay()
		{
			TextBox		textBox = _ActiveControl;
			int			caretIndex, caretLineIndex, caretColumnIndex, caretLineHeadIndex;
			int			selStart, selEnd;
			string		caretLineContent;
			LineEndMark	lineEndMark;

			// LbgʒuƃLbgs̓e擾
			caretIndex = NativeApi.GetCaretIndex( textBox );
			NativeApi.GetCaretIndex( textBox, out caretLineIndex, out caretColumnIndex );
			caretLineContent = NativeApi.GetLine( textBox.Handle, caretLineIndex );
			caretLineHeadIndex = NativeApi.GetLineHeadIndex( textBox.Handle, caretLineIndex );

			// IԂ擾
			if( NativeApi.IsSelectingToEnd(textBox) )
			{
				Utl.GetSelectionState_WhenSelectingToEnd( textBox, caretColumnIndex, out selStart, out selEnd );
			}
			else
			{
				Utl.GetSelectionState_WhenNotSelectingToEnd( textBox, caretColumnIndex, caretLineContent.Length, out selStart, out selEnd );
			}

			// ݍssꂽsǂ
			lineEndMark = Utl.GetLineEndType( textBox, caretLineHeadIndex, caretLineContent, caretLineContent.Length );

			// Lbgso
			NbsEngine.Instance.CursorMode = CursorMode.Underline;
			NbsEngine.Instance.Write(
				caretLineContent,
				selStart,
				selEnd,
				null,
				lineEndMark
			);
		}

		/// <summary>
		/// ΏۃRg[ŗL̃CxgnhCXg[܂B
		/// </summary>
		protected override void InstallSpecialEventHandlers( TextBox control )
		{
			control.KeyUp += TextBox_KeyUp;
		}

		/// <summary>
		/// ΏۃRg[ŗL̃CxgnhACXg[܂B
		/// </summary>
		protected override void UninstallSpecialEventHandlers( TextBox control )
		{
			control.KeyUp -= TextBox_KeyUp;
		}

		/// <summary>
		/// ݕ\eLXgɂI͈͂擾܂B
		/// </summary>
		protected override void GetSelectionRange( out int begin, out int end )
		{
			begin = ActiveControl.SelectionStart;
			end = begin + ActiveControl.SelectionLength;
		}

		/// <summary>
		/// _fBXvC̃^b`J[\ꂽɌĂ΂܂B
		/// </summary>
		protected override void OnTouchCursorPressed( NbsEngine.TouchCursorPressedEventArgs e )
		{
			int lineIndex, lineHeadIndex, columnIndex, index;
			string caretLineContent;
			
			// ݃Lbgs̐擪ɂ镶̃CfbNX擾
			lineIndex = NativeApi.GetLineIndexFromCharIndex( _ActiveControl.Handle, NativeApi.GetCaretIndex(_ActiveControl) );
			lineHeadIndex = NativeApi.GetLineHeadIndex( _ActiveControl.Handle, lineIndex );

			// ^b`J[\ꂽ̂ڂvZ
			caretLineContent = NativeApi.GetLine( _ActiveControl.Handle, lineIndex );
			columnIndex = NbsEngine.SjisByteIndexToUnicodeIndex( caretLineContent, e.ByteIndex );
			
			// ^b`J[\ꂽ́AeLXgŜł̃CfbNX擾
			index = lineHeadIndex + columnIndex;

			if( e.IsShiftDown )
			{
				// ^b`J[\ꂽʒu܂őIg
				int selAnchor = NativeApi.GetSelectionAnchor( _ActiveControl );
				Utl.SetSelectionTo( _ActiveControl, index );
			}
			else
			{
				NativeApi.SetSelection( _ActiveControl.Handle, index, index );
			}
			UpdateDisplay();
		}

		/// <summary>
		/// _fBXvC̑삪̍sփVtgȂ΂ȂȂȂɌĂ΂܂B
		/// </summary>
		protected override void OnShiftToNextLine()
		{
			int line, column;

			NativeApi.GetCaretIndex( _ActiveControl, out line, out column );
			
			if( line != NativeApi.GetLineCount(_ActiveControl.Handle) - 1 )
			{
				// Lbg̈ʒu͍ŏIsłȂB
				// s̐擪ɃLbgړ
				NativeApi.SetCaretIndex( _ActiveControl.Handle, line + 1, 0 );
			}
			else
			{
				// LbgŏIsɂB
				// t@CɃLbgړ
				int index = _ActiveControl.Text.Length;
				NativeApi.SetSelection( _ActiveControl.Handle, index, index );
			}
			UpdateDisplay();
		}

		/// <summary>
		/// _fBXvC̑삪O̍sփVtgȂ΂ȂȂȂɌĂ΂܂B
		/// </summary>
		protected override void OnShiftToPreviousLine()
		{
			int	line, column;
			int	lineLength;
			
			NativeApi.GetCaretIndex( _ActiveControl, out line, out column );

			if( line != 0 )
			{
				// Lbg̈ʒu͐擪słȂB
				// Os̖ɃLbgړ
				lineLength = NativeApi.GetLineLength( _ActiveControl.Handle, line - 1 );
				NativeApi.SetCaretIndex( _ActiveControl.Handle, line - 1, lineLength - 1 );
			}
			else
			{
				// Lbg擪sɂB
				// t@C擪ɃLbgړ
				NativeApi.SetCaretIndex( _ActiveControl.Handle, 0, 0 );
			}
			UpdateDisplay();
		}

		/// <summary>
		/// _fBXvC̃L[ꂽɌĂ΂܂B
		/// Ȃ^b`J[\L[ƃVtgL[ꂽɂ͌Ă΂܂B
		/// </summary>
		protected override void OnKeyDown( KeyEventArgs e )
		{
			Win32.SendKeyDownEvent( e.KeyCode );
			Win32.SendKeyUpEvent( e.KeyCode );
			UpdateDisplay();
		}
		#endregion

		#region Utilities
		class Utl
		{
			public static LineEndMark GetLineEndType( TextBox textBox, int lineHeadIndex, string lineContent, int lineLength )
			{
				string textWithSoftLineBreak = textBox.Text;
				
				// s̎̕sR[h
				if( textWithSoftLineBreak.Length <= lineHeadIndex + lineLength )
				{
					return LineEndMark.PageEnd;
				}
				else if( textWithSoftLineBreak[lineHeadIndex+lineLength] == '\r' )
				{
					return LineEndMark.HardLineBreak;
				}
				else
				{
					return LineEndMark.SoftLineBreak;
				}
			}

			public static void GetSelectionState_WhenSelectingToEnd( TextBox textBox, int caretColumnIndex, out int selectionStart, out int selectionEnd )
			{
				int selStartLineIndex, selStartLineHeadIndex;
				int selStartInFirstSelectionLine;

				// t@CɌđIĂB
				selStartLineIndex = NativeApi.GetLineIndexFromCharIndex( textBox.Handle, textBox.SelectionStart );
				selStartLineHeadIndex = NativeApi.GetLineHeadIndex( textBox.Handle, selStartLineIndex );
				selStartInFirstSelectionLine = textBox.SelectionStart - selStartLineHeadIndex;
				
				//---- IJnʒuݒ ----
				// Is܂łȂs
				if( caretColumnIndex < textBox.SelectionLength )
				{
					selectionStart = 0;
				}
				else
				{
					selectionStart = selStartInFirstSelectionLine;
				}

				//---- IIʒuݒ ----
				if( 0 < textBox.SelectionLength )
				{
					// IB
					// I𒆂̓LbgʒuɃJ[\\sȂB
					// łȂƃLbgʒu܂őI𒆂ƊႢĂ܂
					selectionEnd = caretColumnIndex - 1;
				}
				else
				{
					// I
					selectionEnd = caretColumnIndex;
				}
			}

			public static void GetSelectionState_WhenNotSelectingToEnd( TextBox textBox, int caretColumnIndex, int caretLineLength, out int selectionStart, out int selectionEnd )
			{
				int selEndInWhole;
				int selEndInLastSelectionLine;
				int selEndLineIndex, selEndLineHeadIndex;

				// t@C擪ɌđIĂB
				selEndInWhole = textBox.SelectionStart + textBox.SelectionLength;
				selEndLineIndex = NativeApi.GetLineIndexFromCharIndex( textBox.Handle, selEndInWhole );
				selEndLineHeadIndex = NativeApi.GetLineHeadIndex( textBox.Handle, selEndLineIndex );
				selEndInLastSelectionLine = selEndInWhole - selEndLineHeadIndex;

				//---- IJnʒuݒ ----
				selectionStart = caretColumnIndex;

				//---- IIʒuݒ ----
				// Is܂Ȃs
				if( selEndInLastSelectionLine < textBox.SelectionLength )
				{
					selectionEnd = caretLineLength - 1;
				}
				else
				{
					selectionEnd = selEndInLastSelectionLine - 1;
				}
			}

			/// <summary>
			/// eLXg{bNX̑Iwʒu܂Ŋg
			/// </summary>
			public static void SetSelectionTo( TextBox textBox, int newCaretIndex )
			{
				int caretIndex = NativeApi.GetCaretIndex( textBox );
				int selAnchor = NativeApi.GetSelectionAnchor( textBox );

				// select between selection-anchor and new-caret-index
				if( newCaretIndex <= selAnchor )
				{
					NativeApi.SetSelection( textBox.Handle, newCaretIndex, selAnchor );
					NativeApi.SetCaretPos( NativeApi.GetPositionFromCharIndex(textBox.Handle, newCaretIndex) );
				}
				else
				{
					NativeApi.SetSelection( textBox.Handle, selAnchor, newCaretIndex );
				}
			}
		}
		#endregion
	}
}
