// file: ListViewBrailler.cs
// brief: control brailler for ListView
// encoding: UTF-8
// update: 2010-05-09
//=========================================================
using System;
using System.Collections;
using System.Diagnostics;
using System.Windows.Forms;
using StringBuilder = System.Text.StringBuilder;

namespace Sgry.AiBTools.AT
{
	/// <summary>
	/// ListView ̍ڂǂݎA_fBXvCɕ\NX
	/// </summary>
	public class ListViewBrailler : ControlBraillerBase<ListView>
	{
		ListViewItem _ActiveItem;

		#region ControlBraillerBase<T>  Template Method 
		/// <summary>
		/// ݂̏Ԃ_fBXvCɍďo
		/// </summary>
		public override void OnUpdateDisplay()
		{
			string text;

			// \ׂ𐶐
			text = ListViewItemToString( _ActiveItem );

			// _fBXvCɕ\
			NbsEngine.Instance.CursorMode = CursorMode.None;
			NbsEngine.Instance.Write(
					NbsEngine.ToSjisEncoding(text),
					_CaretByteIndex,
					_CaretByteIndex,
					null,
					LineEndMark.None
				);
		}

		/// <summary>
		/// ΏۃRg[ŗL̃CxgnhCXg[܂B
		/// </summary>
		protected override void InstallSpecialEventHandlers( ListView control )
		{
			control.SelectedIndexChanged += ListView_SelectedIndexChanged;
		}

		/// <summary>
		/// ΏۃRg[ŗL̃CxgnhACXg[܂B
		/// </summary>
		protected override void UninstallSpecialEventHandlers( ListView control )
		{
			control.SelectedIndexChanged -= ListView_SelectedIndexChanged;
		}

		/// <summary>
		/// ݕ\eLXgɂI͈͂擾܂B
		/// </summary>
		protected override void GetSelectionRange( out int begin, out int end )
		{
			begin = end = _CaretByteIndex;
		}

		/// <summary>
		/// _fBXvC̃^b`J[\ꂽɌĂ΂܂B
		/// </summary>
		protected override void OnTouchCursorPressed( NbsEngine.TouchCursorPressedEventArgs e )
		{
			UpdateDisplay();
		}

		/// <summary>
		/// _fBXvC̑삪̍sփVtgȂ΂ȂȂȂɌĂ΂܂B
		/// </summary>
		protected override void OnShiftToNextLine()
		{}

		/// <summary>
		/// _fBXvC̑삪O̍sփVtgȂ΂ȂȂȂɌĂ΂܂B
		/// </summary>
		protected override void OnShiftToPreviousLine()
		{}

		/// <summary>
		/// _fBXvC̃L[ꂽɌĂ΂܂B
		/// Ȃ^b`J[\L[ƃVtgL[ꂽɂ͌Ă΂܂B
		/// </summary>
		protected override void OnKeyDown( KeyEventArgs e )
		{
			if( _ActiveControl.FocusedItem == null )
				return;

			int focusedIndex = _ActiveControl.FocusedItem.Index;
			if( e.KeyCode == Keys.Down )
			{
				if( focusedIndex+1 < _ActiveControl.Items.Count )
				{
					_ActiveControl.Items[focusedIndex].Selected = false;
					_ActiveControl.Items[focusedIndex+1].Focused = true;
					_ActiveControl.Items[focusedIndex+1].Selected = true;
				}
				else
				{
					Win32.MessageBeep_Notify();
				}
			}
			else if( e.KeyCode == Keys.Up )
			{
				if( 0 < focusedIndex )
				{
					_ActiveControl.Items[focusedIndex].Selected = false;
					_ActiveControl.Items[focusedIndex-1].Focused = true;
					_ActiveControl.Items[focusedIndex-1].Selected = true;
				}
				else
				{
					Win32.MessageBeep_Notify();
				}
			}
		}
		#endregion

		#region Rg[ŗL̃Cxg
		/// <summary>
		/// Xgr[ɃtH[JX̓
		/// </summary>
		protected override void Control_GotFocus( object sender, EventArgs e )
		{
			ListView senderView = (ListView)sender;
			_ActiveItem = senderView.FocusedItem;
			
			base.Control_GotFocus( sender, e );
		}

		/// <summary>
		/// Xg̑Iὠ
		/// </summary>
		void ListView_SelectedIndexChanged( object sender, EventArgs e )
		{
			ListView senderView = (ListView)sender;

			// IꂽƂɔCxg͖
			if( senderView.SelectedItems.Count == 0 )
			{
				return;
			}

			// ɂtH[JXĂȂ͖
			if( senderView.FocusedItem == null )
			{
				return;
			}

			// ܂ŕ\ĂڂłȂΉzLbgʒuZbg
			if( _ActiveItem == null
				|| _ActiveItem != senderView.FocusedItem )
			{
				_CaretByteIndex = 0;
				_ActiveItem = senderView.FocusedItem;
			}

			// ĕ\
			UpdateDisplay();
		}
		#endregion

		#region Utilities
		static string ListViewItemToString( ListViewItem listViewItem )
		{
			if( listViewItem == null )
				return String.Empty;
			if( listViewItem.ListView == null )
				return String.Empty;
			
			StringBuilder text = new StringBuilder( 256 );

			text.Append( listViewItem.Text );
			for( int i=1; i<listViewItem.ListView.Columns.Count; i++ )
			{
				// TuACeJwb_菭Ȃꍇ͂ŕ񐶐~
				if( listViewItem.SubItems.Count <= i )
				{
					break;
				}
				
				text.Append( ", " );
				text.Append( listViewItem.ListView.Columns[i].Text );
				text.Append( ":" );
				text.Append( listViewItem.SubItems[i].Text );
			}

			return text.ToString();
		}
		#endregion
	}
}
