// file: ListBoxBrailler.cs
// brief: control brailler for ListBox
// coding: Shift_JIS
// update: 2010-05-09
//=========================================================
using System;
using System.Collections;
using System.Windows.Forms;
using DllImportAttribute= System.Runtime.InteropServices.DllImportAttribute;

namespace Sgry.AiBTools.AT
{
	/// <summary>
	/// ListBox ̃eLXg_fBXvCɕ\ĎIuWFNgB
	/// </summary>
	public class ListBoxBrailler : ControlBraillerBase<ListBox>
	{
		#region ControlBraillerBase<T>  Template Method 
		/// <summary>
		/// ݂̏Ԃ_fBXvCɍďóB
		/// </summary>
		public override void OnUpdateDisplay()
		{
			string displayText;

			// tH[JXꂽڂ̃x擾
			int focusedItemIndex;
			focusedItemIndex = Win32.ListBox_GetFocusedItemIndex( ActiveControl.Handle );
			if( 0 <= focusedItemIndex )
			{
				displayText = ActiveControl.Items[focusedItemIndex].ToString();
			}
			else
			{
				displayText = "";
			}

			// _fBXvCɕ\
			NbsEngine.Instance.CursorMode = CursorMode.None;
			NbsEngine.Instance.Write(
					NbsEngine.ToSjisEncoding(displayText),
					_CaretByteIndex,
					_CaretByteIndex,
					null,
					LineEndMark.None
				);
		}

		/// <summary>
		/// ΏۃRg[ŗL̃CxgnhCXg[܂B
		/// </summary>
		protected override void InstallSpecialEventHandlers( ListBox control )
		{
			control.SelectedIndexChanged += ListBox_SelectedIndexChanged;
		}

		/// <summary>
		/// ΏۃRg[ŗL̃CxgnhACXg[܂B
		/// </summary>
		protected override void UninstallSpecialEventHandlers( ListBox control )
		{
			control.SelectedIndexChanged -= ListBox_SelectedIndexChanged;
		}

		/// <summary>
		/// ݕ\eLXgɂI͈͂擾܂B
		/// </summary>
		protected override void GetSelectionRange( out int begin, out int end )
		{
			begin = end = _CaretByteIndex;
		}

		/// <summary>
		/// _fBXvC̃^b`J[\ꂽɌĂ΂܂B
		/// </summary>
		protected override void OnTouchCursorPressed( NbsEngine.TouchCursorPressedEventArgs e )
		{
			UpdateDisplay();
		}

		/// <summary>
		/// _fBXvC̑삪̍sփVtgȂ΂ȂȂȂɌĂ΂܂B
		/// </summary>
		protected override void OnShiftToNextLine()
		{}

		/// <summary>
		/// _fBXvC̑삪O̍sփVtgȂ΂ȂȂȂɌĂ΂܂B
		/// </summary>
		protected override void OnShiftToPreviousLine()
		{}

		/// <summary>
		/// _fBXvC̃L[ꂽɌĂ΂܂B
		/// Ȃ^b`J[\L[ƃVtgL[ꂽɂ͌Ă΂܂B
		/// </summary>
		protected override void OnKeyDown( KeyEventArgs e )
		{
			if( e.KeyCode == Keys.Down )
			{
				if( ActiveControl.SelectedIndex+1 < ActiveControl.Items.Count )
				{
					_CaretByteIndex = 0;
					ActiveControl.SelectedIndex++;
				}
				else
				{
					Win32.MessageBeep_Notify();
				}
			}
			else if( e.KeyCode == Keys.Up )
			{
				if( 0 < ActiveControl.SelectedIndex )
				{
					_CaretByteIndex = 0;
					ActiveControl.SelectedIndex--;
				}
				else
				{
					Win32.MessageBeep_Notify();
				}
			}
		}
		#endregion

		#region Rg[ŗL̃Cxg
		void ListBox_SelectedIndexChanged( object sender, EventArgs e )
		{
			if( !CanHandleEvent() )
				return;

			UpdateDisplay();
		}
		#endregion
	}
}
