// file: ComboBoxBrailler.cs
// brief: control brailler for ComboBox
// encoding: UTF-8
// update: 2010-05-09
//=========================================================
using System;
using System.Collections;
using System.Windows.Forms;

namespace Sgry.AiBTools.AT
{
	/// <summary>
	/// ComboBox の項目を読み取り、点字ディスプレイに表示するクラス
	/// </summary>
	public class ComboBoxBrailler : ControlBraillerBase<ComboBox>
	{
		//protected int _CaretByteIndex;

		#region ControlBraillerBase<T> の Template Method 実装
		/// <summary>
		/// 現在の状態を点字ディスプレイに再出力
		/// </summary>
		public override void OnUpdateDisplay()
		{
			NbsEngine.Instance.CursorMode = CursorMode.None;
			NbsEngine.Instance.Write(
					NbsEngine.ToSjisEncoding(_ActiveControl.Text),
					_CaretByteIndex,
					_CaretByteIndex,
					null,
					LineEndMark.None
				);
		}

		/// <summary>
		/// 対象コントロール固有のイベントハンドラをインストールします。
		/// </summary>
		protected override void InstallSpecialEventHandlers( ComboBox control )
		{
			control.TextChanged += ComboBox_EventInvoked;
			control.SelectedIndexChanged += ComboBox_EventInvoked;
		}

		/// <summary>
		/// 対象コントロール固有のイベントハンドラをアンインストールします。
		/// </summary>
		protected override void UninstallSpecialEventHandlers( ComboBox control )
		{
			control.TextChanged -= ComboBox_EventInvoked;
			control.SelectedIndexChanged -= ComboBox_EventInvoked;
		}

		/// <summary>
		/// 現在表示中テキストにおける選択範囲を取得します。
		/// </summary>
		protected override void GetSelectionRange( out int begin, out int end )
		{
			begin = end = _CaretByteIndex;
		}

		/// <summary>
		/// 点字ディスプレイのタッチカーソルが押された直後に呼ばれます。
		/// </summary>
		protected override void OnTouchCursorPressed( NbsEngine.TouchCursorPressedEventArgs e )
		{
			UpdateDisplay();
		}

		/// <summary>
		/// 点字ディスプレイの操作が次の行へシフトしなければならなくなった直後に呼ばれます。
		/// </summary>
		protected override void OnShiftToNextLine()
		{
			;
		}

		/// <summary>
		/// 点字ディスプレイの操作が前の行へシフトしなければならなくなった直後に呼ばれます。
		/// </summary>
		protected override void OnShiftToPreviousLine()
		{
			;
		}

		/// <summary>
		/// 点字ディスプレイのキーが押された直後に呼ばれます。
		/// なおタッチカーソルキーとシフトキーが押された直後には呼ばれません。
		/// </summary>
		protected override void OnKeyDown( KeyEventArgs e )
		{
			if( e.KeyCode == Keys.Down )
			{
				if( ActiveControl.SelectedIndex+1 < ActiveControl.Items.Count )
				{
					_CaretByteIndex = 0;
					ActiveControl.SelectedIndex++;
				}
				else
				{
					Win32.MessageBeep_Notify();
				}
			}
			else if( e.KeyCode == Keys.Up )
			{
				if( 0 < ActiveControl.SelectedIndex )
				{
					_CaretByteIndex = 0;
					ActiveControl.SelectedIndex--;
				}
				else
				{
					Win32.MessageBeep_Notify();
				}
			}
		}
		#endregion

		#region コントロール固有のイベント処理
		void ComboBox_EventInvoked( object sender, EventArgs e )
		{
			if( !CanHandleEvent() )
				return;

			UpdateDisplay();
		}
		#endregion
	}
}
