// file: BrailleConfig.cs
// brief: braille coding method
// update: 2012-03-25
//=========================================================
using System;
using System.IO;
using System.Text;

namespace Sgry.AiBTools.AT
{
	/// <summary>
	/// _̕\ݒ
	/// </summary>
	public class BrailleConfig
	{
		internal const int MinTenyakuMaxWidth = 16;

		EnglishCoding	_EnglishCoding		= EnglishCoding.JouhouNatural;
		JapaneseCoding	_JapaneseCoding		= JapaneseCoding.Kana;
		bool			_IsTenyakuMode		= false;
		int				_TenyakuMaxWidth	= 32;
		int				_TabWidth			= 2;
		CursorMode		_CursorMode			= CursorMode.Underline;
		int				_StatusWidth		= 0;

		/// <summary>
		/// p̕\ɗp_̌nݒ܂͎擾܂B
		/// </summary>
		public EnglishCoding EnglishCoding
		{
			get{ return _EnglishCoding; }
			set{ _EnglishCoding = value; }
		}

		/// <summary>
		/// {ꕶ̕\ɗp_̌nݒ܂͎擾܂B
		/// </summary>
		public JapaneseCoding JapaneseCoding
		{
			get{ return _JapaneseCoding; }
			set{ _JapaneseCoding = value; }
		}

		/// <summary>
		/// _fBXvCŃ^uZ̋󔒂ŕ\邩ݒ܂͎擾܂B
		/// </summary>
		public int TabWidth
		{
			get{ return _TabWidth; }
			set
			{
				if( 1 <= value && value <= 4 )
				{
					_TabWidth = value;
				}
			}
		}

		/// <summary>
		/// _fBXvCł̃J[\\̕@
		/// </summary>
		public CursorMode CursorMode
		{
			get{ return _CursorMode; }
			set{ _CursorMode = value; }
		}

		/// <summary>
		/// Xe[^X\̕
		/// </summary>
		public int StatusWidth
		{
			get{ return _StatusWidth; }
			set{ _StatusWidth = value; }
		}

		/// <summary>
		/// _󃂁[hgǂݒ܂͎擾܂B
		/// </summary>
		public bool IsTenyakuMode
		{
			get{ return _IsTenyakuMode; }
			set{ _IsTenyakuMode = value; }
		}

		/// <summary>
		/// _󃂁[hł̐܂ԂZݒ܂͎擾܂B
		/// </summary>
		public int TenyakuMaxWidth
		{
			get{ return _TenyakuMaxWidth; }
			set
			{
				if( 1 <= value && value <= 64 )
				{
					_TenyakuMaxWidth = value;
				}
			}
		}
		
		#region VA
		/// <summary>
		/// e INI t@CɋL^iXML `Ɩʂɒx̂ŁjB
		/// L^͌^̊S̃ZNVAL^܂iSgry.Nbs.DeviceConfigjB
		/// </summary>
		/// <param name="ini">f[^ǋL INI IuWFNg</param>
		public void Serialize( Ini ini )
		{
			string sectionName;

			// serialize data
			sectionName = this.GetType().FullName;
			ini.Set( sectionName, "EnglishCoding", (int)this.EnglishCoding );
			ini.Set( sectionName, "JapaneseCoding", (int)this.JapaneseCoding );
			ini.Set( sectionName, "CursorMode", this.CursorMode );
			ini.Set( sectionName, "TabWidth", this.TabWidth );
			ini.Set( sectionName, "IsTenyakuMode", this.IsTenyakuMode );
			ini.Set( sectionName, "TenyakuMaxWidth", this.TenyakuMaxWidth );
			ini.Set( sectionName, "StatusWidth", this.StatusWidth );
		}

		/// <summary>
		/// INI t@CeǂݎăCX^X𐶐B
		/// </summary>
		/// <param name="ini">f[^ǋL INI IuWFNg</param>
		/// <returns>ꂽIuWFNg</returns>
		public static BrailleConfig Deserialize( Ini ini )
		{
			BrailleConfig obj = new BrailleConfig();
			string sectionName;

			// de-serialize data
			sectionName = obj.GetType().FullName;
			obj.EnglishCoding	= ini.Get( sectionName, "EnglishCoding", obj.EnglishCoding );
			obj.JapaneseCoding	= ini.Get( sectionName, "JapaneseCoding", obj.JapaneseCoding );
			obj.CursorMode		= ini.Get( sectionName, "CursorMode", obj.CursorMode );
			obj.TabWidth		= ini.Get( sectionName, "TabWidth", obj.TabWidth );
			obj.IsTenyakuMode	= ini.Get( sectionName, "IsTenyakuMode", obj.IsTenyakuMode );
			obj.TenyakuMaxWidth = ini.Get( sectionName, "TenyakuMaxWidth", obj.TenyakuMaxWidth );
			obj.StatusWidth		= ini.Get( sectionName, "StatusWidth", obj.StatusWidth );

			return obj;
		}
		#endregion
	}

	#region _\Ľn
	/// <summary>
	/// p̓_̌n
	/// </summary>
	public enum EnglishCoding : int
	{
		/// <summary>
		/// P_
		/// </summary>
		Grade1			= 0,
		/// <summary>
		/// Q_ij
		/// </summary>
		Grade2			= 5,
		/// <summary>
		/// kē_R[h
		/// </summary>
		NABCC			= 4,
		/// <summary>
		/// 񏈗p_i`\L
		/// </summary>
		JouhouNatural	= 1,
		/// <summary>
		/// 񏈗p_{\L
		/// </summary>
		JouhouKomoji	= 2,
		/// <summary>
		/// 񏈗p_啶{\L
		/// </summary>
		JouhouOhmoji	= 3
	}
		
	/// <summary>
	/// {̓_̌n
	/// </summary>
	public enum JapaneseCoding : int
	{
		/// <summary>
		/// ȓ_iƌĂԂ̂ȁHj
		/// </summary>
		Kana			= 0,
		/// <summary>
		/// _
		/// </summary>
		KanTenji		= 1,
		/// <summary>
		/// Z_
		/// </summary>
		RokuTenKanji	= 2,
		/// <summary>
		/// ڍדǂ
		/// </summary>
		Shousai			= 3
	}
	#endregion // _\
}
