// file   : RedirectedProcess.cs
// brief  : wrapper class for RedirectedProcess DLL.
// update : 2007-02-25
//=========================================================
using System;
using DllImportAttribute = System.Runtime.InteropServices.DllImportAttribute;
using CharSet = System.Runtime.InteropServices.CharSet;

namespace Sgry.AiBTools
{
	/// <summary>
	/// Wo͂ƕWG[o͂_CNgȂvZXsNX
	/// </summary>
	public class RedirectedProcess : IDisposable
	{
		IntPtr _NativeObj;

		/// <summary>
		/// vZXI\l擾܂B
		/// </summary>
		public bool HasExited
		{
			get{ return (RedirectedProcess_IsAlive(_NativeObj) == 0); }
		}

		/// <summary>
		/// vZXIɕԂl擾܂B
		/// </summary>
		public int ExitCode
		{
			get{ return (int)RedirectedProcess_GetExitCode(_NativeObj); }
		}

		/// <summary>
		/// vZXJn܂B
		/// </summary>
		/// <param name="commandLine">JnvZX̃R}hC</param>
		/// <exception cref="ApplicationException">vZXɎs</exception>
		public void Start( string commandLine )
		{
			_NativeObj = RedirectedProcess_Create( commandLine );
			if( _NativeObj == IntPtr.Zero )
			{
				throw new ApplicationException( "failed to create process." );
			}
		}

		/// <summary>
		/// \[X܂B
		/// svZXIĂȂꍇAs܂B
		/// </summary>
		/// <remarks>
		/// Win32API ̎dlAvZX~Ă̎qvZX܂ł͒~łȂ
		/// \ȃvZX~͎łȂB
		/// ̂߁AӔCĊmɎqvZX~ĂDisposeȂ
		/// ُI悤ɂ킴Ɛ݌vĂB
		/// </remarks>
		public void Dispose()
		{
			Int32 rc = RedirectedProcess_Dispose( _NativeObj );
			if( rc != 0 )
			{
				throw new ApplicationException( "failed to release resources of the process." );
			}
		}

		/// <summary>
		/// vZXI邩Aw莞Ԃ߂܂őҋ@܂B
		/// </summary>
		/// <param name="milliseconds">őҋ@鎞</param>
		public void Wait( int milliseconds )
		{
			RedirectedProcess_Wait( _NativeObj, milliseconds );
		}

		/// <summary>
		/// vZXI܂őҋ@܂B
		/// </summary>
		public void WaitForExit()
		{
			RedirectedProcess_WaitForExit( _NativeObj );
		}

		/// <summary>
		/// vZX̏o͂ꕶǂݎ܂B
		/// </summary>
		/// <returns>ǂݎBs-1</returns>
		public int Read()
		{
			return RedirectedProcess_Read( _NativeObj );
		}

		/// <summary>
		/// vZX̓͂ɕ݂܂B
		/// </summary>
		/// <param name="str">ޕ</param>
		/// <returns>0As-1</returns>
		public int Write( string str )
		{
			return RedirectedProcess_Write( _NativeObj, str, str.Length );
		}

		/// <summary>
		/// vZX̓͂ɕ݂܂B
		/// </summary>
		/// <param name="ch">ޕ</param>
		/// <returns>0As-1</returns>
		public int Write( int ch )
		{
			return RedirectedProcess_WriteByte( _NativeObj, ch );
		}

		/// <summary>
		/// qvZXCtrl+CCxg𔭐܂B
		/// ʓIɁACtrl+CCxg̓R\[AvP[V𑦍ɒ~Ƃ͌܂B
		/// </summary>
		public void SendCtrlC()
		{
			RedirectedProcess_SendCtrlC( _NativeObj );
		}

		/// <summary>
		/// qvZXCtrl+BreakCxg𔭐܂B
		/// ʓIɁACtrl+Break͑ɃR\[AvP[V~܂B
		/// </summary>
		public void SendCtrlBreak()
		{
			RedirectedProcess_SendCtrlBreak( _NativeObj );
		}

		[DllImport("RedirectedProcess.dll", CharSet=CharSet.Unicode)]
		static extern IntPtr RedirectedProcess_Create( string commandLine );
		[DllImport("RedirectedProcess.dll")]
		static extern Int32 RedirectedProcess_Dispose( IntPtr obj );
		
		[DllImport("RedirectedProcess.dll")]
		static extern Int32 RedirectedProcess_Read( IntPtr obj );
		[DllImport("RedirectedProcess.dll", CharSet=CharSet.Unicode)]
		static extern Int32 RedirectedProcess_Write( IntPtr obj, string str, Int32 length );
		[DllImport("RedirectedProcess.dll")]
		static extern Int32 RedirectedProcess_WriteByte( IntPtr obj, Int32 ch );
		[DllImport("RedirectedProcess.dll")]
		static extern Int32 RedirectedProcess_SendCtrlBreak( IntPtr obj );
		[DllImport("RedirectedProcess.dll")]
		static extern Int32 RedirectedProcess_SendCtrlC( IntPtr obj );
		
		[DllImport("RedirectedProcess.dll")]
		static extern Int32 RedirectedProcess_IsAlive( IntPtr obj );
		[DllImport("RedirectedProcess.dll")]
		static extern Int32 RedirectedProcess_GetExitCode( IntPtr obj );
		
		[DllImport("RedirectedProcess.dll")]
		static extern Int32 RedirectedProcess_Wait( IntPtr obj, Int32 milliseconds );
		[DllImport("RedirectedProcess.dll")]
		static extern Int32 RedirectedProcess_WaitForExit( IntPtr obj );
	}
}
