// file: Program.cs
// brief: application class
//=========================================================
using System;
using System.Windows.Forms;
using System.IO;
using System.Reflection;
using System.Runtime.CompilerServices;
using StringDictionary = System.Collections.Specialized.StringDictionary;

[assembly: AssemblyTitle("AiB Terminal")]
[assembly: AssemblyProduct("AiB Terminal")]
[assembly: AssemblyCopyright("(C) 2005-2013 Suguru YAMAMOTO")]
[assembly: AssemblyVersion("3.1.4.*")]
[assembly: AssemblyDescription(
@"A terminal emulator which is accessible in braille."
)]


namespace Sgry.AiBTools.AiBTerminal
{
	class Program
	{
		/// <summary>
		/// AvP[ṼGg[|Cg
		/// </summary>
		/// <param name="args">R}hC</param>
		[STAThread]
		static void Main( string[] args )
		{
			StringDictionary	options;
			string				shellName	= "CMD /q";
			string				shellArgs	= "";
			string				workDir		= Environment.CurrentDirectory;
			bool				closeOnExit	= true;

			// override exception handler (release build only)
#			if !(DEBUG)
//			Application.ThreadException += AiBExceptionHandler.OnThreadException;
//quitƎqvZXȂȂBǂ̂B
#			endif
			
			// 
			options = Sgry.CliOptionParser.Parse( args );
			if( options != null )
			{
				// ͂IvVKp
				if( options.ContainsKey("-shell") )
				{
					shellName = options["-shell"];
				}
				if( options.ContainsKey("-args") )
				{
					shellArgs = options["-args"];
				}
				if( options.ContainsKey(String.Empty) )
				{
					workDir = options[String.Empty];
				}
				if( options.ContainsKey("k") || options.ContainsKey("-keep") )
				{
					closeOnExit = false;
				}
			}

			// AiB Tools ̃fBNgpXɒǉ
			string appDir = Path.GetDirectoryName( Application.ExecutablePath );
			string path = Environment.GetEnvironmentVariable( "PATH", EnvironmentVariableTarget.Process );
			Environment.SetEnvironmentVariable( "PATH", appDir+";"+path, EnvironmentVariableTarget.Process );

			// AvP[VJn
			Application.Run( new AiBTerminalForm(shellName, shellArgs, workDir, closeOnExit) );
		}
	}
}
