// file: OutputTextBox.cs
// brief: output window
// update: 2009-05-05
//=========================================================
using System;
using System.Text.RegularExpressions;
using System.Drawing;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBTerminal
{
	using Gui;

	/// <summary>
	/// AiB Terminal ̏o͕\peLXg{bNX
	/// </summary>
	class OutputTextBox : SgRichEdit
	{
		SgRichEdit.WmHookProc _HookProc = null;

		public OutputTextBox()
		{
			base.ReadOnly = true;
			base.AcceptsTab = false;
			base.AcceptsReturn = false;
		}

		protected override bool ProcessDialogKey( Keys keyData )
		{
			if( keyData == Keys.Tab )
			{
				Win32.MessageBeep_Notify();
				return true;
			}

			return base.ProcessDialogKey( keyData );
		}
		
		public event EventHandler ImeInput;
		void InvokeImeInput()
		{
			if( ImeInput != null )
				ImeInput( this, EventArgs.Empty );
		}

		/// <summary>
		/// Õ\bhtbN֐Ƃēo^܂B
		/// </summary>
		public void SetExternalWmHookProc( SgRichEdit.WmHookProc hookProc )
		{
			_HookProc = hookProc;
		}

		protected override int WindowMessageHookProc( IntPtr hWnd, uint msg, IntPtr wParam, IntPtr lParam, out IntPtr lResult )
		{
			// OtbN֐ݒ肳Ă΂s
			if( _HookProc != null )
			{
				int rc = _HookProc( hWnd, msg, wParam, lParam, out lResult );
				if( rc != 0 )
				{
					return rc;
				}
			}

			// OtbN֐Ȃꍇ͒ʏʂ SgRichEdit ̃tbN֐s
			return base.WindowMessageHookProc( hWnd, msg, wParam, lParam, out lResult );
		}
	}
}
