// file : OptionDialog.cs
// brief : dialog window for program options
// update : 2007-11-19
//=========================================================
using System;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBTerminal
{
	using AT;
	using Gui;

	/// <summary>
	/// IvVݒ_CAO
	/// </summary>
	class OptionDialog : AiBDialogBase
	{
		#region Init / Dispose
		public OptionDialog( AppConfig config )
		{
			InitializeComponent();
			LocalizeComponent();
			Font = SystemInformation.MenuFont;
			StartPosition = FormStartPosition.CenterParent;
			CursorOnOutputLine = config.CursorOnOutputLine;
			AcceptButton = _OkButton;
			CancelButton = _CancelButton;
			_Combo_CursorPos.Select();
		}

		void Form_Activated( object sender, EventArgs e )
		{
			_ComboBoxBrailler.UpdateDisplay();
		}
		#endregion

		#region Parameter Access
		/// <summary>
		/// ͊mɃJ[\Ō͍̓sł͂Ȃo͂̐擪Ɉړ邩ǂ
		/// </summary>
		public bool CursorOnOutputLine
		{
			get{ return (_Combo_CursorPos.SelectedIndex == 1); }
			set{ _Combo_CursorPos.SelectedIndex = (value ? 1:0); }
		}
		#endregion

		#region UI Event Handlers
		void _OkButton_Click( object sender, EventArgs e )
		{
			this.DialogResult = DialogResult.OK;
		}

		void _CancelButton_Click( object sender, EventArgs e )
		{
			this.DialogResult = DialogResult.Cancel;
		}
		#endregion

		#region UI Component Initialization
		protected override void InstallBraillers()
		{
			_ControlBrailler.Init();
			_ControlBrailler.Add( _OkButton );
			_ControlBrailler.Add( _CancelButton );

			_ComboBoxBrailler.Init();
			_ComboBoxBrailler.Add( _Combo_CursorPos );
		}

		protected override void UninstallBraillers()
		{
			_ControlBrailler.Dispose();
			_ComboBoxBrailler.Dispose();
		}

		protected override void InstallReaders()
		{}

		protected override void UninstallReaders()
		{}

		void LocalizeComponent()
		{
			Localizer localizer = AppLogic.Localizer;
			localizer.LoadResourceFile( "AiBTerminal" );

			localizer.TryGetString( "OptionDialog.Text", this );
			localizer.TryGetString( "OptionDialog._Label_CursorPos.Text", _Label_CursorPos );

			_Combo_CursorPos.Items[0] = localizer.TryGetString( "OptionDialog._Combo_CursorPos[0]", "last input line (for speech users)" );
			_Combo_CursorPos.Items[1] = localizer.TryGetString( "OptionDialog._Combo_CursorPos[1]", "first line of the output (for braille users)" );
		}

		void InitializeComponent()
		{
			this._OkButton = new Button();
			this._CancelButton = new Button();
			this._Combo_CursorPos = new ComboBox();
			this._Label_CursorPos = new Label();
			this.SuspendLayout();
			// 
			// _OkButton
			// 
			this._OkButton.Anchor = AnchorStyles.Bottom | AnchorStyles.Right;
			this._OkButton.Location = new System.Drawing.Point( 124, 108 );
			this._OkButton.Name = "_OkButton";
			this._OkButton.Size = new System.Drawing.Size( 75, 23 );
			this._OkButton.TabIndex = 1;
			this._OkButton.Text = "OK";
			this._OkButton.UseVisualStyleBackColor = true;
			this._OkButton.Click += new EventHandler( _OkButton_Click );
			// 
			// _CancelButton
			// 
			this._CancelButton.Anchor = AnchorStyles.Bottom | AnchorStyles.Right;
			this._CancelButton.Location = new System.Drawing.Point( 205, 108 );
			this._CancelButton.Name = "_CancelButton";
			this._CancelButton.Size = new System.Drawing.Size( 75, 23 );
			this._CancelButton.TabIndex = 2;
			this._CancelButton.Text = "Cancel";
			this._CancelButton.UseVisualStyleBackColor = true;
			this._CancelButton.Click += new EventHandler( _CancelButton_Click );
			// 
			// _Combo_CursorPos
			// 
			this._Combo_CursorPos.Anchor = AnchorStyles.Left | AnchorStyles.Top | AnchorStyles.Right | AnchorStyles.Bottom;
			this._Combo_CursorPos.DropDownStyle = ComboBoxStyle.DropDownList;
			this._Combo_CursorPos.FormattingEnabled = true;
			this._Combo_CursorPos.Items.AddRange( new object[] {
            "##FOO##",
            "##BAR##"} );
			this._Combo_CursorPos.Location = new System.Drawing.Point( 51, 41 );
			this._Combo_CursorPos.Name = "_Combo_CursorPos";
			this._Combo_CursorPos.Size = new System.Drawing.Size( 211, 20 );
			this._Combo_CursorPos.TabIndex = 1;
			// 
			// _Label_CursorPos
			// 
			this._Label_CursorPos.Location = new System.Drawing.Point( 6, 21 );
			this._Label_CursorPos.Name = "_Label_CursorPos";
			this._Label_CursorPos.Size = new System.Drawing.Size( 256, 17 );
			this._Label_CursorPos.TabIndex = 0;
			this._Label_CursorPos.Text = "&Cursor position after entering command";
			// 
			// OptionDialog
			// 
			this.ClientSize = new System.Drawing.Size( 292, 143 );
			this.Controls.Add( this._Label_CursorPos );
			this.Controls.Add( this._Combo_CursorPos );
			this.Controls.Add( this._OkButton );
			this.Controls.Add( this._CancelButton );
			Activated += Form_Activated;
			this.FormBorderStyle = FormBorderStyle.Sizable;
			this.Name = "OptionDialog";
			this.Text = "AiB Terminal - Options";
			this.ResumeLayout( false );
		}
		#endregion

		#region UI Components
		Button _OkButton;
		ComboBox _Combo_CursorPos;
		Label _Label_CursorPos;
		Button _CancelButton;
		ControlBrailler _ControlBrailler = new ControlBrailler();
		ComboBoxBrailler _ComboBoxBrailler = new ComboBoxBrailler();
		#endregion
	}
}
