// 2007-02-25
using System;
using System.Drawing;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBTerminal
{
	/// <summary>
	/// LbgړL[̑OŃLbgړȂΉo@\A
	/// Ctrl+A őSI@\ǉB
	/// </summary>
	public class MyTextBox : TextBox
	{
		/// <summary>
		/// R}h̃V[gJbgL[B
		/// Ctrl+AɂSIB
		/// </summary>
		protected override bool ProcessCmdKey( ref Message msg, Keys keyData )
		{
			// Ctrl+A?
			if( Win32.IsControlKeyDown() && (Keys)msg.WParam.ToInt32() == Keys.A )
			{
				this.SelectAll();
				return true;
			}

			return base.ProcessCmdKey( ref msg, keyData );
		}

		/// <summary>
		/// EBhEvV[WB
		/// LbgړL[OŃLbgړȂ΁AoB
		/// </summary>
		protected override void WndProc( ref Message m )
		{
			const int WM_KEYDOWN = 0x0100;
			bool isCaretMoveKey = false;
			int prevCaretIndex = 0;

			// LbgړL[ꂽȂ΁ALbgʒuL
			if( m.Msg == WM_KEYDOWN )
			{
				Keys key = (Keys)m.WParam.ToInt32();
				isCaretMoveKey = IsCaretMoveKey( key );
				if( isCaretMoveKey )
				{
					prevCaretIndex = Utl.GetCaretIndex( this );
				}
			}

			// ʏʂ̓s
			base.WndProc( ref m );

			// LbgړL[ĂꍇALbgʒu̕ωo
			if( isCaretMoveKey )
			{
				int caretIndex = Utl.GetCaretIndex( this );
				if( caretIndex == prevCaretIndex )
				{
					// LbgړL[̂ɈړĂȂ̂ŉo
					Win32.MessageBeep_Notify();
				}
			}
		}

		/// <summary>
		/// LbgړL[ǂ
		/// </summary>
		bool IsCaretMoveKey( Keys key )
		{
			if( key == Keys.Left || key == Keys.Up
				|| key == Keys.Right || key == Keys.Down
				|| key == Keys.Home || key == Keys.End
				|| key == Keys.PageUp || key == Keys.PageDown )
			{
				return true;
			}

			return false;
		}

		#region Utilities
		class Utl
		{
			public static int GetCaretIndex( TextBox textBox )
			{
				Point actualCaretPos = GetCaretPos();
				int caretIndex = GetCharIndexFromPosition( textBox, actualCaretPos );

				return caretIndex;
			}
			
			static int GetCharIndexFromPosition( TextBox textBox, Point position )
			{
				UInt16 lo = (UInt16)position.X;
				UInt16 hi = (UInt16)position.Y;
				
				return 0xFFFF & SendMessage( textBox.Handle, EM_CHARFROMPOS, 0, lo | (hi << 16) );
			}

			static Point GetCaretPos()
			{
				unsafe
				{
					POINT pt = new POINT();
					GetCaretPos( &pt );
					return new Point( pt.x, pt.y );
				}
			}
			
			const int EM_CHARFROMPOS			= 0x00D7;
			
			struct POINT
			{
				public Int32 x;
				public Int32 y;
			}
			[System.Runtime.InteropServices.DllImport("user32")]
			static unsafe extern Int32 GetCaretPos( POINT* outPos );
			[System.Runtime.InteropServices.DllImport("user32.dll", EntryPoint="SendMessageW")]
			static extern int SendMessage( IntPtr hWnd, int msg, Int32 wparam, Int32 lparam );
		}
		#endregion
	}
}
