// 2007-11-19
using System;
using System.Text;
using System.Timers;
using System.Collections;
using System.Threading;
using System.Windows.Forms;
using Timer = System.Timers.Timer;

namespace Sgry.AiBTools.AiBTerminal
{
	using AT;

	/// <summary>
	/// qvZX̏o͂ĎēǂݏoNX
	/// </summary>
	internal class MonitoringLogic
	{
		AiBTerminalForm		_Form;
		RedirectedProcess	_ChildProcess = new RedirectedProcess();
		Thread				_MonitoringThread;
		StringBuilder		_OutputBuffer = new StringBuilder();
		Timer				_Timer = new Timer();	// Ď󋵂IɃ`FbN邽߂̃^C}[
		string				_PrevInput;

		public event EventHandler ProcessExited;

		#region Init / Dispose
		public MonitoringLogic( AiBTerminalForm form )
		{
			_Form = form;
			_Form.InputWindow.InputComitted += InputBox_InputCommitted;

			// setting up timer for optimized display of output
			_Timer.AutoReset = false;
			_Timer.Interval = 200;
			_Timer.Elapsed += Timer_Elapsed;
			//_Timer.Start(); // do not start yet

			// launch child process
			Environment.CurrentDirectory = form.Config.ShellWorkDir;
			_ChildProcess.Start( form.Config.ShellName + " " + form.Config.ShellArgs );

			// start monitoring stdout/stderr of the child process
			_MonitoringThread = new Thread( MonitorChildProcessOutput );
			_MonitoringThread.Start();
		}

		/// <summary>
		/// \[X
		/// </summary>
		public void Dispose()
		{
			_Timer.Dispose();
			if( _MonitoringThread != null
				&& _MonitoringThread.IsAlive )
			{
				_MonitoringThread.Abort();
			}
			_ChildProcess.Dispose();
		}
		#endregion

		/// <summary>
		/// qvZXIǂ
		/// </summary>
		public bool ChildProcessHasExited
		{
			get{ return _ChildProcess.HasExited; }
		}

		/// <summary>
		/// qvZX̕W͂ɕ
		/// </summary>
		public void WriteToChildProcess( string text )
		{
			_ChildProcess.Write( text );
		}

		/// <summary>
		/// Ctrl+Break CxgqvZXɑM
		/// </summary>
		public void SendCtrlBreak()
		{
			_ChildProcess.SendCtrlBreak();
		}

		/// <summary>
		/// qvZX̏o͂̎擾󋵂Ď^C}[ċN
		/// </summary>
		public void ResetTimer()
		{
			lock( this )
			{
				_Timer.Stop();
				_Timer.Start();
			}
		}

		/// <summary>
		/// qvZX̏o͂ĎXbh֐
		/// </summary>
		public void MonitorChildProcessOutput()
		{
			int			ch;
			ArrayList	escapeSequence = new ArrayList();

			// get first char
			ch = _ChildProcess.Read();
			while( ch != -1 )
			{
				// process
				if( 0 < escapeSequence.Count )
				{
					ProcessEscapeSequence( ch, escapeSequence ); // GXP[vV[PX̓[h
				}
				else
				{
					ProcessChildOutput( ch, escapeSequence ); // ʏ̓[h
				}

				// get next char
				ch = _ChildProcess.Read();
			}

			if( ProcessExited != null )
			{
				ProcessExited( this, EventArgs.Empty );
			}
		}

		/// <summary>
		/// qvZX̏o͂莞Ԉȏ~Ă̓
		/// </summary>
		public void Timer_Elapsed( object sender, ElapsedEventArgs e )
		{
			NbsEngine.Instance.BeginUpdate();

			// qvZX̏o͂󂯎邽тɃ^C}[̓NA(WriteCharɂ)B
			// ĈԊuȏo߂Ƃ́Ao͂~ĂƂB
			lock( this )
			{
				string output;

				// o͂ǉ\
				output = _OutputBuffer.ToString();
				_OutputBuffer.Length = 0;
				_Form.AppendOutputText( output );

				// [U͂GR[ꂽꍇAACR炷
				if( output != _PrevInput )
				{
					AppLogic.PlayAuditoryIcon( "OutputReceived.wav" );
					_Form.ResetCaretPosition();
				}

				// qvZXIĂĂȉ̃vZXcĂꍇA
				// qvZXWXg[ꂸIłȂB
				// Ƃ肠I̎|\B
				// iFAiBTerminal > CMD > notepad ƋNCMDIĂA
				// @notepadI܂CMDSɂ͏IȂj
				if( _ChildProcess.HasExited )
				{
					_Form.AppendOutputText( "[process exited]" );
				}
			}
			TextEditorBrailler.Inst.UpdateDisplay();
			NbsEngine.Instance.EndUpdate();
		}

		/// <summary>
		/// [U̓͂Mꂽ̓B
		/// Õ[U͂LB
		/// </summary>
		public void InputBox_InputCommitted( string text, bool noEolCode )
		{
			if( noEolCode )
				_PrevInput = text;
			else
				_PrevInput = text + Environment.NewLine;
		}
		
		#region qvZXo͂̏
		/// <summary>
		/// qvZX̏o͂
		/// </summary>
		/// <param name="ch">o͂ꂽ</param>
		/// <param name="escapeSequence">GXP[vV[PX͂Ɏgobt@</param>
		void ProcessChildOutput( int ch, ArrayList escapeSequence )
		{
			//---- preprocess ----//
			// CR to CR+LF
			if( ch == '\n'
				&& 0 < _OutputBuffer.Length
				&& _OutputBuffer[_OutputBuffer.Length-1] != '\r' ) // PƂLF
			{
				// PƂ LF ͂̑O CR 𑗐MĂɂ
				WriteBuffer( '\r' );
			}
			// XN[̏ (FormFeed: clsR}hof CMD.exe)
			else if( ch == 0x0C )
			{
				_OutputBuffer.Length = 0;
				_Form.ClearOutputWindow();
				return; // 
			}
			// GXP[vR[hH
			if( ch == 0x1B )
			{
				escapeSequence.Add( ch ); // GXP[vV[PX̓[h
				return;
			}

			//---- display ----//
			WriteBuffer( (char)ch );
		}

		/// <summary>
		/// qvZXo͂ꂽGXP[vV[PX
		/// </summary>
		/// <param name="ch">o͂ꂽAGXP[vV[PX̕</param>
		/// <param name="escapeSequence">GXP[vV[PX͂Ɏgobt@</param>
		/// <remarks>iKł̓GXP[vV[PX𖳎鎖ŉʂɃS~oȂ悤ɂĂB</remarks>
		void ProcessEscapeSequence( int ch, ArrayList escapeSequence )
		{
			// first code
			if( escapeSequence.Count <= 1 )
			{
				// ̃GXP[vV[PX
				if( ch == '[' || ch == '(' || ch == ')' || ch == '#' )
				{
					escapeSequence.Add( ch );
				}
				// ꕶGXP[vV[PX
				else
				{
					switch( ch )
					{
						case 'D':
						case 'M':
						case '7':
						case '8':
						case '=':
						case '>':
						case 'N':
						case 'O':
						case 'H':
						case 'Z':
						case 'C':
							escapeSequence.Clear();
							break;
						case 'E':
							WriteBuffer( '\r' ); // next line
							escapeSequence.Clear();
							break;
					}
				}

				return;
			}

			// ̃GXP[vV[PX
			int secondChar = (int)escapeSequence[1];
			if( secondChar == '[' ) // Control Sequence Introducer
			{
				if( ('A' <= ch && ch <= 'Z')
					|| ('a' <= ch && ch <= 'z') )
				{
					escapeSequence.Clear(); // V[PX̏I
				}
				else
				{
					escapeSequence.Add( ch );
				}
			}
			else if( secondChar == '(' || secondChar == ')' )
			{
				if( ch == 'A' || ch == 'B' || ch == '0' )
				{
					escapeSequence.Clear(); // V[PX̏I
				}
				else
				{
					escapeSequence.Add( ch );
				}
			}
			else if( secondChar == '#' )
			{
				if( '3' <= ch && ch <= '8' )
				{
					escapeSequence.Clear(); // V[PX̏I
				}
				else
				{
					escapeSequence.Add( ch );
				}
			}
		}

		/// <summary>
		/// obt@ɕǋL
		/// </summary>
		void WriteBuffer( char ch )
		{
			WriteToBuffer( ch.ToString() );
		}

		/// <summary>
		/// obt@ɕǋL
		/// </summary>
		public void WriteToBuffer( string data )
		{
			lock( this )
			{
				_Timer.Stop();
				_OutputBuffer.Append( data );
				_Timer.Start();
			}
		}
		#endregion
	}
}
