// file: InputTextBox.cs
// brief: input window
// update: 2011-06-05
//=========================================================
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBTerminal
{
	using AT;
	using Gui;

	/// <summary>
	/// AiBTerminal ̓͂󂯕teLXg{bNXB
	/// TextBox A(Shift+)Enter L[ꂽɓ͂ƌȂ
	/// ƎCxg𔭐悤ɉRg[B
	/// ܂AqXg[@\
	/// </summary>
	// ΉׂR}h̓p^[͎̒ʂB
	// CD
	// CD /?
	// CD C:\
	// CD C:\Windows
	// CD \Windows
	// CD .
	// CD ..
	// CD .\..\Windows\.
	// CD /D C:\
	// CD /D C:\Windows
	// CD /D \Windows
	// CD /D .
	// CD /D ..
	// CD /D .\..\Windows\.   ݂͌܂Ȃ...
	// PUSHD [/?] [path]
	// POPD [/?]
	// C:
	class InputTextBox : SgRichEdit
	{
		HistoryBuffer			_History	= new HistoryBuffer();
		CompletionContext		_CompletionContext	= new CompletionContext();
		Regex					_WatchingPattern	= new Regex( @"^\s*(cd|popd|pushd)(?:\s+(/.))?(\s+.*)?" );
		Regex					_WatchingPattern2	= new Regex( @"^\s*([a-zA-Z]):\s*$" );
		Dictionary<char, string>_CurrentDirectories = new Dictionary<char, string>( 27 );
		char					_CurrentDrive		= 'C';
		Stack<string>			_CurrentDirectoryStack	= new Stack<string>();
		EditUtl					_EditUtl	= new EditUtl();

		#region Init / Dispose
		/// <summary>
		/// VCX^X𐶐
		/// </summary>
		public InputTextBox()
		{
			base.Multiline = false;
			base.AcceptsTab = false;
			ListupCurrentDirectories();
			SetCurrentDirectory( Environment.CurrentDirectory, true );
		}
		

		/// <summary>
		/// R}hvvg𗠂Ŏs
		/// ehCũJgfBNg擾
		/// </summary>
		void ListupCurrentDirectories()
		{
			// R}hvvgs
			Process p = new Process();
			p.StartInfo = new ProcessStartInfo( "CMD.exe" );
			p.StartInfo.CreateNoWindow = true;
			p.StartInfo.RedirectStandardInput = true;
			p.StartInfo.RedirectStandardOutput = true;
			p.StartInfo.UseShellExecute = false;
			p.Start();
			
			// vvgđShCuɈړ
			// iJgfBNgvvgƂĕ\j
			p.StandardInput.WriteLine( "prompt" );
			for( char drive='A'; drive <= 'Z'; drive++ )
			{
				p.StandardInput.WriteLine( "{0}:", drive );
			}

			// R}hvvgI
			p.StandardInput.WriteLine( "exit" );
			p.WaitForExit( 3000 );
			if( p.HasExited == false )
			{
				p.Kill();
			}

			// sʂvvgXLA
			// hCũJgfBNg擾
			string line = p.StandardOutput.ReadLine();
			while( line != null )
			{
				Match match = Regex.Match( line, @"([a-zA-Z]:\\[^>]*)>" );
				if( match.Success )
				{
					_CurrentDirectories[ line[0] ] = match.Groups[1].Value;
				}

				// ̍sǂݏo
				line = p.StandardOutput.ReadLine();
			}

			// ݂ȂhCuɂāA
			// hCũ[gfBNgJgƂĐݒ肵Ă
			for( char drive='A'; drive<='Z'; drive++ )
			{
				if( _CurrentDirectories.ContainsKey(drive) == false )
				{
					_CurrentDirectories[drive] = String.Format( "{0}:\\", drive );
				}
			}
		}
		#endregion

		#region ƎǗ̃JgfBNg
		public string CurrentDirectory
		{
			get{ return _CurrentDirectories[ _CurrentDrive ]; }
		}

		void SetCurrentDirectory( string value, bool changesDrive )
		{
			char driveLetter;

			if( value == null )
				throw new ArgumentNullException();

			Match match = Regex.Match( value, @"\s*([a-zA-Z]):(\\.*)" );
			if( match.Success )
			{
				// tpXw肳ꂽꍇ͊YhCũJgfBNgXV
				driveLetter = Char.ToUpper( match.Groups[1].Value[0] );
				_CurrentDirectories[ driveLetter ] = String.Format(
						"{0}:{1}",
						driveLetter,
						match.Groups[2].Value
					);
				if( changesDrive )
				{
					_CurrentDrive = driveLetter;
				}
			}
			else
			{
				_CurrentDirectories[ _CurrentDrive ] = value;
			}

			// hCu^[̐΃pX̉pɃvỖJgfBNgύX
			Environment.CurrentDirectory = CurrentDirectory;
		}
		#endregion

		#region t@C⊮WbN
		/// <summary>
		/// t@C⊮s
		/// </summary>
		void DoCommandCompletion()
		{
			// ⊮[hɓĂȂΕ⊮[hɓ
			if( _CompletionContext.Candidates == null )
			{
				bool succeeded;

				// R}hC
				succeeded = _CompletionContext.Analyze( Text, GetCaretIndex(), CurrentDirectory );
				if( succeeded == false )
				{
					// ⊮Ώۂ݂Ȃ̂ŁAʒmďI
					Win32.MessageBeep_Notify();
					return;
				}
			}

			// ⊮s
			ApplyCommandCompletion( _CompletionContext.NextCandidate() );
		}

		/// <summary>
		/// t@C⊮tŎs
		/// </summary>
		void DoCommandCompletionReverse()
		{
			// ⊮[hɓĂȂΕ⊮[hɓ
			if( _CompletionContext.Candidates == null )
			{
				bool succeeded;

				// R}hC
				succeeded = _CompletionContext.Analyze( Text, GetCaretIndex(), CurrentDirectory );
				if( succeeded == false )
				{
					// ⊮Ώۂ݂Ȃ̂ŁAʒmďI
					Win32.MessageBeep_Notify();
					return;
				}
			}

			// ⊮s
			ApplyCommandCompletion( _CompletionContext.PreviousCandidate() );
		}

		/// <summary>
		/// t@C⊮̌擾B
		/// Lbgʒũg[N⊮̌oĕԂB
		/// </summary>
		/// <returns>t@C⊮̌</returns>
		public string[] GetCompletionCandidates()
		{
			// ⊮[hɓĂȂΕ⊮[hɓ
			if( _CompletionContext.Candidates == null )
			{
				bool succeeded;

				// R}hC
				succeeded = _CompletionContext.Analyze( Text, GetCaretIndex(), CurrentDirectory );
				if( succeeded == false )
				{
					// ⊮Ώۂ݂Ȃ
					_CompletionContext.Clear();
					return null;
				}
			}

			// ⊮ΏۂԂ
			return _CompletionContext.Candidates;
		}

		/// <summary>
		/// w肵ŕ⊮s
		/// </summary>
		/// <param name="candidate">[Uw肵</param>
		public void ApplyCommandCompletion( string candidate )
		{
			ISpeaker speaker = AutoSpeaker.Instance;
			string dirPath, token;
			int tokenEndIndex;
			CompletionContext context = _CompletionContext;

			// ⊮̃g[N𐶐
			int lastBsIndex = context.Token.LastIndexOf( '\\' ) + 1;
			dirPath = context.Token.Substring( 0, lastBsIndex );
			if( dirPath == null )
			{
				dirPath = String.Empty;
			}
			token = Path.Combine( dirPath, candidate );

			tokenEndIndex = context.FormerPart.Length + token.Length;

			// ⊮s
			NbsEngine.Instance.BeginUpdate();
			{
				SelectAll();
				Replace( context.FormerPart + token + context.LatterPart );
				SetSelection( tokenEndIndex, tokenEndIndex );
			}
			NbsEngine.Instance.EndUpdate();

			// _fBXvCXV邽߂ɑIύXCxg𔭐
			InvokeSelectionChanged();

			// ⊮g[Nǂݏグ
			speaker.Stop();
			speaker.Speak( token );
		}

		/// <summary>
		/// JgfBNgǗB
		/// </summary>
		/// <remarks>
		/// OnInputCommitted ̉
		/// </remarks>
		void ManageCurrentDirectory( Match match )
		{
			Debug.Assert( match.Success );
			Debug.Assert( match.Groups.Count == 3 || match.Groups.Count == 4 );

			string	destination = null;
			string	command = match.Groups[1].Value;
			string	option = null;

			// get destination
			try
			{
				string	cmdTarget;

				// get option part
				option = match.Groups[2].Value;

				// get target directory part
				cmdTarget = match.Groups[3].Value; // Groups may not have 4th element
				cmdTarget = cmdTarget.Trim( '"' ).Trim();

				// calculate destination
				if( Path.IsPathRooted(cmdTarget)
					|| cmdTarget[0] == '\\' ) // hCuł̈ړ͑ΏۊO
				{
					destination = Path.GetFullPath( cmdTarget );
				}
				else
				{
					destination = Utl.RelPathToAbsPath( CurrentDirectory, cmdTarget );
				}

				// ensure file entries can be enumerable at the directory
				Directory.GetFileSystemEntries( destination, "xxx" );
			}
			catch( ArgumentException )
			{
				destination = null; // specified path may be invalid
			}
			catch( UnauthorizedAccessException )
			{
				destination = null; // directory listing not perimitted
			}
			catch( IndexOutOfRangeException )
			{
				destination = null; // match.Groups[4] did not exist
			}
			catch( IOException )
			{
				destination = null; // failed to get directory entries
			}

			// manage current directory
			if( command == "pushd" && destination != null )
			{
				_CurrentDirectoryStack.Push( CurrentDirectory );
				SetCurrentDirectory( destination, true );
			}
			else if( command == "popd" )
			{
				if( 0 < _CurrentDirectoryStack.Count )
					SetCurrentDirectory( _CurrentDirectoryStack.Pop(), true );
			}
			else if( command == "cd" && destination != null )
			{
				bool changesDrive = (option.ToUpper() == "/D");
				SetCurrentDirectory( destination, changesDrive );
			}
		}

		void ManageCurrentDrive( Match match )
		{
			Debug.Assert( match.Success );
			Debug.Assert( match.Groups.Count == 2 );
			Debug.Assert( match.Groups[1].Value.Length == 1 );

			// w肵hCu݂邩ǂmF
			char newDrive = Char.ToUpper( match.Groups[1].Value[0] );
			if( Directory.Exists(newDrive + @":\") == false )
			{
				// ݂ȂhCȕꍇ͈ړłȂ̂ŉȂ
				return;
			}

			// hCu^[ύXAJgfBNgXV
			_CurrentDrive = newDrive;
			Environment.CurrentDirectory = CurrentDirectory;
		}
		#endregion // t@C⊮WbN

		/// <summary>
		/// ͗擾
		/// </summary>
		/// <returns>͗</returns>
		public string[] GetInputHistory()
		{
			return _History.ToReversedArray();
		}

		#region UI behavior customization
		/// <summary>
		/// R}hL[`
		/// </summary>
		protected override bool ProcessCmdKey( ref Message msg, Keys keyData )
		{
			// Tab L[𖳎
			if( msg.Msg == Win32.WM_CHAR )
			{
				char ch = (char)msg.WParam.ToInt32();
				if( ch == '\t' )
				{
					return true;
				}
			}

			if( msg.Msg == Win32.WM_KEYDOWN )
			{
				Keys key = (Keys)msg.WParam.ToInt32();
				
				//---- completion commands ----
				// Tab
				if( key == Keys.Tab
					&& Win32.IsControlKeyDown() == false )
				{
					if( Win32.IsShiftKeyDown() )
						DoCommandCompletionReverse(); // Shift+Tab
					else
						DoCommandCompletion(); // Tab
					return true;
				}
				else if( IsCommandCompletionClearKey(key) )
				{
					_CompletionContext.Clear();
				}

				//---- command committion ----
				// Enter / Shift+Enter
				if( key == Keys.Enter )
				{
					OnInputCommitted( Win32.IsShiftKeyDown() );
					return true;
				}
			}

			return base.ProcessCmdKey( ref msg, keyData );
		}

		bool IsCommandCompletionClearKey( Keys key )
		{
			int key_i = (int)key;
			
			// alphabets
			if( 'A' <= key_i && key_i <= 'Z' )
			{
				return true;
			}
			// arrows
			if( key == Keys.Up || key == Keys.Down
				|| key == Keys.Left || key == Keys.Right
				|| key == Keys.Home || key == Keys.End )
				return true;

			return false;
		}
		#endregion

		#region Cxg
		/// <summary>
		/// [UM͓em肵ɔ܂B
		/// </summary>
		public event InputCommittedEventHandler InputComitted;
		public delegate void InputCommittedEventHandler( string text, bool noEolCode );
		void OnInputCommitted( bool noEolCode )
		{
			string	input = Text;
			Match	matching;

			// rise event
			if( InputComitted != null )
			{
				InputComitted( input, noEolCode );
			}

			// stack the text as history
			_History.Add( input );

			// watch changes of the current directory
			matching = _WatchingPattern.Match( input );
			if( matching.Success )
			{
				ManageCurrentDirectory( matching );
			}
			else
			{
				matching = _WatchingPattern2.Match( input );
				if( matching.Success )
				{
					ManageCurrentDrive( matching );
				}
			}

			Clear();
		}
		#endregion

		#region 
		/// <summary>
		/// ߋ256̓͗ێ郊Oobt@
		/// </summary>
		class HistoryBuffer
		{
			public class NoMoreHistory : ApplicationException
			{}

			string[] _History = new string[256];
			int _PreviewIndex = 0; // Ă鎞̃J[\
			int _Index = 0; // ŐVwJ[\

			/// <summary>
			/// ێĂ͗tɎ擾
			/// </summary>
			public string[] ToReversedArray()
			{
				List<string> history = new List<string>();
				
				// obt@ null łȂl擾
				for( int i=_Index-1; 0<=i; i-- )
				{
					if( _History[i] != null )
					{
						history.Add( _History[i] );
					}
				}
				for( int i=_History.Length-1; _Index<=i; i-- )
				{
					if( _History[i] != null )
					{
						history.Add( _History[i] );
					}
				}
				if( history.Count == 0 )
				{
					return null;
				}

				return history.ToArray();
			}

			/// <summary>
			/// O̗擾
			/// </summary>
			public string Previous()
			{
				int prevIndex;

				if( _PreviewIndex == 0 )
				{
					prevIndex = _History.Length - 1;
				}
				else
				{
					prevIndex = _PreviewIndex - 1;
				}

				if( _History[prevIndex] == null )
				{
					throw new NoMoreHistory();
				}
				_PreviewIndex = prevIndex;

				return _History[_PreviewIndex];
			}

			/// <summary>
			/// ̗擾
			/// </summary>
			public string Next()
			{
				int nextIndex;

				if( _PreviewIndex == _History.Length )
				{
					nextIndex = 0;
				}
				else
				{
					nextIndex = _PreviewIndex + 1;
				}

				if( _History[nextIndex] == null )
				{
					throw new NoMoreHistory();
				}
				_PreviewIndex = nextIndex;

				return _History[_PreviewIndex];
			}

			/// <summary>
			/// ǉ
			/// </summary>
			public void Add( string text )
			{
				_History[_Index] = text;

				// proceed history cursor
				if( _Index == _History.Length )
				{
					_Index = 0;
				}
				else
				{
					_Index++;
				}

				_PreviewIndex = _Index;
				//_History[_Index] = String.Empty;
			}
		}

		/// <summary>
		/// ⊮ɕKvȏNX
		/// </summary>
		class CompletionContext
		{
			string[]	_Candidates;
			string		_FormerPart;
			string		_Token;
			string		_LatterPart;
			int			_CandidateIndex;

			/// <summary>
			/// ⊮
			/// </summary>
			public string[] Candidates
			{
				get{ return _Candidates; }
			}

			/// <summary>
			/// R}h̕⊮Ώۃg[NO̕
			/// </summary>
			public string FormerPart
			{
				get{ return _FormerPart; }
			}

			/// <summary>
			/// ⊮Ώۃg[N
			/// </summary>
			public string Token
			{
				get{ return _Token; }
			}

			/// <summary>
			/// R}h̕⊮Ώۃg[N̕
			/// </summary>
			public string LatterPart
			{
				get{ return _LatterPart; }
			}

			/// <summary>
			/// ̕⊮擾
			/// </summary>
			/// <returns>̕⊮</returns>
			public string NextCandidate()
			{
				if( Candidates.Length == 0 )
				{
					return null;
				}

				if( _CandidateIndex == Candidates.Length - 1 )
				{
					_CandidateIndex = 0;
				}
				else
				{
					_CandidateIndex++;
				}
				return Candidates[_CandidateIndex];
			}

			/// <summary>
			/// O̕⊮擾
			/// </summary>
			/// <returns>O̕⊮</returns>
			public string PreviousCandidate()
			{
				if( Candidates.Length == 0 )
				{
					return null;
				}

				if( _CandidateIndex == 0 )
				{
					_CandidateIndex = Candidates.Length - 1;
				}
				else
				{
					_CandidateIndex--;
				}
				return Candidates[_CandidateIndex];
			}

			/// <summary>
			/// R}hC͂ĕ⊮ɕKvȏW߂
			/// </summary>
			/// <param name="commandLine">ݓ͒̃R}hC</param>
			/// <param name="caretIndex">Lbgʒu</param>
			/// <param name="currentDirectory">݂̃fBNg</param>
			public bool Analyze( string commandLine, int caretIndex, string currentDirectory )
			{
				string[] matchedFiles;

				Clear();

				// R}hC
				Utl.ParseCommandLine( commandLine, caretIndex,
					out _FormerPart, out _Token, out _LatterPart );
				
				// JgfBNgOvŃt@C
				try
				{
					matchedFiles = Utl.GetCompletionCandidatesFromToken( currentDirectory, Token );
					if( matchedFiles == null || matchedFiles.Length == 0 )
					{
						throw new ArgumentException();
					}

					// pXt@C𒊏oAL
					_Candidates = new string[matchedFiles.Length];
					for( int i=0; i<matchedFiles.Length; i++ )
					{
						Candidates[i] = Path.GetFileName( matchedFiles[i] );
					}
					_CandidateIndex = matchedFiles.Length - 1;

					return true;
				}
				catch( ArgumentException )
				{}
				catch( UnauthorizedAccessException )
				{}
				catch( IOException )
				{}

				// OB⊮ΏۂȂB
				Clear();
				return false;
			}

			/// <summary>
			/// ⊮̏NA
			/// </summary>
			public void Clear()
			{
				_Candidates = null;
				_FormerPart = null;
				_Token = null;
				_LatterPart = null;
				_CandidateIndex = 0;
			}

			#region Utilities
			class Utl
			{
				/// <summary>
				/// ⊮XgAbv܂B
				/// </summary>
				/// <exception cref="System.UnauthorizedAccessException">
				/// fBNg̈ꗗ擾錠[Uɖ
				/// </exception>
				/// <exception cref="System.ArgumentException">
				/// g[N valid ȃpX񂪐łȂ
				/// </exception>
				/// <exception cref="System.IO.PathTooLongException">
				/// XeBǑʓꂽpX
				/// </exception>
				/// <exception cref="System.IO.DirectoryNotFoundException">
				/// Ώۂ̃fBNg݂Ȃ
				/// </exception>
				public static string[] GetCompletionCandidatesFromToken( string currentDirectory, string token )
				{
					string dirPath, partialName;
					string[] candidatePathes;
					string[] candidates;
					string absPath;

					// ⊮fBNg̐΃pX擾
					if( Path.IsPathRooted(token) )
					{
						absPath = token;
					}
					else
					{
						// ΃pX΃pXɕϊ
						if( token != String.Empty )
						{
							absPath = RelPathToAbsPath( currentDirectory, token );
						}
						else
						{
							absPath = currentDirectory;
						}
					}

					// ΃pX͂ăfBNgƃt@Cɕ
					if( absPath.EndsWith("\\") || Directory.Exists(absPath) )
					{
						dirPath = absPath;
						partialName = String.Empty;
					}
					else
					{
						dirPath = Path.GetDirectoryName( absPath );
						partialName = Path.GetFileName( absPath );
					}

					// fBNg݂̑mF
					if( Directory.Exists(dirPath) != true )
					{
						//return null;
					}

					// Yt@C
					try
					{
						candidatePathes = Directory.GetFileSystemEntries( dirPath, partialName + "*" );
						candidates = new string[candidatePathes.Length];
						for( int i=0; i<candidatePathes.Length; i++ )
						{
							candidates[i] = Path.GetFileName( candidatePathes[i] );
						}

						return candidates;
					}
					catch( UnauthorizedAccessException )
					{
						return null;
					}
				}

				public static void ParseCommandLine( string commandLine, int caretIndex, out string formerPart, out string token, out string latterPart )
				{
					int tokenBegin, tokenEnd;

					// g[N̊Jn_
					if( 0 < caretIndex )
					{
						tokenBegin = commandLine.LastIndexOf( ' ', caretIndex-1 ) + 1;
					}
					else
					{
						// wCfbNX̓eLXg̐擪B
						tokenBegin = 0;
					}

					// g[N̏I_
					tokenEnd = commandLine.IndexOf( ' ', caretIndex );
					if( tokenEnd == -1 )
					{
						// wCfbNX͍Ō̃g[NɂB
						tokenEnd = commandLine.Length;
					}

					// ͌ʂԂ
					formerPart = commandLine.Substring( 0, tokenBegin );
					token = commandLine.Substring( tokenBegin, tokenEnd-tokenBegin );
					latterPart = commandLine.Substring( tokenEnd );
				}

				public static string RelPathToAbsPath( string basePath, string relativePath )
				{
					try
					{
						string basePath_, relPath;

						// "..\" ]
						relPath = relativePath;
						basePath_ = basePath;
						while( relPath.StartsWith("..\\") )
						{
							relPath = relPath.Substring( 3 );
							basePath_ = Path.GetDirectoryName( basePath_ );
						}

						// ".\" ]iPɍ폜j
						if( relPath.StartsWith(".\\") )
						{
							relPath = relPath.Substring( 2 );
						}

						// Đ΃pX
						return Path.Combine( basePath_, relPath );
					}
					catch( System.IO.IOException )
					{
						throw new ArgumentException();
					}
				}
			}
			#endregion
		}

		class Utl
		{
			static readonly Regex _CurrentDirPattern = new Regex( @"^\.\\?(.*)" );
			static readonly Regex _ParentDirPattern = new Regex( @"^\.\.\\?(.*)" );

			public static string RelPathToAbsPath( string basePath, string relativePath )
			{
				try
				{
					Match match;
					string basePath_, relPath;

					relPath = relativePath;
					basePath_ = basePath;

					// "..\" ]
					match = _ParentDirPattern.Match( relPath );
					while( match.Success )
					{
						relPath = match.Groups[1].ToString();
						basePath_ = Path.GetDirectoryName( basePath_ );

						// 
						match = _ParentDirPattern.Match( relPath );
					}

					// ".\" ]
					match = _CurrentDirPattern.Match( relPath );
					while( match.Success )
					{
						relPath = match.Groups[1].ToString();

						// 
						match = _CurrentDirPattern.Match( relPath );
					}

					// Đ΃pX
					return Path.Combine( basePath_, relPath );
				}
				catch( System.IO.IOException )
				{
					throw new ArgumentException();
				}
			}
		}
		#endregion
	}

}
