// 2008-12-20
using System;
using System.Text;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBTerminal
{
	using AT;
	using Gui;

	/// <summary>
	/// [Uɕ̌₩I_CAO
	/// </summary>
	class ChoiceDialog : AiBDialogBase
	{
		string	_SelectedChoice = String.Empty;

		#region Properties
		/// <summary>
		/// \
		/// </summary>
		public string[] Choices
		{
			set
			{
				_ListView.Items.Clear();

				// Xg{bNX̓eu
				foreach( string candidate in value )
				{
					_ListView.Items.Add( candidate );
				}

				// ŏ̍ڂI
				_ListView.Items[0].Selected = true;
				_ListView.Items[0].Focused = true;
			}
		}

		/// <summary>
		/// [UI
		/// </summary>
		public string SelectedChoice
		{
			get{ return _SelectedChoice; }
		}
		#endregion

		#region Init / Dispose
		/// <summary>
		/// VCX^X𐶐
		/// </summary>
		public ChoiceDialog()
		{
			InitializeComponents();
		}

		void Form_Activated( object sender, EventArgs e )
		{
			_ListViewBrailler.UpdateDisplay();
		}
		#endregion

		#region UI Control
		/// <summary>
		/// w肵L҂[_ _CAO{bNXƂătH[\
		/// </summary>
		public DialogResult ShowDialog( Form owner )
		{
			// ҂̌lIϓ_KƎvTCY
			this.StartPosition = FormStartPosition.CenterParent;
			Width = (owner.Width < 640) ? owner.Width : 640;
			Height = (owner.Height < 480) ? owner.Height : 480;

			_ListView.Columns[0].Width = -2;

			return base.ShowDialog( owner );
		}

		void _ListBox_KeyDown( object sender, KeyEventArgs e )
		{
			if( 0 < _ListView.SelectedIndices.Count && e.KeyCode == Keys.Enter )
			{
				this.DialogResult = DialogResult.OK;
				this._SelectedChoice = _ListView.SelectedItems[0].Text;
				this.Close();
			}
		}

		void _ListBox_DoubleClick( object sender, EventArgs e )
		{
			if( 0 < _ListView.SelectedIndices.Count )
			{
				this.DialogResult = DialogResult.OK;
				this._SelectedChoice = _ListView.SelectedItems[0].Text;
				this.Close();
			}
		}
		#endregion

		#region UI Component Initialization
		protected override void InstallBraillers()
		{
			_ListViewBrailler.Init();
			_ListViewBrailler.Add( _ListView );
		}

		protected override void UninstallBraillers()
		{
			_ListViewBrailler.Dispose();
		}

		protected override void InstallReaders()
		{}

		protected override void UninstallReaders()
		{}

		void InitializeComponents()
		{
			ColumnHeader ch = new ColumnHeader();
			_ListView.Dock = DockStyle.Fill;
			_ListView.FullRowSelect = true;
			_ListView.View = View.Details;
			_ListView.GridLines = true;
			_ListView.Columns.Add( ch );
			_ListView.HeaderStyle = ColumnHeaderStyle.None;
			_ListView.DoubleClick += new EventHandler( _ListBox_DoubleClick );
			_ListView.KeyDown += new KeyEventHandler( _ListBox_KeyDown );
			Controls.Add( _ListView );
			Activated += Form_Activated;
			MinimizeBox = false;
			MaximizeBox = false;
			FormBorderStyle = FormBorderStyle.FixedDialog;
		}
		#endregion

		#region UI Components
		ListView _ListView = new ListView();
		ListViewBrailler _ListViewBrailler = new ListViewBrailler();
		#endregion
	}
}
