// file: AppConfig.cs
// brief: config object
// update: 2009-05-04
//=========================================================
using System;
using System.IO;

namespace Sgry.AiBTools.AiBTerminal
{
	using AT;

	/// <summary>
	/// AvP[V̐ݒǗNX
	/// </summary>
	public class AppConfig
	{
		#region Fields
		bool _CloseOnExit = false;
		bool _CursorOnOutputLine = false;
		string _ShellName = "CMD /q";
		string _ShellArgs = "";
		string _ShellWorkDir = Environment.CurrentDirectory;
		#endregion

		#region vpeB
		/// <summary>
		/// EBhE AiB Terminal gI邩ǂ擾܂͐ݒ肵܂B
		/// </summary>
		public bool CloseOnExit
		{
			get{ return _CloseOnExit; }
			set{ _CloseOnExit = value; }
		}

		/// <summary>
		/// ͊mɃJ[\Ō͍̓sł͂Ȃo͂̐擪Ɉړ邩ǂ
		/// </summary>
		public bool CursorOnOutputLine
		{
			get{ return _CursorOnOutputLine; }
			set{ _CursorOnOutputLine = value; }
		}

		public string ShellName
		{
			get{ return _ShellName; }
			set{ _ShellName = value; }
		}

		public string ShellArgs
		{
			get{ return _ShellArgs; }
			set{ _ShellArgs = value; }
		}

		public string ShellWorkDir
		{
			get{ return _ShellWorkDir; }
			set{ _ShellWorkDir = value; }
		}
		#endregion

		#region Save / Load
		public void SavePreferences( AiBTerminalForm form, BrailleConfig brailleConfig, DeviceConfig deviceConfig )
		{
			Ini ini = new Ini();

			// ensure that the config file exists
			if( Directory.Exists(ConfigDirectoryPath) == false )
			{
				Directory.CreateDirectory( Path.GetDirectoryName(ConfigFilePath) );
			}

			try
			{
				// save braille preferences
				brailleConfig.Serialize( ini );
				deviceConfig.Serialize( ini );

				// save main form's preferences
				ini.Set( "AiBTerminalForm", "_MI_Braille_Use.Checked", form.UsingBraille );
				ini.Set( "AiBTerminal", "CursorOnOutputLine", CursorOnOutputLine );

				ini.Save( ConfigFilePath, System.Text.Encoding.UTF8, "\r\n" );
			}
			catch( Exception ex )
			{
				string format = AppLogic.Localizer.TryGetString( "AiBTerminalForm.Msg_FailedToSaveConfig", "Failed to save configulation: {0}" );
				NbsMessageBox.Show( String.Format(format, ex.Message) );
			}
		}

		public void LoadPreferences( AiBTerminalForm form, out BrailleConfig brailleConfig, out DeviceConfig deviceConfig )
		{
			Ini ini = new Ini();

			brailleConfig = new BrailleConfig();
			deviceConfig = new DeviceConfig();

			try
			{
				ini.Load( ConfigFilePath, System.Text.Encoding.UTF8 );

				// load braille preferences
				brailleConfig = BrailleConfig.Deserialize( ini );
				deviceConfig = DeviceConfig.Deserialize( ini );

				// load main form's preferences
				form.UsingBraille = ini.Get( "AiBTerminalForm", "_MI_Braille_Use.Checked", false );
				CursorOnOutputLine = ini.Get( "AiBTerminal", "CursorOnOutputLine", false );
			}
			catch
			{}
		}
		#endregion

		#region Utilities
		static string _ConfigDirectoryPath;
		public static string ConfigDirectoryPath
		{
			get
			{
				if( _ConfigDirectoryPath == null )
				{
					_ConfigDirectoryPath = Environment.GetFolderPath( Environment.SpecialFolder.ApplicationData );
					_ConfigDirectoryPath = Path.Combine( _ConfigDirectoryPath, "AiBTools3" );
					_ConfigDirectoryPath = Path.Combine( _ConfigDirectoryPath, "AiBTerminal" );
				}

				return _ConfigDirectoryPath;
			}
		}

		static string _ConfigFilePath = null;
		string ConfigFilePath
		{
			get
			{
				if( _ConfigFilePath == null )
				{
					_ConfigFilePath = Path.Combine( ConfigDirectoryPath, "AiBTerminalForm.ini" );
				}

				return _ConfigFilePath;
			}
		}
		#endregion
	}
}
