// file: AiBTerminalForm.cs
// brief: main form
//=========================================================
using System;
using System.IO;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Threading;
using Font = System.Drawing.Font;
using Sgry.AiBTools.Gui;

namespace Sgry.AiBTools.AiBTerminal
{
	using AT;

	/// <summary>
	/// AiB Terminal ̃CtH[B
	/// </summary>
	public class AiBTerminalForm : Form
	{
		#region tB[h
		AppLogic				_AppLogic;
		AppConfig				_AppConfig = new AppConfig();
		int						_LastEndPos;
		internal DeviceConfig	_DeviceConfig	= new DeviceConfig();
		internal BrailleConfig	_BrailleConfig	= new BrailleConfig();
		bool					_Shown			= false;
		AppendTextProc			_AppendTextToOutputWindowProc = null;
		#endregion

		#region Init / Dispose
		/// <summary>
		/// VCX^X𐶐
		/// </summary>
		/// <param name="shellName">st@C</param>
		/// <param name="shellArgs"></param>
		/// <param name="shellWorkDir">ƃfBNg̃pX</param>
		/// <param name="closeOnExit">qvZXIɃEBhEIɕ邩ǂ</param>
		public AiBTerminalForm( string shellName, string shellArgs, string shellWorkDir, bool closeOnExit )
		{
			// initialize UI
			InitializeComponent();
			LocalizeComponents();
			AutoScaleMode = AutoScaleMode.None;

			_AppendTextToOutputWindowProc = this.AppendTextToOutputWindow;

			// eEBhẼtHgύX
			float fontSize = SystemInformation.MenuFont.Size;
			if( fontSize < 13f )
			{
				fontSize = 13f;
			}
			_OutputWindow.Font = new Font( "MS Gothic", fontSize );
			_InputWindow.Font = new Font( "MS Gothic", fontSize );
			this.Font = SystemInformation.MenuFont;
			LayoutComponents();

			// ݒǂݍ
			_AppConfig.LoadPreferences( this, out _BrailleConfig, out _DeviceConfig );
			
			// check options
			if( shellName != null )
			{
				_AppConfig.ShellName = shellName;
			}
			if( shellArgs != null )
			{
				_AppConfig.ShellArgs = shellArgs;
			}
			if( shellWorkDir != null )
			{
				_AppConfig.ShellWorkDir = shellWorkDir;
			}
			_AppConfig.CloseOnExit = closeOnExit;
		}

		/// <summary>
		/// tH[̓ǂݍ݂IƂ̏
		/// </summary>
		protected override void OnLoad( EventArgs e )
		{
			// begin using braille display
			if( UsingBraille )
			{
				BeginUseBrailleDisplay();
			}

			// because child processes are console applications,
			// allocate a new console window to THIS process and hide it
			Win32.AllocConsole();
			Thread.CurrentThread.Join( 100 ); // ɐi߂ƃR\[ȂƂ܂ɂ̂łق̏҂
			IntPtr consoleWindow = Win32.GetConsoleWindow();
			Win32.HideWindow( consoleWindow );
			
			// If the user wanted to place caret not ON the last input line but AFTER that,
			// initial output text should not be empty but one new line code.
			// Doing this ensures the caret always on the shell's input line at initial time.
			if( _AppConfig.CursorOnOutputLine )
			{
				AppendOutputText( Environment.NewLine );
			}

			_AppLogic = new AppLogic( this );
			_InputWindow.InputComitted += _AppLogic.InputBox_InputComitted;

			base.OnLoad( e );
		}

		protected override void Dispose( bool disposing )
		{
			if( _CompletionListDialog != null )
			{
				_CompletionListDialog.Dispose();
				_CompletionListDialog = null;
			}
			if( _HistoryListDialog != null )
			{
				_HistoryListDialog.Dispose();
				_HistoryListDialog = null;
			}
			base.Dispose( disposing );
		}
		#endregion // Init / Dispose

		/// <summary>
		/// ̃EBhEɊ֘Atꂽݒ擾
		/// </summary>
		public AppConfig Config
		{
			get{ return _AppConfig; }
		}

		#region tH[̓
		/// <summary>
		/// L[{[hɂtH[JXړJX^}CY
		/// </summary>
		protected override bool ProcessDialogKey( Keys keyData )
		{
			// Esc L[ꂽH
			if( keyData == Keys.Escape )
			{
				// o̓EBhEɃtH[JX΁ALbg̈ʒuփZbg
				if( _OutputWindow.Focused )
				{
					ResetCaretPosition();
					AppLogic.PlayAuditoryIcon( "ResetCaretPosition.wav" );
					
					// 95Reader ̓ǂݏグ𒆒f
					if( XpReaderSpeaker.IsAlive() )
					{
						XpReaderSpeaker.Instance.Stop();
					}
					return true;
				}
				// łȂΏo̓{bNXɃtH[JXړ
				else
				{
					_OutputWindow.Focus();
					return true;
				}
			}

			return base.ProcessDialogKey( keyData );
		}

		/// <summary>
		/// R}hsV[gJbgL[
		/// </summary>
		protected override bool ProcessCmdKey( ref Message msg, Keys keyData )
		{
			// Ctrl+Pause (Break key)
			if( keyData == (Keys.Control | Keys.Cancel) )
			{
				// qvZX Ctrl+Break Cxg𑗐M
				_MI_Edit_SendCtrlBreak_Click( this, EventArgs.Empty );
			}

			return base.ProcessCmdKey( ref msg, keyData );
		}

		void Form_Activated( object sender, EventArgs e )
		{
			if( UsingBraille != true )
			{
				return;
			}

			// _fBXvC̐ĊJ
			try
			{
				if( NbsEngine.Instance.IsAttached == false )
				{
					NbsEngine.Instance.DeviceConfig = _DeviceConfig;
					NbsEngine.Instance.AttachToServer();
				}
				NbsEngine.Instance.Lock();
				TextEditorBrailler.Inst.UpdateDisplay();
			}
			catch
			{
				UsingBraille = false;
			}

			if( _Shown == false )
			{
				_Shown = true;
				if( JawsSpeaker.IsAlive() )
				{
					JawsSpeaker.Instance.Stop();
				}
			}
		}

		void Form_Deactivate( object sender, EventArgs e )
		{
			// _fBXvC̎gp
			if( _MI_Braille_Use.Checked
				&& NbsEngine.Instance.IsAttached )
			{
				NbsEngine.Instance.Unlock();
			}
		}

		void _InputWindow_Enter( object sender, EventArgs e )
		{
			_MI_Edit_Cut.Enabled = true;
		}

		void _OutputWindow_Enter( object sender, EventArgs e )
		{
			_MI_Edit_Cut.Enabled = false;
		}
		#endregion

		#region UI Access
		/// <summary>
		/// o̓EBhE擾܂B
		/// </summary>
		internal OutputTextBox OutputWindow
		{
			get{ return _OutputWindow; }
		}

		/// <summary>
		/// ̓EBhE擾܂B
		/// </summary>
		internal InputTextBox InputWindow
		{
			get{ return _InputWindow; }
		}

		/// <summary>
		/// qvZX󂯎o͂擾
		/// </summary>
		public string OutputText
		{
			get
			{
				if( InvokeRequired )
					return (string)Invoke( new GetTextMethod(GetText) );
				else
					return _OutputWindow.Text;
			}
		}
		string GetText(){ return Text; }
		delegate string GetTextMethod();
		delegate void CloseMethod();
		delegate void SetSelectionMethod( int start, int length );
		delegate void ScrollToCaretMethod();
		delegate bool SetFocusMethod();
		delegate void AppendTextProc( string text );
		
		/// <summary>
		/// _\@\gp邩ǂ
		/// </summary>
		public bool UsingBraille
		{
			get
			{
				if( _MI_Braille_Use == null )
					return false;
				
				return _MI_Braille_Use.Checked;
			}
			set
			{
				if( _MI_Braille_Use == null )
					return;
				
				_MI_Braille_Use.Checked = value;
			}
		}

		/// <summary>
		/// o̓EBhEɕǉBLbgʒu͓ȂB
		/// </summary>
		/// <param name="text">ǉ镶</param>
		public void AppendOutputText( string text )
		{
			int caretPos;

			// if called in a thread that is not the GUI thread,
			// use Invoke method to access GUI thread safely.
			caretPos = _OutputWindow.GetCaretIndex();
			if( InvokeRequired )
			{
				_OutputWindow.Invoke( _AppendTextToOutputWindowProc, new object[]{ text } );
			}
			else
			{
				_AppendTextToOutputWindowProc( text );
			}
			_OutputWindow.SetSelection( caretPos, caretPos );
		}

		/// <summary>
		/// o̓EBhE̕NA
		/// </summary>
		public void ClearOutputWindow()
		{
			if( InvokeRequired )
			{
				Invoke( new ThreadStart(_OutputWindow.Clear) );
			}
			else
			{
				_OutputWindow.Clear();
			}
		}
		
		/// <summary>
		/// o̓EBhẼLbgʒuĐݒ肷B
		/// Lbg̈ʒu͐ݒ莟ōŌ͍̓sA͒̏o͂̐擪sɂȂB
		/// </summary>
		public void ResetCaretPosition()
		{
			int caretPos = _LastEndPos;

			// Lbg̈ʒuo͂̐擪ɒuݒŁA
			// ̍s݂Ȃ΁A̍sʒuɂ
			if( _AppConfig.CursorOnOutputLine )
			{
				int caretLineIndex = _OutputWindow.GetLineIndexFromCharIndex( _LastEndPos );
				int caretLineLength = _OutputWindow.GetLineLength( caretLineIndex );
				if( _LastEndPos + caretLineLength + 1 <= _OutputWindow.TextLength )
				{
					caretPos = _LastEndPos + caretLineLength + 1;
				}
			}

			// Lbgړ
			if( InvokeRequired ) // 
			{
				_OutputWindow.Invoke( new SetSelectionMethod(_OutputWindow.SetSelection), new object[]{caretPos, caretPos} );
				_OutputWindow.Invoke( new ScrollToCaretMethod(_OutputWindow.ScrollToCaret) );
				_OutputWindow.Invoke( new SetFocusMethod(_OutputWindow.Focus) );
			}
			else
			{
				_OutputWindow.SetSelection( caretPos, caretPos );
				_OutputWindow.ScrollToCaret();
				_OutputWindow.Focus();
			}
		}

		/// <summary>
		/// tH[XbhZ[tɕ܂B
		/// </summary>
		public new void Close()
		{
			if( InvokeRequired )
			{
				CloseMethod d = new CloseMethod(base.Close);
				Invoke( d );
			}
			else
			{
				base.Close();
			}
		}
		#endregion

		#region Menu commands
		//-------------------------------------
		// File
		void _MI_File_Save_Click( object sender, EventArgs e )
		{
			SaveToLogFile();
		}
		void _MI_File_Exit_Click( object sender, EventArgs e )
		{
			this.Close();
		}
		
		//-------------------------------------
		// Edit
		void _MI_Edit_Cut_Click( object sender, EventArgs e )
		{
			if( _InputWindow.Focused )
			{
				_InputWindow.Cut();
			}
		}
		void _MI_Edit_Copy_Click( object sender, EventArgs e )
		{
			if( _InputWindow.Focused )
				_InputWindow.Copy();
			else
				_OutputWindow.Copy();
		}
		void _MI_Edit_Paste_Click( object sender, EventArgs e )
		{
			if( _InputWindow.Focused == false )
			{
				_InputWindow.Focus();
			}
			_InputWindow.Paste();
		}
		void _MI_Edit_Clear_Click( object sender, EventArgs e )
		{
			_OutputWindow.Clear();
		}
		void _MI_Edit_SendCtrlBreak_Click( object sender, EventArgs e )
		{
			ISpeaker speaker = AutoSpeaker.Instance;
			string message;
			
			message = AppLogic.Localizer.TryGetString( "AiBTerminalForm.Msg_SentControlBreakEvent", "Sent control break event" );
			_AppLogic.SendCtrlBreak();
			speaker.Stop();
			speaker.Speak( message );
 		}
		void _MI_Edit_ShowHistory_Click( object sender, EventArgs e )
		{
			string[] candidates;
			DialogResult result;
			ISpeaker speaker = AutoSpeaker.Instance;

			// ͗擾
			candidates = _InputWindow.GetInputHistory();
			if( candidates == null )
			{
				Win32.MessageBeep_Notify();
				return;
			}

			// _CAOɕ\
			_HistoryListDialog.Choices = candidates;
			result = _HistoryListDialog.ShowDialog( this );
			if( result != DialogResult.OK )
			{
				return;
			}

			// [ȖIKp
			_InputWindow.Text = _HistoryListDialog.SelectedChoice;
			_InputWindow.Focus();
			speaker.Stop();
			speaker.Speak( _HistoryListDialog.SelectedChoice );
		}
		void _MI_Edit_CompleteFileName_Click( object sender, EventArgs e )
		{
			string[] candidates;
			DialogResult result;
			ISpeaker speaker = AutoSpeaker.Instance;

			// ⊮擾
			candidates = _InputWindow.GetCompletionCandidates();
			if( candidates == null )
			{
				Win32.MessageBeep_Notify();
				return;
			}

			// _CAOɕ\
			_CompletionListDialog.Choices = candidates;
			result = _CompletionListDialog.ShowDialog( this );
			if( result != DialogResult.OK )
			{
				return;
			}

			// [ȖIŕ⊮s
			_InputWindow.ApplyCommandCompletion( _CompletionListDialog.SelectedChoice );
			_InputWindow.Focus();
			speaker.Stop();
			speaker.Speak( _CompletionListDialog.SelectedChoice );
		}

		//-------------------------------------
		// Tool
		void _MI_Tool_Option_Click( object sender, EventArgs e )
		{
			DialogResult result;

			using( OptionDialog optionDialog = new OptionDialog(_AppConfig) )
			{
				result = optionDialog.ShowDialog( this );
				if( result == DialogResult.Cancel )
				{
					return;
				}

				_AppConfig.CursorOnOutputLine = optionDialog.CursorOnOutputLine;
			}
		}

		//-------------------------------------
		// Help
		void _MI_Help_Manual_Click( object sender, EventArgs e )
		{
			string path = Path.GetDirectoryName( Application.ExecutablePath );
			path = Path.Combine( path, "Documents" );
			path = Path.Combine( path, "AiBTerminal.txt" );
			_AppLogic.ExecAibedit( "\""+path+"\"" );
		}
		void _MI_Help_About_Click( object sender, EventArgs e )
		{
			using( VersionInfoForm form = new VersionInfoForm() )
			{
				form.ShowDialog( this );
			}
		}
		#endregion // Menu commands

		#region _fBXvC̑
		/// <summary>
		/// _fBXvC̎gpJn
		/// </summary>
		public void BeginUseBrailleDisplay()
		{
			if( NbsEngine.Installed == false )
			{
				_MI_Braille_Use.Checked = false;

				string message = AppLogic.Localizer.TryGetString(
					"AiBTerminalForm.Msg_NBSEngineNotInstalled", "NBS Engine is not installed." );
				NbsMessageBox.Show( this, message );
				return;
			}

			try
			{
				// _fBXvC̎gpJn
				NbsEngine.Instance.DeviceConfig = _DeviceConfig;
				NbsEngine.Instance.AttachToServer();

				// _̏ڍׂȕ\ݒs
				NbsEngine.Instance.BrailleConfig = _BrailleConfig;

				// [_[
				TextEditorBrailler.Inst.Add( _OutputWindow );
				TextEditorBrailler.Inst.Add( _InputWindow );

				// _fBXvC̕\XV
				TextEditorBrailler.Inst.UpdateDisplay();
				
				_MI_Braille_Use.Checked = true;
			}
			catch( AttachFailedException ex )
			{
				string format = AppLogic.Localizer.TryGetString(
					"AiBTerminalForm.Msg_FailedToInitializeBrailleDisplay",
					"Failed to initialize Braille display. {0}" );
				NbsMessageBox.Show( this, String.Format(format, ex.Message) );
				_MI_Braille_Use.Checked = false;
			}
		}

		/// <summary>
		/// _fBXvC̎gp~
		/// </summary>
		public void EndUseBrailleDisplay()
		{
			// \NA
			NbsEngine.Instance.ClearDisplay();
			Thread.CurrentThread.Join( 80 ); // [*1]

			// T[oؒf
			NbsEngine.Instance.DetachFromServer();

			TextEditorBrailler.Inst.Clear();

			// GUI XV
			_MI_Braille_Use.Checked = false;

			// [*1] \NA Detach ĂԂƃNAOɃf^b`邱Ƃ
		}

		void _MI_Braille_Use_Click( object sender, EventArgs e )
		{
			// `FbNĂȂ΁A_fBXvC̎gpJn
			if( _MI_Braille_Use.Checked )
			{
				EndUseBrailleDisplay();
			}
			else
			{
				BeginUseBrailleDisplay();
			}
		}

		void _MI_Braille_BrailleConfig_Click( object sender, EventArgs e )
		{
			BrailleConfigForm	configForm;
			DialogResult		result;

			// _\ݒ_CAO\
			using( configForm = new BrailleConfigForm(_BrailleConfig) )
			{
				result = configForm.ShowDialog( this );
				if( result != DialogResult.OK )
				{
					return; // LZꂽ
				}

				// _\ݒXV
				_BrailleConfig = configForm.BrailleConfig;
				NbsEngine.Instance.BrailleConfig = _BrailleConfig;

				// _fBXvC̕\XV
				TextEditorBrailler.Inst.UpdateDisplay();
			}
		}

		void _MI_Braille_DeviceConfig_Click( object sender, EventArgs e )
		{
			DeviceConfigForm	configForm;
			DialogResult		result;

			// foCXݒ_CAO\
			using( configForm = new DeviceConfigForm(_DeviceConfig) )
			{
				configForm.StartPosition = FormStartPosition.CenterParent;
				result = configForm.ShowDialog( this );
				if( result != DialogResult.OK )
				{
					return; // LZꂽ
				}
				_DeviceConfig = configForm.DeviceConfig;

				// _GWċN
				if( _MI_Braille_Use.Checked )
				{
					EndUseBrailleDisplay();
					Thread.CurrentThread.Join( 2000 ); // EndABegin ƒZԂŌĂԂƂ܂ WinPin.exe ̍ċNԂɍȂ
					BeginUseBrailleDisplay();
				}
			}
		}
		#endregion // _fBXvC̑

		#region ̑̏
		/// <summary>
		/// o͂Ot@Cɏo
		/// </summary>
		void SaveToLogFile()
		{
			try
			{
				StreamWriter	file;
				DialogResult	dlgRc;
				SaveFileDialog	sfDlg = new SaveFileDialog();

				// setup dialog
				sfDlg.Filter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*";
				sfDlg.DefaultExt = "txt";

				// show dialog
				dlgRc = sfDlg.ShowDialog( this );
				if( dlgRc != DialogResult.OK )
				{
					return;
				}
				
				// write to log file
				file = new StreamWriter( sfDlg.FileName, false );
				file.Write( _OutputWindow.Text );
				file.Close();
			}
			catch( Exception ex )
			{
				string	format, message;

				// bZ[W𐶐
				format = AppLogic.Localizer.TryGetString( "AiBTerminalForm.Msg_FailedToWriteLog", "Failed to write log file. Message from system:{0}" );
				message = String.Format( format, ex.Message );

				NbsMessageBox.Show( this, message );
			}
		}

		public void SetLastEndPos( int lastEndPos )
		{
			_LastEndPos = lastEndPos;
		}

		#endregion // ̑̏

		#region UI Component Initialization
		/// <summary>
		/// [JCY
		/// </summary>
		void LocalizeComponents()
		{
			Localizer localizer = AppLogic.Localizer;
			localizer.LoadResourceFile( "AiBTerminal" );

			localizer.TryGetString( "AiBTerminalForm._MI_File.Text", _MI_File );
			localizer.TryGetString( "AiBTerminalForm._MI_File_Save.Text", _MI_File_Save );
			localizer.TryGetString( "AiBTerminalForm._MI_File_Exit.Text", _MI_File_Exit );
			
			localizer.TryGetString( "AiBTerminalForm._MI_Edit.Text", _MI_Edit );
			localizer.TryGetString( "AiBTerminalForm._MI_Edit_Cut.Text", _MI_Edit_Cut );
			localizer.TryGetString( "AiBTerminalForm._MI_Edit_Copy.Text", _MI_Edit_Copy );
			localizer.TryGetString( "AiBTerminalForm._MI_Edit_Paste.Text", _MI_Edit_Paste );
			localizer.TryGetString( "AiBTerminalForm._MI_Edit_Clear.Text", _MI_Edit_Clear );
			localizer.TryGetString( "AiBTerminalForm._MI_Edit_SendCtrlBreak.Text", _MI_Edit_SendCtrlBreak );
			localizer.TryGetString( "AiBTerminalForm._MI_Edit_ShowHistory.Text", _MI_Edit_ShowHistory );
			localizer.TryGetString( "AiBTerminalForm._MI_Edit_CompleteFileName.Text", _MI_Edit_CompleteFileName );
			
			localizer.TryGetString( "AiBTerminalForm._MI_Tool.Text", _MI_Tool );
			localizer.TryGetString( "AiBTerminalForm._MI_Tool_Option.Text", _MI_Tool_Option );

			localizer.TryGetString( "AiBTerminalForm._MI_Braille.Text", _MI_Braille );
			localizer.TryGetString( "AiBTerminalForm._MI_Braille_Use.Text", _MI_Braille_Use );
			localizer.TryGetString( "AiBTerminalForm._MI_Braille_BrailleConfig.Text", _MI_Braille_BrailleConfig );
			localizer.TryGetString( "AiBTerminalForm._MI_Braille_DeviceConfig.Text", _MI_Braille_DeviceConfig );
			
			localizer.TryGetString( "AiBTerminalForm._MI_Help.Text", _MI_Help );
			localizer.TryGetString( "AiBTerminalForm._MI_Help_Manual.Text", _MI_Help_Manual );
			localizer.TryGetString( "AiBTerminalForm._MI_Help_VersionInfo.Text", _MI_Help_VersionInfo );

			localizer.TryGetString( "AiBTerminalForm._OutputWindowLabel.Text", _OutputWindowLabel );
			localizer.TryGetString( "AiBTerminalForm._InputWindowLabel.Text", _InputWindowLabel );
			
			localizer.TryGetString( "CompletionListDialog.Text", _CompletionListDialog );
			localizer.TryGetString( "HistoryListDialog.Text", _HistoryListDialog );

			_OutputWindow.AccessibleName = _OutputWindowLabel.Text;
			_InputWindow.AccessibleName = _InputWindowLabel.Text;
		}

		void InitializeComponent()
		{
			const int clientWidth = 744;
			SuspendLayout();
			// 
			// _MainMenu
			// 
			_MainMenu.MenuItems.AddRange(
				new MenuItem[] { _MI_File, _MI_Edit, _MI_Tool, _MI_Braille, _MI_Help }
			);
			// 
			// _MI_File
			// 
			_MI_File.Index = 0;
			_MI_File.MenuItems.AddRange( new MenuItem[]{ _MI_File_Save, _MI_File_Exit } );
			// 
			// _MI_File_Save
			// 
			_MI_File_Save.Index = 0;
			_MI_File_Save.Click += _MI_File_Save_Click;
			// 
			// _MI_File_Exit
			// 
			_MI_File_Exit.Index = 1;
			_MI_File_Exit.Shortcut = Shortcut.CtrlW;
			_MI_File_Exit.Click += _MI_File_Exit_Click;
			// 
			// _MI_Edit
			// 
			_MI_Edit.Index = 1;
			_MI_Edit.MenuItems.AddRange( new MenuItem[]{
				_MI_Edit_Cut,
				_MI_Edit_Copy,
				_MI_Edit_Paste,
				_MI_Edit_Separator1,
				_MI_Edit_Clear,
				_MI_Edit_SendCtrlBreak,
				_MI_Edit_ShowHistory,
				_MI_Edit_CompleteFileName} );
			// 
			// _MI_Edit_Cut
			// 
			_MI_Edit_Cut.Index = 0;
			_MI_Edit_Cut.Shortcut = Shortcut.CtrlX;
			_MI_Edit_Cut.Click +=  _MI_Edit_Cut_Click;
			// 
			// _MI_Edit_Copy
			// 
			_MI_Edit_Copy.Index = 1;
			_MI_Edit_Copy.Shortcut = Shortcut.CtrlC;
			_MI_Edit_Copy.Click += _MI_Edit_Copy_Click;
			// 
			// _MI_Edit_Paste
			// 
			_MI_Edit_Paste.Index = 2;
			_MI_Edit_Paste.Shortcut = Shortcut.CtrlV;
			_MI_Edit_Paste.Click += _MI_Edit_Paste_Click;
			//
			// _MI_Edit_Separator1
			//
			_MI_Edit_Separator1.Index = 3;
			// 
			// _MI_Edit_Clear
			// 
			_MI_Edit_Clear.Index = 4;
			_MI_Edit_Clear.Shortcut = Shortcut.CtrlK;
			_MI_Edit_Clear.Click += _MI_Edit_Clear_Click;
			//
			// _MI_Edit_SendCtrlBreak
			//
			_MI_Edit_SendCtrlBreak.Index = 5;
			_MI_Edit_SendCtrlBreak.Click += _MI_Edit_SendCtrlBreak_Click;
			//
			// _MI_Edit_ShowHistory
			//
			_MI_Edit_ShowHistory.Index = 6;
			_MI_Edit_ShowHistory.Shortcut = Shortcut.F7;
			_MI_Edit_ShowHistory.Click += _MI_Edit_ShowHistory_Click;
			//
			// _MI_Edit_CompleteFileName
			//
			_MI_Edit_CompleteFileName.Index = 7;
			_MI_Edit_CompleteFileName.Shortcut = Shortcut.F8;
			_MI_Edit_CompleteFileName.Click += _MI_Edit_CompleteFileName_Click;
			//
			// _MI_Tool
			//
			_MI_Tool.Index = 2;
			_MI_Tool.MenuItems.Add( _MI_Tool_Option );
			//
			// _MI_Tool_Option
			//
			_MI_Tool_Option.Index = 0;
			_MI_Tool_Option.Click += _MI_Tool_Option_Click;
			// 
			// _MI_Braille
			// 
			_MI_Braille.Index = 3;
			_MI_Braille.MenuItems.AddRange(
				new MenuItem[] { _MI_Braille_Use, _MI_Braille_BrailleConfig, _MI_Braille_DeviceConfig }
			);
			// 
			// _MI_Braille_Use
			// 
			_MI_Braille_Use.Index = 0;
			_MI_Braille_Use.Click += _MI_Braille_Use_Click;
			// 
			// _MI_Braille_BrailleConfig
			// 
			_MI_Braille_BrailleConfig.Index = 1;
			_MI_Braille_BrailleConfig.Shortcut = Shortcut.CtrlB;
			_MI_Braille_BrailleConfig.Click += _MI_Braille_BrailleConfig_Click;
			// 
			// _MI_Braille_DeviceConfig
			// 
			_MI_Braille_DeviceConfig.Index = 2;
			_MI_Braille_DeviceConfig.Click += _MI_Braille_DeviceConfig_Click;
			//
			// _MI_Help
			//
			_MI_Help.MenuItems.AddRange( new MenuItem[]{
					_MI_Help_Manual, _MI_Help_VersionInfo
				} );
			//
			// _MI_Help_Manual
			//
			_MI_Help_Manual.Click += _MI_Help_Manual_Click;
			//
			// _MI_Help_VersionInfo
			//
			_MI_Help_VersionInfo.Click += _MI_Help_About_Click;
			// 
			// _OutputWindowLabel
			// 
			_OutputWindowLabel.Location = new System.Drawing.Point( 0, 0 );
			_OutputWindowLabel.Name = "_OutputWindowLabel";
			_OutputWindowLabel.Size = new System.Drawing.Size( clientWidth, 25 );
			_OutputWindowLabel.TabIndex = 0;
			_OutputWindowLabel.Text = "Output";
			_OutputWindowLabel.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// _OutputWindow
			// 
			_OutputWindow.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right | AnchorStyles.Bottom;
			_OutputWindow.Location = new System.Drawing.Point( 0, 26 );
			_OutputWindow.BackColor = System.Drawing.Color.FromKnownColor( System.Drawing.KnownColor.Window );
			_OutputWindow.Width = clientWidth;
			_OutputWindow.Height = 447;
			_OutputWindow.Name = "_OutputWindow";
			_OutputWindow.TabIndex = 1;
			_OutputWindow.Text = "";
			_OutputWindow.GotFocus += _OutputWindow_Enter;
			// 
			// _InputWindowLabel
			// 
			_InputWindowLabel.Anchor = AnchorStyles.Bottom | AnchorStyles.Left;
			_InputWindowLabel.Location = new System.Drawing.Point( 0, 0 );
			_InputWindowLabel.Name = "_InputWindowLabel";
			_InputWindowLabel.Size = new System.Drawing.Size( clientWidth, 25 );
			_InputWindowLabel.TabIndex = 2;
			_InputWindowLabel.Text = "Input";
			_InputWindowLabel.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// _InputWindow
			// 
			_InputWindow.Anchor = AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right;
			_InputWindow.Name = "_InputWindow";
			_InputWindow.Size = new System.Drawing.Size( clientWidth, 25 );
			_InputWindow.TabIndex = 3;
			_InputWindow.Text = "";
			_InputWindow.GotFocus += _InputWindow_Enter;
			//
			// _HistoryListDialog
			//
			_HistoryListDialog.Text = "Input history";
			//
			// _CompletionListDialog
			//
			_CompletionListDialog.Text = "Auto complete candidates";
			// 
			// AiBTerminalForm
			// 
			ClientSize = new System.Drawing.Size( clientWidth, 500 );
			Controls.Add( _OutputWindowLabel );
			Controls.Add( _OutputWindow );
			Controls.Add( _InputWindowLabel );
			Controls.Add( _InputWindow );
			Icon = R.AppIcon;
			Menu = _MainMenu;
			Name = "AiBTerminalForm";
			Text = "AiB Terminal";
			Activated += Form_Activated;
			Deactivate += Form_Deactivate;
			ResumeLayout(false);
		}

		void LayoutComponents()
		{
			const string sample_string =
				"#123456789#123456789#123456789#123456789#123456789#123456789#123456789#123456789###";
			SizeF textSize;

			using( Graphics g = CreateGraphics() )
			{
				textSize = g.MeasureString( sample_string, _InputWindow.Font );
				int singleLineBoxHeight
					= (int)textSize.Height + SystemInformation.FixedFrameBorderSize.Height * 2;

				Width = (int)textSize.Width;

				_InputWindow.Height = singleLineBoxHeight;
				_OutputWindowLabel.Height = singleLineBoxHeight;
				_OutputWindow.Top = _InputWindow.Height;
				_OutputWindow.Height = ClientSize.Height - (singleLineBoxHeight * 3);
				_InputWindowLabel.Top = ClientSize.Height - (singleLineBoxHeight * 2);
				_InputWindowLabel.Height = singleLineBoxHeight;
				_InputWindow.Top = ClientSize.Height - singleLineBoxHeight;
			}
		}
		#endregion

		#region UI Components
		MainMenu	_MainMenu				= new MainMenu();
		MenuItem	_MI_File				= new MenuItem( "&File" );
		MenuItem	_MI_File_Save			= new MenuItem( "&Save content to file..." );
		MenuItem	_MI_File_Exit			= new MenuItem( "E&xit" );
		MenuItem	_MI_Edit					= new MenuItem( "&Edit" );
		MenuItem	_MI_Edit_Cut				= new MenuItem( "Cu&t" );
		MenuItem	_MI_Edit_Copy				= new MenuItem( "&Copy" );
		MenuItem	_MI_Edit_Paste				= new MenuItem( "&Paste" );
		MenuItem	_MI_Edit_Separator1			= new MenuItem( "-" );
		MenuItem	_MI_Edit_Clear				= new MenuItem( "C&lear output" );
		MenuItem	_MI_Edit_SendCtrlBreak		= new MenuItem( "Send Control+&Break event\tCtrl+Break" );
		MenuItem	_MI_Edit_ShowHistory		= new MenuItem( "Show input &history..." );
		MenuItem	_MI_Edit_CompleteFileName	= new MenuItem( "C&omplete file name..." );
		MenuItem	_MI_Tool				= new MenuItem( "&Tools" );
		MenuItem	_MI_Tool_Option			= new MenuItem( "&Options..." );
		MenuItem	_MI_Braille					= new MenuItem( "&Braille display" );
		MenuItem	_MI_Braille_Use				= new MenuItem( "&Use braille display" );
		MenuItem	_MI_Braille_BrailleConfig	= new MenuItem( "&Braille config..." );
		MenuItem	_MI_Braille_DeviceConfig	= new MenuItem( "&Device config..." );

		MenuItem	_MI_Help					= new MenuItem( "&Help" );
		MenuItem	_MI_Help_Manual				= new MenuItem( "Open &Manual..." );
		MenuItem	_MI_Help_VersionInfo		= new MenuItem( "Version Inform&ation..." );
		
		Label			_InputWindowLabel	= new Label();
		InputTextBox	_InputWindow		= new InputTextBox();
		Label			_OutputWindowLabel	= new Label();
		OutputTextBox	_OutputWindow		= new OutputTextBox();
		
		ChoiceDialog	_CompletionListDialog	= new ChoiceDialog();
		ChoiceDialog	_HistoryListDialog		= new ChoiceDialog();
		#endregion

		#region Utilities
		void AppendTextToOutputWindow( string text )
		{
			NbsEngine.Instance.BeginUpdate();

			int textLength = _OutputWindow.TextLength;
			_OutputWindow.SetSelection( textLength, textLength );
			_OutputWindow.Replace( text );

			NbsEngine.Instance.EndUpdate();
		}
		#endregion
	}
}
