// file: TextOutliner.cs
// brief: Outline parser for plain text
// update: 2010-09-04
//=========================================================
using System;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBEdit
{
	/// <summary>
	/// v[eLXgp̃AEgC͊
	/// </summary>
	class TextOutliner : Outliner
	{
		/// <summary>
		/// CX^X𐶐
		/// </summary>
		/// <param name="dialog">V{\AEgC_CAO</param>
		/// <param name="source">͂镶</param>
		/// <param name="caretIndex">݂̃Lbgʒu</param>
		public TextOutliner( OutlineDialog dialog, string source, int caretIndex )
			: base( dialog, source, caretIndex )
		{}

		/// <summary>
		/// V{𒊏oăc[Rg[ɕ\
		/// </summary>
		public override void Parse()
		{
			// parse source code
			try
			{
				Parse( _Dialog.TreeView, _Source, _CaretIndex );
			}
#			if !DEBUG
			catch {}
#			endif
			finally
			{}

			// if no identifier found, display dummy node with message
			if( _Dialog.TreeView.Nodes.Count == 0 )
			{
				_DummyNode.Tag = _CaretIndex;
				_Dialog.TreeView.Nodes.Add( _DummyNode );
			}
		}

		#region ̓WbN
		static void Parse( TreeView treeView, string source, int caretIndex )
		{
			int			prevLevel = 0;
			TreeNode	prevParent = null;
			TreeNodeCollection	parent = treeView.Nodes;
			TreeNode	initSelNode = null;
			Regex		headingPattern = new Regex( @"[\r\n]{1,2}([\*]{1,4})\s*([^\r|^\n]+)" );
			Match		match;
			string		buf = "\r" + source;

			// parse
			match = headingPattern.Match( buf, 0 );
			while( match.Success )
			{
				// make node
				TreeNode node = new TreeNode();
				string symbol = match.Groups[2].Value;
				node.Text = symbol.Trim();
				node.Tag = match.Groups[1].Index;
				
				// if seek position didnt go over where caret is, keep this node as candidate for initial selection
				if( Utl.CurrentLineHeadPos(source, match.Groups[1].Index) <= caretIndex )
				{
					initSelNode = node;
				}

				// maintain outline-level
				int level = match.Groups[1].Length;
				switch( level )
				{
					case 1:
						parent = treeView.Nodes;
						break;

					case 2:
						if( prevLevel == 1 )
							parent = prevParent.Nodes;
						else if( prevLevel == 3 )
							parent = prevParent.Parent.Parent.Nodes;
						else if( prevLevel == 4 )
							parent = prevParent.Parent.Parent.Parent.Nodes;
						break;

					case 3:
						if( prevLevel == 1 )
						{
							TreeNode dummyNode = prevParent.Nodes.Add( "(dummy)" );
							parent = dummyNode.Nodes;
						}
						else if( prevLevel == 2 )
						{
							parent = prevParent.Nodes;
						}
						else if( prevLevel == 4 )
						{
							parent = prevParent.Parent.Parent.Nodes;
						}
						break;

					default:
						level = 4;
						if( prevLevel == 1 )
						{
							TreeNode dummyNode = prevParent.Nodes.Add( "(dummy)" );
							dummyNode = dummyNode.Nodes.Add( "(dummy)" );
							parent = dummyNode.Nodes;
						}
						if( prevLevel == 2 )
						{
							TreeNode dummyNode = prevParent.Nodes.Add( "(dummy)" );
							parent = dummyNode.Nodes;
						}
						else if( prevLevel == 3 )
						{
							parent = prevParent.Nodes;
						}
						break;
				}
				prevLevel = level;

				// add node
				parent.Add( node );
				prevParent = node;

				// goto next line
				match = headingPattern.Match( buf, match.Index + match.Length );
			}

			// select initial selection node
			if( initSelNode != null )
			{
				Win32.TreeView_SelectItem( treeView.Handle, initSelNode.Handle );
			}
		}
		#endregion
	}
}
