=begin rdoc

  This is a sample Ruby script for testing outline parser built in AiB Edit.
  This area is an embed documentation area:
  intended to be parsed by a documentation tool.
  So in many cases, these type of area has example code... like this.

  Example:

    class Tiger < MyPrivateZoo::Animal
      attr_reader :price
      
      def initialize( price )
        @price = price;
      end
      
    end

    product.price -> "SFr. 483'232.43"
    
=end
# define a module
module Hoge

	# define a class
	class Tiger
		# define constant
		JAPANESE_NAME = 'Tora'
		
		# append all attributes from class 'Comparable'
		include Comparable

		# define inner class inherited from StandardError
		class TigerError < StandardError # :nodoc:
		end

		# attribute with read-only accessor
		attr_reader :feet
		
		# Initializer (ctor): creates a new object
		def initialize( feet )
		@feet = feet
		end

		# one-line method
		def self.one_line_method; @@free end

		# though here is class definition block, we can write any logic
		return 0 if 3 == 2

		# these are same as 'conditional expression' in C
		p 3==2 ? "foo" : "bar"
		if 3==2 then p "foo" else p "bar" end

		# comparison operator
		def <=>(n)
		end

		# addition operator
		def +(n)
		end

		# subtraction operator
		def -(n)
		end

		# multiplication operator
		def *(n)
		end

		# division operator
		def /(n)
		end

		# 'to_string' method
		def to_s
		self.format
		end

	end
end

# create object
t = Hoge::Tiger.new( 32 )

# using substitution in string
print "Japanese name of Tiger is #{Hoge::Tiger::JAPANESE_NAME}\n"

# access to attribute with read-only accessor
print "t.feet: #{t.feet.to_s}\n"

# singleton class; appending attributes into an object 't'
class << t
	def scmethod( n )
		return n
	end
end
p t.scmethod( 2 )

# singleton method; appending new method into not the class but only the object
def t.smethod( n )
	return n * 2
end
p t.smethod( 2 )

# confusing sample; this is not a here document but a append operator for an array.
neos = 93
ary = []
ary <<neos
print 'This is not a here document but a appending operator.'
neos

# this is the here document with indented terminator
print <<-eos
	This is a here document too, sir :).
	And next 'eos' is not terminator   eos
	eos


def TestFunc

	n = 2
	for i in 0..2
		n = n*n;
	end


	# p[X̂ if CqBend B
	p n if 0 < n

	# A if/else Zq end ̂ŖɂȂȂBOZqƓӖB
	val =	if 0 < n
				'positive'
			else
				'negative'
			end
	p val

	# if Cq́ACƂĊSłȂ΂ȂȂB
	#return 3  if 0 < n # returns 3
	#return  if 0 < n # returns nil

	# ؁EEE
	#return if 0 < n then 'positive' else 'negative' end # _BreturnŊS炩H
	#p if 0 < n then 'positive' else 'negative' end # ̓_炵BpAS炵B
	
	
	# ͈słBif CqƓ͋CȂ̂ŁAނ낱炪{H
	val = if 0 < n then 'positive' else 'negative' end
	p val

	# C̎OZqƓB
	val =	0 < n ? 'positive' : 'negative'
	p val

	# OZqƂĂ if/else uZqvƂ̂炵B
	val =	if 0 < n
				'l'
			else
				'g'
			end
end

def TestFunc2( v )
	p v
end

p TestFunc()
