// file : App.cs
// brief : application entry point
// update : 2007-06-30
//=========================================================
using System;
using System.IO;
using System.Threading;
using System.Collections.Specialized;
using System.Windows.Forms;
using Sgry;
using Sgry.Nbs;
using Sgry.Nbs.Forms;

// set assembly informations
using System.Reflection;
[assembly: AssemblyTitle("AiB Edit")]
[assembly: AssemblyProduct("AiB Edit")]
[assembly: AssemblyCopyright("Copyright 2005-2007, YAMAMOTO Suguru")]
[assembly: AssemblyVersion("2.7.8")]
[assembly: AssemblyDescription(
"A programming editor which is accessible in braille."
)]

namespace Sgry.AiBTools.AiBEdit
{
	/// <summary>
	/// AvP[VǗNX
	/// </summary>
	public class App
	{
		static readonly string	MutexName = "AiBEdit2";
		static readonly string[] hoge = new string[]{ "" };
		static Object obj = new Object();

		/// <summary>
		/// AvP[ṼGg |Cg
		/// </summary>
		[STAThread]
		public static void Main( string[] args )
		{
			int line, column;
			string filePath;
			Mutex mutex;
			bool createdNew;

			// parse argument
			ParseArgs( args, out line, out column, out filePath );

			// check whether another process exists or not
			mutex = new Mutex( false, MutexName, out createdNew );
			if( createdNew )
			{
				SharedData.Lock();

				// launch application
				AppLogic app = new AppLogic();
				AiBEditForm	view = new AiBEditForm( app );

				// initialize inter-process shared data
				SharedData.Init( view.Handle );
				
				// initialize braille engine
				NbsEngine.Init();

				// initialize application
				app.SetMainWindow( view );
				app.LoadConfig();

				// initialize document
				if( filePath != String.Empty )
				{
					bool okay;
					okay = app.OpenDocument( filePath );
					if( okay )
					{
						app.ActiveDocument.SetCaretIndex( line-1, column-1 );
					}
					else
					{
						// cancel opening. close empty document and create untitled one
						app.CloseDocument();
						app.CreateUntitledDocument();
					}
				}
				else
				{
					app.CreateUntitledDocument();
				}

				SharedData.Unlock();

				Application.Run( view );
			}
			else
			{
				IntPtr mainWindow;

				SharedData.Lock();

				// get existent window
				mainWindow = SharedData.GetWindowHandle();
				if( mainWindow == IntPtr.Zero )
				{
					throw new Exception( "failed to get existent AiB Edit window." );
				}

				// prepare for controling the process for opening file
				SharedData.AddProcessData( filePath );

				// activate the window, activate the document, and move caret.
				ActivateWindow( mainWindow );
				SharedData.Unlock();
				Win32.SendMessage( mainWindow, AiBEditForm.AIBE_OPENFILE, IntPtr.Zero, IntPtr.Zero );
				Win32.SendMessage( mainWindow, AiBEditForm.AIBE_MOVECARET, new IntPtr(line), new IntPtr(column) );
			}

			mutex.Close();
		}

		#region  (̒̓p[XȂ)
		/// <summary>
		/// R}hC
		/// </summary>
		static void ParseArgs( string[] args, out int line, out int column, out string filePath )
		{
			line = 0;
			column = 0;
			filePath = "";

			foreach( string arg in args )
			{
				int equalIndex = arg.IndexOf( '=' );
				if( arg.StartsWith("--line") && equalIndex != -1 )
				{
					string value = arg.Substring( equalIndex+1 );
					try
					{
						line = Int32.Parse( value );
					}
					catch
					{}
				}
				else if( arg.StartsWith("--col") && equalIndex != -1 )
				{
					string value = arg.Substring( equalIndex+1 );
					try
					{
						column = Int32.Parse( value );
					}
					catch
					{}
				}
				else if( arg.StartsWith("--column") && equalIndex != -1 )
				{
					string value = arg.Substring( equalIndex+1 );
					try
					{
						column = Int32.Parse( value );
					}
					catch
					{}
				}
				else
				{
					filePath = Path.Combine( Environment.CurrentDirectory, arg );
				}
			}
			//DEBUG//MessageBox.Show( String.Format("{2}\ncaret:({0}, {1})", line, column, filePath) );
		}

		/// <summary>
		/// wEBhEԎOɈړ
		/// </summary>
		/// <param name="hWnd">OɎĂEBhẼnh</param>
		static void ActivateWindow( IntPtr wndHdl )
		{
			// 1px l̃_~[tH[W(5000,5000)ɍăANeBuɂA
			// ƃANeBuԂB
			// bB
			Form dummyForm = new Form();
			dummyForm.StartPosition = FormStartPosition.Manual;
			dummyForm.Location = new System.Drawing.Point( 5000, 5000 );
			dummyForm.MinimizeBox = false;
			dummyForm.MaximizeBox = false;
			dummyForm.MinimumSize = new System.Drawing.Size( 1, 1 );
			dummyForm.FormBorderStyle = FormBorderStyle.None;
			dummyForm.Width = 1;
			dummyForm.Height = 1;
			dummyForm.Show();

			Win32.SendMessage( wndHdl, Win32.WM_ACTIVATE, new IntPtr(1), dummyForm.Handle );
			Win32.BringWindowToTop( wndHdl );

			dummyForm.Dispose();
		}
		#endregion
		
		[DllImport("user32.dll", EntryPoint="SendMessageW")]
		public static extern IntPtr SendMessage( IntPtr hWnd, int msg, IntPtr wparam, IntPtr lparam );
		
		/// <summary>
		/// AvP[VŜ̐ݒǗÓINX
		/// </summary>
		internal class AppConfig
		{
			static string	_ConfigDirPath;
			static string	_ConfigFilePath;
			static string	_MruFilePath;
			static Ini		_Mru;

			/// <summary>
			/// NX
			/// </summary>
			public static void Init()
			{
				// load Most Recent Used data
				try
				{
					// but if the file size is larger than 1MB, it may be corrupted
					FileInfo f = new FileInfo( MruFilePath );
					if( 1000000 < f.Length )
					{
						throw new FileNotFoundException(); // corrupted so delete that file
					}

					_Mru = new Ini();
					_Mru.LoadFromFile( MruFilePath );
				}
				catch( FileNotFoundException )
				{
					// not found the MRU file. create it.
					File.Create( MruFilePath ).Close();
				}
			}

			#region t@CpX֘A
			/// <summary>
			/// ݒt@CfBNg̃pX
			/// </summary>
			public static string ConfigDirectoryPath
			{
				get
				{
					if( _ConfigDirPath == null )
					{
						_ConfigDirPath = Environment.GetFolderPath( Environment.SpecialFolder.ApplicationData );
						_ConfigDirPath = Path.Combine( _ConfigDirPath, "AiBTools" );
						_ConfigDirPath = Path.Combine( _ConfigDirPath, "AiBEdit" );
						if( Directory.Exists(_ConfigDirPath) != true )
						{
							Directory.CreateDirectory( _ConfigDirPath );
						}
					}

					return _ConfigDirPath;
				}
			}

			/// <summary>
			/// ݒt@C̃pX
			/// </summary>
			public static string ConfigFilePath
			{
				get
				{
					if( _ConfigFilePath == null )
					{
						_ConfigFilePath = Path.Combine( ConfigDirectoryPath, "AiBEdit.ini" );
					}

					return _ConfigFilePath;
				}
			}

			/// <summary>
			/// MRU t@C̃pX
			/// </summary>
			public static string MruFilePath
			{
				get
				{
					if( _MruFilePath == null )
					{
						_MruFilePath = Path.Combine( ConfigDirectoryPath, "MRU.ini" );
					}

					return _MruFilePath;
				}
			}
			#endregion

			#region MRU
			/// <summary>
			/// uŋߎgt@CṽpX 17 擾
			/// </summary>
			public static string[] Get17MruFilePaths()
			{
				ArrayList allMruFilePaths = new ArrayList();

				Ini.Section mruSection = _Mru[ "MRU" ];
				for( int i=0; i<mruSection.Count; i++ )
				{
					if( 0x0F < i )
						break;
					allMruFilePaths.Add( mruSection[i].Value );
				}

				return (string[])allMruFilePaths.ToArray( typeof(string) );
			}

			/// <summary>
			/// MRU ꗗɏނށB
			/// </summary>
			public static void AddMru( Document doc )
			{
				if( doc.Path == null )
					return;

				try
				{
					AddToMruSection( doc.Path );
					AddToMruHistory( doc );
				}
				catch( IOException )
				{}
			}

			/// <summary>
			/// wt@C MRU 擾
			/// </summary>
			/// <param name="filePath">MRU 擾t@C̃pX</param>
			/// <param name="encoding">OҏW̃GR[fBO</param>
			/// <param name="withBom">OҏW BOM R[hL</param>
			/// <param name="caretLine">OҏW̃Lbgsʒu</param>
			/// <param name="caretColumn">OҏW̃Lbgʒu</param>
			public static void GetMruFileInfo( string filePath,
				out Encoding encoding, out bool withBom,
				out int caretLine, out int caretColumn )
			{
				try
				{
					encoding = Encoding.GetEncoding( _Mru[filePath]["Encoding"] );
					withBom = Boolean.Parse( _Mru[filePath]["WithBom"] );
					caretLine = Int32.Parse( _Mru[filePath]["CaretLine"] );
					caretColumn = Int32.Parse( _Mru[filePath]["CaretColumn"] );
				}
				catch
				{
					encoding = null;
					withBom = false;
					caretLine = 0;
					caretColumn = 0;
				}
			}

			/// <summary>
			/// MRU.ini  MRU ZNVɎwt@CpXǉ
			/// </summary>
			/// <exception cref="IOException">
			/// t@Co̓G[
			/// </exception>
			static void AddToMruSection( string filePath )
			{
				const int MaxMruCount = 50;
				int mruNo;
				StringCollection newMru = new StringCollection();
				Ini.Section mruSection = _Mru[ "MRU" ];
				
				// make list of 50 MRU info
				newMru.Add( filePath );
				for( mruNo=0; mruNo<mruSection.Count; mruNo++ )
				{
					// if already got 50, proceed to next
					if( MaxMruCount <= mruNo )
					{
						break;
					}

					string entryName = mruSection[ "MRU" + mruNo.ToString("D2") ];
					if( entryName.StartsWith(filePath) == false )
					{
						newMru.Add( entryName );
					}
				}

				// if there are left MRU data, remove it from INI to save file size
				for( ; mruNo<mruSection.Count; mruNo++ )
				{
					string entryName = mruSection[ "MRU" + mruNo.ToString("D2") ];
					_Mru.Remove( entryName );
				}

				// update INI object
				for( mruNo=0; mruNo<newMru.Count; mruNo++ )
				{
					mruSection[ "MRU" + mruNo.ToString("D2") ] = newMru[ mruNo ];
				}

				// then overwrite the INI file
				_Mru.SaveToFile( MruFilePath, Encoding.UTF8 );
			}

			static void AddToMruHistory( Document doc )
			{
				int line, column;
				
				// write the document information
				doc.GetCaretIndex( out line, out column );
				_Mru[ doc.Path ]["Encoding"] = doc.Encoding.WebName;
				_Mru[ doc.Path ]["WithBom"] = doc.WithBom.ToString();
				_Mru[ doc.Path ]["CaretLine"] = line.ToString();
				_Mru[ doc.Path ]["CaretColumn"] = column.ToString();
				_Mru[ doc.Path ]["Bookmarks"] = " ";
				
				// update INI file
				_Mru.SaveToFile( MruFilePath, Encoding.UTF8 );
			}
			#endregion

			#region Avݒ
			/// <summary>
			/// AvP[V̐ݒۑ
			/// </summary>
			/// <param name="view">CtH[</param>
			/// <param name="brailleConfig">_\ݒ</param>
			/// <param name="deviceConfig">_foCXݒ</param>
			/// <param name="findCondition"></param>
			public static void SaveConfig( AiBEditForm view,
					BrailleConfig brailleConfig, DeviceConfig deviceConfig,
					FindCondition findCondition )
			{
				Ini	ini = new Ini();

				// save config to file
				try
				{
					// load config file if it exists
					if( File.Exists(ConfigFilePath) )
					{
						ini.LoadFromFile( ConfigFilePath );
					}
					// if it does not exist, create an empty file to store config
					else
					{
						File.Create(ConfigFilePath).Close();
					}

					// store config
					ini["AiBEditForm"]["UseBrailleDisplay"] = view.UsingBraille.ToString();
					ini["AiBEditForm"]["FindCondition.IgnoreCase"] = findCondition.IgnoreCase.ToString();
					ini["AiBEditForm"]["FindCondition.UseRegex"] = findCondition.UseRegex.ToString();
					ini.SaveToFile( ConfigFilePath, Encoding.UTF8 );
					
					brailleConfig.Serialize( ConfigDirectoryPath );
					deviceConfig.Serialize( ConfigDirectoryPath );
				}
	#			if DEBUG
				catch( Exception ex )
				{
					Console.Error.Write( ex.StackTrace );
				}
	#			else
				catch
				{}
	#			endif
			}

			/// <summary>
			/// AvP[V̐ݒ𕜌
			/// </summary>
			/// <param name="view">CtH[</param>
			/// <param name="brailleConfig">_\ݒ</param>
			/// <param name="deviceConfig">_foCXݒ</param>
			/// <param name="findCondition"></param>
			public static void LoadConfig( AiBEditForm view,
					ref BrailleConfig brailleConfig, ref DeviceConfig deviceConfig,
					ref FindCondition findCondition )
			{
				// load preference from file
				try
				{
					Ini	ini = new Ini();
					ini.LoadFromFile( ConfigFilePath, Encoding.UTF8 );
					view.UsingBraille = Boolean.Parse( ini["AiBEditForm"]["UseBrailleDisplay"] );
					findCondition.IgnoreCase = Boolean.Parse( ini["AiBEditForm"]["FindCondition.IgnoreCase"] );
					bool useRegex = Boolean.Parse( ini["AiBEditForm"]["FindCondition.UseRegex"] );
					if( useRegex )
					{
						findCondition.Regex = new Regex( "" );
					}
					
					brailleConfig = BrailleConfig.Deserialize( ConfigDirectoryPath );
					deviceConfig = DeviceConfig.Deserialize( ConfigDirectoryPath );
				}
				catch
				{
					// ensure the config directory exists
					System.IO.Directory.CreateDirectory( ConfigDirectoryPath );
				}
			}
			#endregion
		}
	}
}
