// file: SharedData.cs
// brief: inter-process shared data manager class for AiB Edit
// update: 2008-09-28
//=========================================================
using System;
using System.IO;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using System.Diagnostics;

namespace Sgry.AiBTools.AiBEdit
{
	/// <summary>
	/// vZXԂŋLf[^ǗB
	/// ׂĂ̑̓vZXԂœĎs܂B
	/// </summary>
	static class SharedData
	{
		const int WaitInterval = 200;
		const int WaitLimit = 4000;
		const string ProcessDataMutexName = Program.MutexBaseName + "_SharedData";
		static string _SharedDataFilePath;
		static Mutex _Mutex;

		#region Properties
		/// <summary>
		/// ÑvZXLLt@C̃pXB
		/// </summary>
		static string SharedDataFilePath
		{
			get
			{
				if( _SharedDataFilePath == null )
				{
					_SharedDataFilePath = Path.Combine( AppConfig.ConfigDirectoryPath, ".SharedData" );
				}
				return _SharedDataFilePath;
			}
		}
		#endregion

		/// <summary>
		/// Lf[^t@C폜B
		/// </summary>
		public static void DeleteSharedDataFile()
		{
			if( File.Exists(SharedDataFilePath) )
			{
				File.Delete( SharedDataFilePath );
			}
		}

		#region Window handle of the main window
		/// <summary>
		/// Lf[^B
		/// f[^ɂŃCEBhẼnho^܂B
		/// </summary>
		public static void Init( IntPtr mainWindowHandle )
		{
			StreamWriter writer;

			Lock();
			try
			{
				// Lf[^t@Cnhlɂ
				using( writer = new StreamWriter(OpenSharedDataFile(), Encoding.UTF8) )
				{
					writer.BaseStream.SetLength( 0 ); // t@Cɂ
					writer.WriteLine( mainWindowHandle.ToString() );
				}
			}
			finally
			{
				Unlock();
			}
		}

		/// <summary>
		/// łɋNĂ郁CEBhẼnh擾B
		/// </summary>
		public static IntPtr GetWindowHandle()
		{
			IntPtr mainWindow;
			StreamReader reader;

			Lock();
			try
			{
				using( reader = new StreamReader(OpenSharedDataFile()) )
				{
					string line = reader.ReadLine();
					mainWindow = new IntPtr( Int64.Parse(line) );
				}

				return mainWindow;
			}
			finally
			{
				Unlock();
			}
		}
		#endregion

		#region Editing File List
		/// <summary>
		/// JĂt@C̃pXLf[^ɒǉB
		/// </summary>
		public static void AddProcessData( string filePath )
		{
			StreamWriter writer;
			StreamReader reader;
			FileStream file = null;
			string line;
			bool doAppend = true;

			if( filePath == String.Empty )
			{
				return; // VK쐬ȂLKv͖
			}

			// Ô߂Ƀt@CpX𐳊mȂ̂
			filePath = ReGetFilePath( filePath );

			Lock();
			try
			{
				file = OpenSharedDataFile();

				// t@CpXłɏ܂ĂȂmF
				reader = new StreamReader( file, Encoding.UTF8 );
				line = reader.ReadLine();
				while( line != null )
				{
					if( line == filePath )
					{
						// łɏ܂Ă
						doAppend = false;
						break;
					}
					line = reader.ReadLine();
				}

				// ܂ĂȂ΁At@CpXǋL
				if( doAppend )
				{
					writer = new StreamWriter( file, Encoding.UTF8 );
					file.Position = file.Length;
					writer.WriteLine( filePath );
					writer.Flush();
				}
			}
			finally
			{
				if( file != null )
					file.Close();
				Unlock();
			}
		}

		/// <summary>
		/// JĂt@C̃pXLf[^폜B
		/// </summary>
		/// <param name="filePath">JĂt@C̃pX</param>
		public static void RemoveProcessData( string filePath )
		{
			StreamReader	reader;
			StreamWriter	writer;
			FileStream		file = null;
			string			line;
			StringBuilder	buffer = new StringBuilder();

			// VK쐬hLgҏWĂȂ
			// Lt@CɉL^ĂȂ̂ō폜Kv
			if( filePath == String.Empty )
			{
				return;
			}

			Lock();
			try
			{
				file = OpenSharedDataFile();

				// w肳ꂽvZXŝsobt@ɃRs[
				reader = new StreamReader( file );
				line = reader.ReadLine();
				while( line != null )
				{
					if( line != filePath )
					{
						buffer.AppendLine( line );
					}

					line = reader.ReadLine();
				}
				
				// obt@
				file.SetLength( 0 ); // ɂ
				writer = new StreamWriter( file );
				writer.Write( buffer.ToString() );
				writer.Flush();
			}
			finally
			{
				if( file != null )
					file.Close();
				Unlock();
			}
		}
		
		/// <summary>
		/// Lt@C̍ŏIs擾B
		/// łɑ AiB Edit NĂłɋNꂽ
		/// Nς݂ AiB Edit O䂷邽߂ɗpB
		/// </summary>
		/// <returns>Lt@C̍ŏIs</returns>
		public static string GetLastLine()
		{
			StreamReader reader;
			string line, lastLine = "";

			Lock();
			try
			{
				// Lf[^t@CJ
				using( reader = new StreamReader(OpenSharedDataFile()) )
				{
					// ŌɓǂݏosۑȂ炷ׂĂ̍sǂݏo
					line = reader.ReadLine();
					while( line != null )
					{
						// ̍sL
						lastLine = line;

						// ̍sǂݏo
						line = reader.ReadLine();
					}
				}
			}
			finally
			{
				Unlock();
			}

			return lastLine;
		}
		#endregion

		#region Utilities
		static FileStream OpenSharedDataFile()
		{
			string dirPath;

			// t@CׂfBNg݂̑mF
			dirPath = Path.GetDirectoryName( SharedDataFilePath );
			if( !Directory.Exists(dirPath) )
			{
				Directory.CreateDirectory( dirPath );
			}

			return File.Open( SharedDataFilePath, FileMode.OpenOrCreate, FileAccess.ReadWrite, FileShare.Read );
		}

		/// <summary>
		/// t@CVXe琳mȃpXĎ擾B
		/// </summary>
		/// <param name="filePath">mȃpXĎ擾t@C̃pX</param>
		/// <returns>Ď擾pX</returns>
		/// <remarks>
		/// Windows ł͑啶ʂƕsȃpXłgĂ܂B
		/// 啶̕ʂmɎ擾邽߂ɌĂԁB
		/// </remarks>
		static string ReGetFilePath( string filePath )
		{
			if( File.Exists(filePath) == false )
				return filePath;

			string dir = Path.GetDirectoryName( filePath );
			dir = Path.GetFullPath( dir );
			string filter = Path.GetFileName( filePath );
			return Directory.GetFiles( dir, filter )[0];
		}

		/// <summary>
		/// Lt@Cւ̃ANZX擾B
		/// </summary>
		static void Lock()
		{
			int elapsedTime;
			
			// get a named mutex to synchronize AiB Edit processes
			_Mutex = new Mutex( true, ProcessDataMutexName );
			elapsedTime = 0;
			while( _Mutex.WaitOne(WaitInterval, true) == false )
			{
				elapsedTime += WaitInterval;
				if( WaitLimit < elapsedTime )
				{
					// ҂̂ňُƌȂ
					throw new Exception( "failed to get Mutex object for SharedData (timeout)" );
				}
			}
		}

		/// <summary>
		/// Lt@Cւ̃ANZXԏB
		/// </summary>
		static void Unlock()
		{
			if( _Mutex != null )
			{
				_Mutex.Close();
				_Mutex = null;
			}
		}
		#endregion
	}
}
