// file: RubyFileType.cs
// brief: File type class for Ruby
// update: 2007-02-25
//=========================================================
using System;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBEdit
{
	/// <summary>
	/// Ruby ̃\[Xt@Ct@C^Cv
	/// </summary>
	class RubyFileType : IFileType
	{
		/// <summary>
		/// t@CޖBMRU ۑɎgB
		/// </summary>
		public string Name
		{
			get{ return "Ruby"; }
		}

		/// <summary>
		/// wpX̃t@C邩
		/// </summary>
		/// <param name="filePath">肷t@C̃pX</param>
		/// <returns>ꍇtrue</returns>
		public bool CanHandleFile( string filePath )
		{
			const bool IGNORE_CASE = true;
			string fileExt;
			
			// gq rb Ȃ爵
			fileExt = Path.GetExtension( filePath );
			if( String.Compare(fileExt, ".rb", IGNORE_CASE) == 0 )
			{
				return true;
			}

			return false;
		}

		/// <summary>
		/// ̃AEgC\
		/// </summary>
		/// <returns>[UIV{CfbNX</returns>
		public int ShowOutline( Form owner, string docContent, int caretIndex )
		{
			DialogResult	result;
			Outliner		parser;

			using( OutlineDialog dialog = new OutlineDialog() )
			{
				// setup dialog
				dialog.Size = owner.Size;
				dialog.Location = owner.Location;
				
				// parse
				parser = new RubyOutliner( dialog, docContent, caretIndex );
				parser.Parse();

				// show dialog
				result = dialog.ShowDialog( owner );
				if( result != DialogResult.OK )
				{
					return -1;
				}

				// return index of the selected symbol
				return dialog.SelectedSymbolIndex;
			}
		}

		/// <summary>
		/// ҏWΏۂRpC
		/// </summary>
		/// <returns>RpC</returns>
		public CompileResult Compile( Document doc )
		{
			return CompileResult.FailedToExecute;
		}

		/// <summary>
		/// rhR}hs
		/// </summary>
		/// <returns>RpC</returns>
		public CompileResult Build( Document doc )		
		{
			return CompileResult.FailedToExecute;
		}
	}
}
