// file: Program.cs
// brief: application entry point
//=========================================================
using System;
using System.IO;
using System.Threading;
using System.Collections.Specialized;
using System.Windows.Forms;
using CultureInfo = System.Globalization.CultureInfo;

// set assembly informations
using System.Reflection;
[assembly: AssemblyTitle("AiB Edit")]
[assembly: AssemblyProduct("AiB Edit")]
[assembly: AssemblyCopyright("(C) 2005-2013 Suguru YAMAMOTO")]
[assembly: AssemblyVersion("3.2.2.*")]
[assembly: AssemblyDescription(
"A programming editor which is accessible in braille."
)]

namespace Sgry.AiBTools.AiBEdit
{
	/// <summary>
	/// AvP[VNB
	/// </summary>
	class Program
	{
		public const string MutexBaseName = "AiBEdit31";
		const string AppInstanceMutexName = MutexBaseName + "_AppInstance";
		const string LaunchingMutexName = MutexBaseName + "_Launching";
		const int WaitInterval = 100;
		const int WaitLimit = 4000;

		#region N
		[STAThread]
		static void Main( string[] args )
		{
			int line, column;
			string filePath;
			Mutex appInstMutex, launchingMutex;
			bool createdNew;

			Application.EnableVisualStyles();

			// override exception handler (release build only)
#			if !(DEBUG)
			Application.ThreadException += AiBExceptionHandler.OnThreadException;
#			endif
			
			// R}hC
			ParseArgs( args, out line, out column, out filePath );

			// AiB Edit ̃vZX܂݂ȂΕʂɋNB
			// łɑ݂ꍇ͋N AiB Edit ֐ڂB
			appInstMutex = new Mutex( false, AppInstanceMutexName, out createdNew );
			if( createdNew )
			{
				// AiB Edit ̃vZX͂܂݂ȂB
				AppLogic app;

				// AvP[V̋Ns
				// iMutex ŃvZXԂŎsVACYj
				launchingMutex = new Mutex( true, LaunchingMutexName );
				{
					app = new AppLogic( line, column, filePath );
				}
				launchingMutex.ReleaseMutex();
				launchingMutex.Close();

				// ݒt@C̃fBNg΍쐬Ă
				if( !Directory.Exists(AppConfig.ConfigDirectoryPath) )
				{
					Directory.CreateDirectory( AppConfig.ConfigDirectoryPath );
				}

				// N
				try
				{
					app.Run();
				}
				finally
				{
					app.Dispose();
				}
			}
			else
			{
				// AiB Edit ̃vZXłɑ݂ĂB
				// łɂvZX֐ڂ
				launchingMutex = new Mutex( true, LaunchingMutexName );
				{
					// ̃vZXƋNsȂ悤
					// vZX̋NI܂ő҂
					int elapsedTime = 0;
					while( launchingMutex.WaitOne(WaitInterval, true) == false )
					{
						elapsedTime += WaitInterval;
						if( WaitLimit < elapsedTime )
						{
							// ҂̂ňُƌȂ
							throw new Exception( "failed to get Mutex object for serialization of application launching." );
						}
					}

					// vZXւ̐ڂ
					DelegateToExistingInstance( line, column, filePath );
				}
				launchingMutex.ReleaseMutex();
				launchingMutex.Close();
			}

			appInstMutex.Close();
		}

		static void DelegateToExistingInstance( int line, int column, string filePath )
		{
			IntPtr mainWindow;

			// łɋNĂEBhE擾
			mainWindow = SharedData.GetWindowHandle();
			if( mainWindow == IntPtr.Zero )
			{
				throw new Exception( "failed to get existent AiB Edit window." );
			}

			// EBhEANeBuɂ
			if( filePath != String.Empty )
			{
				// prepare for controlling the process for opening file
				SharedData.AddProcessData( filePath );

				// activate the window, activate the document, and move caret.
				ActivateWindow( mainWindow );
				Win32.SendMessage( mainWindow, AiBEditForm.AIBE_OPENFILE, new IntPtr(line-1), new IntPtr(column-1) );
			}
			else
			{
				// simply activate the window
				ActivateWindow( mainWindow );
			}
		}
		#endregion

		#region 
		/// <summary>
		/// R}hC
		/// </summary>
		static void ParseArgs( string[] args, out int line, out int column, out string filePath )
		{
			line = 0;
			column = 0;
			filePath = "";

			foreach( string arg in args )
			{
				int equalIndex = arg.IndexOf( '=' );
				if( arg.StartsWith("--line") && equalIndex != -1 )
				{
					string value = arg.Substring( equalIndex+1 );
					try
					{
						line = Int32.Parse( value );
					}
					catch
					{}
				}
				else if( arg.StartsWith("--col") && equalIndex != -1 )
				{
					string value = arg.Substring( equalIndex+1 );
					try
					{
						column = Int32.Parse( value );
					}
					catch
					{}
				}
				else if( arg.StartsWith("--column") && equalIndex != -1 )
				{
					string value = arg.Substring( equalIndex+1 );
					try
					{
						column = Int32.Parse( value );
					}
					catch
					{}
				}
				else if( arg.StartsWith("--locale") && equalIndex != -1 )
				{
					string value = arg.Substring( equalIndex+1 );
					try
					{
						Environment.SetEnvironmentVariable(
							"LANG", value, EnvironmentVariableTarget.Process
						);
						Thread.CurrentThread.CurrentUICulture = new CultureInfo( value );
					}
					catch
					{}
				}
				else
				{
					filePath = Path.Combine( Environment.CurrentDirectory, arg );
				}
			}
			//DEBUG//MessageBox.Show( String.Format("{2}\ncaret:({0}, {1})", line, column, filePath) );
		}

		/// <summary>
		/// wEBhEԎOɈړ
		/// </summary>
		/// <param name="hWnd">OɎĂEBhẼnh</param>
		static void ActivateWindow( IntPtr wndHdl )
		{
			// 1px l̃_~[tH[W(65535,65535)ɍăANeBuɂA
			// ƃANeBuԂB
			// bB
			Form dummyForm = new Form();
			dummyForm.StartPosition = FormStartPosition.Manual;
			dummyForm.Location = new System.Drawing.Point( 65535, 65535 );
			dummyForm.MinimizeBox = false;
			dummyForm.MaximizeBox = false;
			dummyForm.MinimumSize = new System.Drawing.Size( 1, 1 );
			dummyForm.FormBorderStyle = FormBorderStyle.None;
			dummyForm.Width = 1;
			dummyForm.Height = 1;
			dummyForm.Show();

			Win32.SendMessage( wndHdl, Win32.WM_ACTIVATE, new IntPtr(1), dummyForm.Handle );
			Win32.BringWindowToTop( wndHdl );

			dummyForm.Dispose();
		}
		#endregion
	}
}
