// file: Outliner.cs
// brief: Base class of outline parsers used by AiB Edit.
// update: 2008-10-05
//=========================================================
using System;
using System.Text;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBEdit
{
	/// <summary>
	/// ̃AEgC͊
	/// </summary>
	abstract class Outliner
	{
		protected OutlineDialog _Dialog;
		protected string _Source;
		protected int _CaretIndex;
		protected readonly TreeNode _DummyNode = new TreeNode( "(No symbols)" );

		/// <summary>
		/// CX^X𐶐
		/// </summary>
		/// <param name="dialog">V{\AEgC_CAO</param>
		/// <param name="source">͂镶</param>
		/// <param name="caretIndex">݂̃Lbgʒu</param>
		public Outliner( OutlineDialog dialog, string source, int caretIndex )
		{
			_Dialog = dialog;
			_Source = source;
			_CaretIndex = caretIndex;

			// V{ꍇɎg_~[m[hĂ
			AppLogic.Localizer.TryGetString( "Msg_NoSymbolsFound", _DummyNode );
		}

		/// <summary>
		/// V{𒊏oăc[Rg[ɕ\
		/// </summary>
		public abstract void Parse();

		#region ͗p֐Q
		public class Utl
		{
			public static TreeNode FindNodeByNameIn( TreeNodeCollection nodes, string name )
			{
				foreach( TreeNode node in nodes )
				{
					if( node.Text == name )
					{
						return node;
					}

					if( 0 < node.Nodes.Count )
					{
						TreeNode n = FindNodeByNameIn( node.Nodes, name );
						if( n != null )
							return n;
					}
				}

				return null;
			}

			/// <summary>
			/// wʒuɂP擾B
			/// piLށj͒P̍\vƌȂȂB
			/// </summary>
			public static string WordAt( string str, int wordPosition )
			{
				int	begin, end;
				int firstCharT;
				
				if( str.Length <= wordPosition )
					return String.Empty;

				firstCharT = GetCharType( str[wordPosition] );
				
				try
				{
					begin = wordPosition;
					while( GetCharType(str[begin]) == firstCharT )
					{
						begin--;
					}
					begin++;
				}
				catch( IndexOutOfRangeException )
				{
					begin = 0;
				}

				try
				{
					end = wordPosition;
					while( GetCharType(str[end]) == firstCharT )
					{
						end++;
					}
				}
				catch( IndexOutOfRangeException )
				{
					end = str.Length;
				}

				return str.Substring( begin, end - begin );
			}
			static int GetCharType( char ch )
			{
				if( ch == '_' )  return 0;
				if( ch == '(' || ch == ')' )  return 10; // treet these specially
				if( Char.IsLetterOrDigit(ch) )  return 0;
				if( Char.IsWhiteSpace(ch) )  return 1;
				return 2;
			}
			
			/// <summary>
			/// wʒu̎ɂP̈ʒu擾B
			/// </summary>
			/// <returns>s-1</returns>
			public static int NextWordPos( string str, int startIndex )
			{
				int preWordWhiteSpacePos = NextWhiteSpacePos( str, startIndex );
				if( preWordWhiteSpacePos == -1 )
				{
					return -1;
				}

				return NextNonWhiteSpacePos( str, preWordWhiteSpacePos );
			}

			/// <summary>
			/// wʒu̎ɂ󔒕̈ʒu擾
			/// </summary>
			/// <returns>s-1</returns>
			public static int NextNonWhiteSpacePos( string str, int startIndex )
			{
				for( int i=startIndex; i<str.Length; i++ )
				{
					if( Char.IsWhiteSpace(str, i) == false )
						return i;
				}

				return -1;
			}

			/// <summary>
			/// wʒu̎ɂ󔒒P擾BsstartIndex̒l܂B
			/// </summary>
			/// <returns>s null</returns>
			public static string NextNonWhiteSpaceToken( string str, ref int startIndex )
			{
				int nextWordPos = NextWordPos( str, startIndex );
				if( nextWordPos == -1 )
					return null;

				startIndex = nextWordPos;
				return WordAt( str, nextWordPos );
			}

			/// <summary>
			/// wʒu̎ɂ󔒕̈ʒu擾
			/// </summary>
			public static int NextWhiteSpacePos( string str, int startIndex )
			{
				for( int i=startIndex; i<str.Length; i++ )
				{
					if( Char.IsWhiteSpace(str, i) )
						return i;
				}

				return -1;
			}

			/// <summary>
			/// wʒȗOɂ󔒕̈ʒu擾
			/// </summary>
			public static int PrevNonWhiteSpacePos( string str, int startIndex )
			{
				for( int i=startIndex; i>=0; i-- )
				{
					if( Char.IsWhiteSpace(str, i) == false )
						return i;
				}

				return -1;
			}

			/// <summary>
			/// wʒȗOɂ󔒕̈ʒu擾
			/// </summary>
			public static int PrevWhiteSpacePos( string str, int startIndex )
			{
				for( int i=startIndex; i>=0; i-- )
				{
					if( Char.IsWhiteSpace(str, i) )
						return i;
				}

				return -1;
			}

/*
/// <summary>
/// ^Cv擾
/// </summary>
public static int GetCharType( char ch )
{
	if( '0' <= ch && ch <= '9' )	return 0;
	if( 'A' <= ch && ch <= 'Z' )	return 0;
	if( 'a' <= ch && ch <= 'z' )	return 0;
	if( ch == '_' || ch == '?' || ch == '.' )
		return 0;
	if( ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n' )
		return 2;

	return 1;
}
*/

			/// <summary>
			/// wʒu̎ɂs̈ʒu擾
			/// </summary>
			public static int NextLineHeadPos( string str, int startIndex )
			{
				int pos;
				
				try
				{
					// skip until new line codes appear
					pos = startIndex;
					while( str[pos] != '\r' && str[pos] != '\n' )
					{
						pos++;
					}

					// then, skip until new line codes disappear
					while( str[pos] == '\r' || str[pos] == '\n' )
					{
						pos++;
					}
				}
				catch( IndexOutOfRangeException )
				{
					return -1;
				}

				return pos;
			}

			/// <summary>
			/// wʒu܂ލs̈ʒu擾
			/// </summary>
			public static int CurrentLineHeadPos( string str, int startIndex )
			{
				int pos;
				
				// skip until new line codes appear
				pos = startIndex;
				while( str[pos] != '\r' && str[pos] != '\n' )
				{
					if( pos <= 0 )
					{
						return 0;
					}

					pos--;
				}

				return pos + 1;
			}

			/// <summary>
			/// wʒuwʒu܂ł̊Ԃ󔒂ɒu
			/// </summary>
			public static int EmptyToPattern( string src, int startPos, int endPos, ref StringBuilder buffer )
			{
				for( int i=0; i<(endPos - startPos); i++ )
				{
					buffer.Append( ' ' );
				}
				return endPos;
			}

			/// <summary>
			/// wʒuwp^[܂ł̊Ԃ󔒂ɒu
			/// </summary>
			public static int EmptyToPattern( string src, int startPos, string destWord, ref StringBuilder buffer )
			{
				int endPos;

				endPos = src.IndexOf( destWord, startPos+1 );
				if( endPos == -1 )
				{
					endPos = src.Length - 1; // not closed; strip all following chars
				}
				else
				{
					endPos += destWord.Length;
				}

				return EmptyToPattern( src, startPos, endPos, ref buffer );
			}
		}
		#endregion
	}
}
