// file: OptionDialog.cs
// brief: dialog window for program options
// update: 2008-12-20
//=========================================================
using System;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBEdit
{
	using AT;
	using Gui;

	/// <summary>
	/// IvVݒ_CAO
	/// </summary>
	class OptionDialog : AiBDialogBase
	{
		AzukiOptionDialog _AzukiOptionDialog = new AzukiOptionDialog();
		AzukiOption _AzukiOption = AzukiOption.Default;

		#region Init / Dispose
		public OptionDialog()
		{
			InitializeComponent();
			LocalizeComponent();
			AutoScaleMode = AutoScaleMode.Font;
			Font = SystemInformation.MenuFont;
			FormBorderStyle = FormBorderStyle.FixedDialog;
			AcceptButton = _Button_Ok;
			CancelButton = _Button_Cancel;
			StartPosition = FormStartPosition.CenterParent;

			UseAzuki = (AppConfig.EngineType == "Azuki");
			UseSmartHome = AppConfig.UseSmartHome;
			AutoIndentMode = AppConfig.AutoIndentMode;
			_AzukiOption = AppConfig.AzukiOption;
		}

		protected override void Dispose( bool disposing )
		{
			_ComboBoxReader.Dispose();
			_AzukiOptionDialog.Dispose();
			base.Dispose( disposing );
		}

		void Form_Activated( object sender, EventArgs e )
		{
			_ControlBrailler.UpdateDisplay();
		}
		#endregion

		#region Properties
		/// <summary>
		/// eLXgGfB^̃GW
		/// </summary>
		public bool UseAzuki
		{
			get{ return _Check_UseAzuki.Checked; }
			set{ _Check_UseAzuki.Checked = value; }
		}

		/// <summary>
		/// Home L[ōsł͂Ȃŏ̔󔒕ɃLbgړ邩ǂ
		/// </summary>
		public bool UseSmartHome
		{
			get{ return (_Combo_HomeKey.SelectedIndex == 1); }
			set{ _Combo_HomeKey.SelectedIndex = (value ? 1 : 0); }
		}

		/// <summary>
		/// Cfg̃[hB
		/// </summary>
		public AutoIndentMode AutoIndentMode
		{
			get{ return (AutoIndentMode)_Combo_AutoIndent.SelectedIndex; }
			set{ _Combo_AutoIndent.SelectedIndex = (int)value; }
		}

		/// <summary>
		/// Azuki ̃IvV擾܂͐ݒ肵܂B
		/// </summary>
		public AzukiOption AzukiOption
		{
			get{ return _AzukiOption; }
			set{ _AzukiOption = value; }
		}
		#endregion

		#region UI Event Handlers
		void _OkButton_Click( object sender, EventArgs e )
		{
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		void _CancelButton_Click( object sender, EventArgs e )
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		void _Button_AzukiSettings_Click( object sender, EventArgs e )
		{
			DialogResult result;

			// _CAO
			_AzukiOptionDialog.AzukiOption = _AzukiOption;

			// \
			result = _AzukiOptionDialog.ShowDialog( this );
			if( result == DialogResult.OK )
			{
				_AzukiOption = _AzukiOptionDialog.AzukiOption;
			}
		}
		#endregion

		#region UI Component Initialization
		/// <summary>
		/// _CAOŎgp_\NCAg܂B
		/// </summary>
		protected override void InstallBraillers()
		{
			_ComboBoxBrailler.Init();
			_ComboBoxBrailler.Add( _Combo_AutoIndent );
			_ComboBoxBrailler.Add( _Combo_HomeKey );

			_ControlBrailler.Init();
			_ControlBrailler.Add( _Check_UseAzuki );
			_ControlBrailler.Add( _Button_Ok );
			_ControlBrailler.Add( _Button_Cancel );
			_ControlBrailler.Add( _Button_AzukiSettings );
		}

		/// <summary>
		/// _CAOŎgp_\NCAg̃\[X܂B
		/// </summary>
		protected override void UninstallBraillers()
		{
			_ComboBoxBrailler.Dispose();
			_ControlBrailler.Dispose();
		}

		/// <summary>
		/// _CAÕRg[ǂݏグXN[[_܂B
		/// </summary>
		protected override void InstallReaders()
		{
			_ComboBoxReader.Add( _Combo_AutoIndent );
			_ComboBoxReader.Add( _Combo_HomeKey );
		}

		/// <summary>
		/// _CAÕRg[ǂݏグXN[[_̃\[X܂B
		/// </summary>
		protected override void UninstallReaders()
		{
			_ComboBoxReader.Dispose();
		}

		void LocalizeComponent()
		{
			string str;
			Localizer localizer = AppLogic.Localizer;

			localizer.TryGetString( "OptionDialog.Text", this );
			localizer.TryGetString( "OptionDialog._Check_UseAzuki.Text", _Check_UseAzuki );
			localizer.TryGetString( "OptionDialog._Button_AzukiSettings.Text", _Button_AzukiSettings );

			localizer.TryGetString( "OptionDialog._Label_HomeKey.Text", _Label_HomeKey );
			for( int i=0; i<2; i++ )
			{
				str = _Combo_HomeKey.Items[i].ToString();
				localizer.TryGetString( "OptionDialog._Combo_HomeKey.Items["+i+"].Text", ref str );
				_Combo_HomeKey.Items[i] = str;
			}

			localizer.TryGetString( "OptionDialog._Label_AutoIndent.Text", _Label_AutoIndent );
			for( int i=0; i<3; i++ )
			{
				str = _Combo_AutoIndent.Items[i].ToString();
				localizer.TryGetString( "OptionDialog._Combo_AutoIndent.Items["+i+"].Text", ref str );
				_Combo_AutoIndent.Items[i] = str;
			}
		}

		void InitializeComponent()
		{
			_Button_Ok = new Button();
			_Button_Cancel = new Button();
			_Combo_AutoIndent = new ComboBox();
			_Label_AutoIndent = new Label();
			_Combo_HomeKey = new ComboBox();
			_Label_HomeKey = new Label();
			_Check_UseAzuki = new CheckBox();
			_Button_AzukiSettings = new Button();
			SuspendLayout();
			// 
			// _Button_Ok
			// 
			_Button_Ok.Anchor = ((AnchorStyles)((AnchorStyles.Bottom | AnchorStyles.Right)));
			_Button_Ok.Location = new System.Drawing.Point( 241, 109 );
			_Button_Ok.Name = "_Button_Ok";
			_Button_Ok.Size = new System.Drawing.Size( 75, 23 );
			_Button_Ok.TabIndex = 6;
			_Button_Ok.Text = "OK";
			_Button_Ok.Click += _OkButton_Click;
			_Button_Ok.UseVisualStyleBackColor = true;
			// 
			// _Button_Cancel
			// 
			_Button_Cancel.Anchor = ((AnchorStyles)((AnchorStyles.Bottom | AnchorStyles.Right)));
			_Button_Cancel.Location = new System.Drawing.Point( 322, 109 );
			_Button_Cancel.Name = "_Button_Cancel";
			_Button_Cancel.Size = new System.Drawing.Size( 75, 23 );
			_Button_Cancel.TabIndex = 7;
			_Button_Cancel.Text = "Cancel";
			_Button_Cancel.Click += _CancelButton_Click;
			_Button_Cancel.UseVisualStyleBackColor = true;
			// 
			// _Combo_AutoIndent
			// 
			_Combo_AutoIndent.DropDownStyle = ComboBoxStyle.DropDownList;
			_Combo_AutoIndent.FormattingEnabled = true;
			_Combo_AutoIndent.Items.AddRange( new object[] {
            "Disable",
            "Generic auto-indent",
            "Smart auto-indent"} );
			_Combo_AutoIndent.Location = new System.Drawing.Point( 138, 73 );
			_Combo_AutoIndent.Name = "_Combo_AutoIndent";
			_Combo_AutoIndent.Size = new System.Drawing.Size( 259, 20 );
			_Combo_AutoIndent.TabIndex = 5;
			// 
			// _Label_AutoIndent
			// 
			_Label_AutoIndent.Location = new System.Drawing.Point( 10, 76 );
			_Label_AutoIndent.Name = "_Label_AutoIndent";
			_Label_AutoIndent.Size = new System.Drawing.Size( 120, 17 );
			_Label_AutoIndent.TabIndex = 4;
			_Label_AutoIndent.Text = "Auto-&Indent";
			// 
			// _Combo_HomeKey
			// 
			_Combo_HomeKey.DropDownStyle = ComboBoxStyle.DropDownList;
			_Combo_HomeKey.FormattingEnabled = true;
			_Combo_HomeKey.Items.AddRange( new object[] {
            "Move to line head",
            "Move to first non white space char"} );
			_Combo_HomeKey.Location = new System.Drawing.Point( 138, 47 );
			_Combo_HomeKey.Name = "_Combo_HomeKey";
			_Combo_HomeKey.Size = new System.Drawing.Size( 259, 20 );
			_Combo_HomeKey.TabIndex = 3;
			// 
			// _Label_HomeKey
			// 
			_Label_HomeKey.Location = new System.Drawing.Point( 10, 50 );
			_Label_HomeKey.Name = "_Label_HomeKey";
			_Label_HomeKey.Size = new System.Drawing.Size( 120, 17 );
			_Label_HomeKey.TabIndex = 2;
			_Label_HomeKey.Text = "&Home key's action";
			// 
			// _Check_UseAzuki
			// 
			_Check_UseAzuki.Location = new System.Drawing.Point( 12, 15 );
			_Check_UseAzuki.Name = "_Check_UseAzuki";
			_Check_UseAzuki.Size = new System.Drawing.Size( 237, 19 );
			_Check_UseAzuki.TabIndex = 0;
			_Check_UseAzuki.Text = "Use &Azuki editor engine";
			// 
			// _Button_AzukiSettings
			// 
			_Button_AzukiSettings.Location = new System.Drawing.Point( 256, 12 );
			_Button_AzukiSettings.Name = "_Button_AzukiSettings";
			_Button_AzukiSettings.Size = new System.Drawing.Size( 141, 23 );
			_Button_AzukiSettings.TabIndex = 1;
			_Button_AzukiSettings.Text = "A&zuki options...";
			_Button_AzukiSettings.Click += _Button_AzukiSettings_Click;
			_Button_AzukiSettings.UseVisualStyleBackColor = true;
			// 
			// OptionDialog
			// 
			ClientSize = new System.Drawing.Size( 409, 144 );
			Controls.Add( _Label_HomeKey );
			Controls.Add( _Label_AutoIndent );
			Controls.Add( _Combo_HomeKey );
			Controls.Add( _Combo_AutoIndent );
			Controls.Add( _Check_UseAzuki );
			Controls.Add( _Button_AzukiSettings );
			Controls.Add( _Button_Ok );
			Controls.Add( _Button_Cancel );
			Activated += Form_Activated;
			MaximizeBox = false;
			MinimizeBox = false;
			Name = "OptionDialog";
			Text = "Options";
			ResumeLayout( false );

		}
		#endregion

		#region UI Components
		Button _Button_Ok;
		Button _Button_Cancel;
		ComboBox _Combo_AutoIndent;
		Label _Label_AutoIndent;
		ComboBox _Combo_HomeKey;
		Label _Label_HomeKey;
		CheckBox _Check_UseAzuki;
		Button _Button_AzukiSettings;

		ComboBoxReader _ComboBoxReader = new ComboBoxReader();
		ComboBoxBrailler _ComboBoxBrailler = new ComboBoxBrailler();
		ControlBrailler _ControlBrailler = new ControlBrailler();
		#endregion
	}
}
