// 2008-10-05
using System;
using System.Text;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBEdit
{
	class MyMenuItem : MenuItem
	{
		string _LabelText;
		string _ShortcutKeyDisplayString;

		#region Init / Dispose
		public MyMenuItem()
			: base()
		{
			ShowShortcut = false;
		}

		public MyMenuItem( string text )
			: base( text )
		{
			_LabelText = text;
			ShowShortcut = false;
		}

		public MyMenuItem( string text, EventHandler onClick )
			: base( text, onClick )
		{
			_LabelText = text;
			ShowShortcut = false;
		}
		#endregion

		/// <summary>
		/// V[gJbg̕ɕ\镶擾܂͐ݒ肵܂B
		/// </summary>
		public string ShortcutKeyDisplayString
		{
			get{ return _ShortcutKeyDisplayString; }
			set
			{
				_ShortcutKeyDisplayString = value;
				base.Text = _LabelText + "\t" + _ShortcutKeyDisplayString;
			}
		}

		/// <summary>
		/// j[̍ږ擾܂͐ݒ肵܂B
		/// </summary>
		public new string Text
		{
			get{ return base.Text; }
			set
			{
				StringBuilder text = new StringBuilder();

				_LabelText = value;

				text.Append( _LabelText );
				if( _ShortcutKeyDisplayString != null )
				{
					text.Append( "\t" + _ShortcutKeyDisplayString );
				}

				base.Text = text.ToString();
			}
		}
	}
}
