// file: JavaFileType.cs
// brief: File type class for Java
// update: 2007-02-25
//=========================================================
using System;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using File = System.IO.File;
using Path = System.IO.Path;

namespace Sgry.AiBTools.AiBEdit
{
	/// <summary>
	/// Java ̃\[Xt@Ct@C^Cv
	/// </summary>
	class JavaFileType : IFileType
	{
		/// <summary>
		/// t@CޖBMRU ۑɎgB
		/// </summary>
		public string Name
		{
			get{ return "Java"; }
		}

		/// <summary>
		/// wpX̃t@C邩
		/// </summary>
		/// <param name="filePath">肷t@C̃pX</param>
		/// <returns>ꍇtrue</returns>
        public bool CanHandleFile( string filePath )
		{
			const bool IGNORE_CASE = true;
			string fileExt;
			
			// gq jav / java Ȃ爵
			fileExt = Path.GetExtension( filePath );
			if( String.Compare(fileExt, ".jav", IGNORE_CASE) == 0 )
			{
				return true;
			}
			else if( String.Compare(fileExt, ".java", IGNORE_CASE) == 0 )
			{
				return true;
			}

			return false;
		}

		/// <summary>
		/// ̃AEgC\
		/// </summary>
		/// <returns>[UIV{CfbNX</returns>
		public int ShowOutline( Form owner, string docContent, int caretIndex )
		{
			DialogResult result;
			Outliner parser;

			using( OutlineDialog dialog = new OutlineDialog() )
			{
				// setup dialog
				dialog.Size = owner.Size;
				dialog.Location = owner.Location;
				
				// parse
				parser = new CppOutliner( dialog, docContent, caretIndex );
				parser.Parse();

				// show dialog
				result = dialog.ShowDialog( owner );
				if( result != DialogResult.OK )
				{
					return -1;
				}

				// return index of the selected symbol
				return dialog.SelectedSymbolIndex;
			}
		}

		/// <summary>
		/// ҏWΏۂRpC
		/// </summary>
		/// <returns>trueAsfalse</returns>
		public CompileResult Compile( Document doc )
		{
			Process				process	= new Process();
			ProcessStartInfo	pInfo;
			string				log;

			// NvZXݒ
			pInfo = new ProcessStartInfo( "javac" );
			pInfo.WorkingDirectory = Path.GetDirectoryName( doc.Path );
			pInfo.Arguments = Path.GetFileName( doc.Path );
			pInfo.UseShellExecute = false;
			pInfo.RedirectStandardError = true;
			pInfo.WindowStyle = ProcessWindowStyle.Hidden;
			pInfo.CreateNoWindow = true;

			// \[Xt@C̃GR[fBOIvVɔf
			switch( doc.Encoding.WebName )
			{
				case "iso-2022-jp":
					pInfo.Arguments = "-encoding JIS " + pInfo.Arguments;
					break;
				case "euc-jp":
					pInfo.Arguments = "-encoding EUCJIS " + pInfo.Arguments;
					break;
				case "shift_jis":
					pInfo.Arguments = "-encoding SJIS " + pInfo.Arguments;
					break;
				case "utf-8":
					pInfo.Arguments = "-encoding UTF8 " + pInfo.Arguments;
					break;
			}

			// vZXN
			process.StartInfo = pInfo;
			process.Start();

			// WG[o͂ǂݎȂAI҂
			log = process.StandardError.ReadToEnd();
			process.WaitForExit();

			// RpC
			if( process.ExitCode == 0 && log == String.Empty )
			{
				return CompileResult.Succeeded;
			}

			// RpCG[̂ŃO͂
			ParseLog( log );

			return CompileResult.CompileErrorOccured;
		}

		/// <summary>
		/// rhR}hs
		/// </summary>
		/// <returns>trueAsfalse</returns>
		public CompileResult Build( Document doc )
		{
			CompileResult result;
			string		log;

			// rhANVLqob`t@Cs
			result = TryExecBatchFile( doc.Path, out log );
			if( result != CompileResult.FailedToExecute )
			{
				goto parse_log;
			}

			// JgfBNg̑St@CRpC
			result = TryExecCompileCurrentDirectory( doc.Path, doc.Encoding, out log );
			if( result != CompileResult.FailedToExecute )
			{
				goto parse_log;
			}

			// ǂ̃ANVɂs
			return CompileResult.FailedToExecute;

		parse_log:
			// O
			ParseLog( log );

			return result;
		}

		#region rhANV
		static CompileResult TryExecBatchFile( string docPath, out string log )
		{
			Process				process	= new Process();
			ProcessStartInfo	pInfo;
			string				batPath;

			// ob`t@C̃pX𐶐
			batPath = Path.GetDirectoryName( docPath );
			batPath = Path.Combine( batPath, "_build.bat" );
			if( File.Exists(batPath) == false )
			{
				log = "";
				return CompileResult.FailedToExecute; // ob`t@C͖
			}

			// NvZXݒ
			pInfo = new ProcessStartInfo( "cmd" );
			pInfo.WorkingDirectory = Path.GetDirectoryName( docPath );
			pInfo.Arguments = batPath;
			pInfo.UseShellExecute = false;
			pInfo.RedirectStandardError = true;
			pInfo.WindowStyle = ProcessWindowStyle.Hidden;
			pInfo.CreateNoWindow = true;

			// vZXN
			process.StartInfo = pInfo;
			process.Start();

			// WG[o͂ǂݎȂAI҂
			log = process.StandardError.ReadToEnd();
			process.WaitForExit();

			// RpC
			if( process.ExitCode == 0 && log == String.Empty )
			{
				return CompileResult.Succeeded;
			}

			return CompileResult.CompileErrorOccured;
		}
		static CompileResult TryExecCompileCurrentDirectory( string docPath, Encoding docEncoding, out string log )
		{
			Process				process	= new Process();
			ProcessStartInfo	pInfo;

			// NvZXݒ
			pInfo = new ProcessStartInfo( "javac" );
			pInfo.WorkingDirectory = Path.GetDirectoryName( docPath );
			pInfo.Arguments = "*.java";
			pInfo.UseShellExecute = false;
			pInfo.RedirectStandardError = true;
			pInfo.WindowStyle = ProcessWindowStyle.Hidden;
			pInfo.CreateNoWindow = true;

			// \[Xt@C̃GR[fBOIvVɔf
			switch( docEncoding.WebName )
			{
				case "iso-2022-jp":
					pInfo.Arguments = "-encoding JIS " + pInfo.Arguments;
					break;
				case "euc-jp":
					pInfo.Arguments = "-encoding EUCJIS " + pInfo.Arguments;
					break;
				case "shift_jis":
					pInfo.Arguments = "-encoding SJIS " + pInfo.Arguments;
					break;
				case "utf-8":
					pInfo.Arguments = "-encoding UTF8 " + pInfo.Arguments;
					break;
			}

			// vZXN
			process.StartInfo = pInfo;
			process.Start();

			// WG[o͂ǂݎȂAI҂
			log = process.StandardError.ReadToEnd();
			process.WaitForExit();

			// RpC
			if( process.ExitCode == 0 && log == String.Empty )
			{
				return CompileResult.Succeeded;
			}

			// RpCG[̂ŃO͂
			ParseLog( log );

			return CompileResult.CompileErrorOccured;
		}
		#endregion

		#region O
		static void ParseLog( string log )
		{
			string[]		lines;
			int				errorCount	= 0;

			// OsƂɕ
			lines = Utl.SplitToLine( log );
			if( lines.Length == 0 )
			{
				return; // AĉȂ
			}

			// eG[ڂꗗɒǉĂ
			for( int i=0; i<lines.Length; i++ )
			{
				//---- G[bZ[WubN̐擪s ----//
				string			filePath, line;
				string			message;
				bool			isFirstLine;
				int				column;

				// G[bZ[WubN̐擪sH
				isFirstLine = ParseFirstErrorLine( lines[i], out filePath, out line, out message );
				if( isFirstLine )
				{
					// G[e̓V{H
					if( message.StartsWith("V{")
						|| message.StartsWith("cannot find symbol") )
					{
						string		format;
						string[]	tokens;
						
						// ̃V{؂o
						tokens = lines[i+1].Split( ':' );
						if( tokens == null || tokens.Length < 2 )
						{
							continue; // ȃG[bZ[Wł͂ȂH
						}

						format = AppLogic.Localizer.TryGetString(
								"ErrorListForm.Msg_CannotResolveSymbol",
								"{0} was not found."
							);
						message = String.Format( format, tokens[1].Trim() );
 					}

					// XgɃG[ڂǉ
					column = ParseErrorColumn( ref lines, i );
//host.AddErrorItem( message, filePath, line, column.ToString() );

					errorCount++;
				}
			}
		}

		/// <summary>
		/// eG[ubN̐擪s
		/// </summary>
		/// <param name="logLine">͂G[ubN̐擪s</param>
		/// <param name="filePath">t@CpX</param>
		/// <param name="line">G[sԍ</param>
		/// <param name="errorMessage">G[e</param>
		/// <returns>G[ubN̐擪słȂꍇfalse</returns>
		static bool ParseFirstErrorLine( string logLine, out string filePath, out string line, out string errorMessage )
		{
			string[] tokens = logLine.Split( ':' );
			if( tokens == null || tokens.Length < 3 || 4 < tokens.Length )
			{
				goto error; // G[ubN̐擪sł͂Ȃ
			}

			if( tokens.Length == 3 )
			{
				filePath = tokens[0];
				line = tokens[1];
				errorMessage = tokens[2].TrimStart();
				return true;
			}
			else if( tokens.Length == 4 )
			{
				filePath = String.Format( "{0}:{1}", tokens[0], tokens[1] );
				line = tokens[2];
				errorMessage = tokens[3].TrimStart();
				return true;
			}

			error:
			filePath = "";
			line = "";
			errorMessage = "";
			return false;
		}

		/// <summary>
		/// G[bZ[WG[ʒuvZ
		/// </summary>
		/// <param name="logLines">G[bZ[WŜ̊es܂ޔz</param>
		/// <param name="firstLineIndexOfErrorLog">͒̍śAz񒆂̃CfbNX</param>
		/// <returns>ڂŃG[N</returns>
		/// <remarks>s 0 Ԃ</remarks>
		static int ParseErrorColumn( ref string[] logLines, int firstLineIndexOfErrorLog )
		{
			char[]	white_spaces = new char[]{' ', '\t'};
			int		i;
			string	hatOnlyLine = null;
			
			// ̃G[bZ[ẂA'^' ݂̂܂ލs𒊏o
			for( i=firstLineIndexOfErrorLog; i<logLines.Length; i++ )
			{
				// ŏ̔󔒕 '^' H
				if( logLines[i].TrimStart(white_spaces).StartsWith( "^" ) )
				{
					hatOnlyLine = logLines[i];
					break;
				}
			}

			// ołȂΏI
			if( hatOnlyLine == null )
			{
				return 0;
			}

			// '^' CfbNX{PԂ
// tab WŌvZ鎖ɂȂBʂ̃GfB^݂͂ȂSŌvZĂ̂ŗv
			return hatOnlyLine.IndexOf( '^' ) + 1; // ȂƁAvZ (-1+1=)0 Ԃ
		}
		#endregion

		#region Utilities
		class Utl
		{
			public static string GetWordAt( string str, int wordPosition )
			{
				int	startPos, endPos;
				
				endPos = NextTokenPos( str, wordPosition );
				if( endPos == -1 )
				{
					endPos = str.Length;
				}

				startPos = PrevWhiteSpacePos( str, wordPosition );
				if( startPos == -1 )
				{
					startPos = 0;
				}
				else
				{
					startPos++;
				}
				
				return str.Substring( startPos, endPos - startPos );
			}
			
			public static int NextWordPos( string str, int searchStartPosition )
			{
				int preWordWhiteSpacePos = NextWhiteSpacePos( str, searchStartPosition );
				if( preWordWhiteSpacePos == -1 )
				{
					return -1;
				}

				return NextNonWhiteSpacePos( str, preWordWhiteSpacePos );
			}

			public static int NextNonWhiteSpacePos( string str, int startIndex )
			{
				for( int i=startIndex; i<str.Length; i++ )
				{
					if( str[i] != ' ' && str[i] != '\t' )
						return i;
				}

				return -1;
			}

			public static int NextWhiteSpacePos( string str, int startIndex )
			{
				for( int i=startIndex; i<str.Length; i++ )
				{
					if( str[i] == ' ' || str[i] == '\t' )
						return i;
				}

				return -1;
			}

			public static int NextTokenPos( string str, int startIndex )
			{
				for( int i=startIndex; i<str.Length; i++ )
				{
					if( IsDelimitter(str[i]) == false )
						return i;
				}

				return -1;
			}

			public static int PrevNonWhiteSpacePos( string str, int startIndex )
			{
				for( int i=startIndex; i>=0; i-- )
				{
					if( str[i] != ' ' && str[i] != '\t' )
						return i;
				}

				return -1;
			}

			public static int PrevWhiteSpacePos( string str, int startIndex )
			{
				int i;
				for( i=startIndex; i>=0; i-- )
				{
					if( str[i] == ' ' || str[i] == '\t' )
						return i;
				}

				return -1;
			}

			static bool IsDelimitter( char ch )
			{
				if( Char.IsLetterOrDigit(ch) )
				{
					return true;
				}
				if( ch == '_' )
				{
					return true;
				}

				return false;
			}

			public static bool IsInComment( string line, int positionToCheck )
			{
				// comment outed by 1-line-comment?
				if( line.LastIndexOf("//") != -1 )
				{
					return true;
				}
				
				// comment outed by C-style comment?
				//TODO_1// [

				return false;
			}

			/// <summary>
			/// Java\[XRg菜
			/// </summary>
			/// <param name="src">Rg菜\[X</param>
			/// <returns>Rg菜ꂽ\[X</returns>
			public static string RemoveComment( string src )
			{
				StringBuilder buffer = new StringBuilder( src.Length );

				for( int i=0; i<src.Length; i++ )
				{
					// comment begins from this char?
					if( src[i] == '/' )
					{
						if( src[i+1] == '/' )
						{
							// one-line comment found
							int nextLineHeadPos = NextLineHeadPos( src, i+1 );
							if( nextLineHeadPos == -1 )
							{
								break; // fatal error
							}
							for( int j=0; j<nextLineHeadPos - i; j++ )
								buffer.Append( ' ' );
							i = nextLineHeadPos;
						}
						else if( src[i+1] == '*' )
						{
							// block comment found
							int commentEndPos;
							commentEndPos = src.IndexOf( "*/", i+1 );
							if( commentEndPos == -1 )
							{
								break; // non-closed block comment; syntax error
							}
							commentEndPos += 2; // "*/".Length;

							for( int j=0; j<commentEndPos - i; j++ )
								buffer.Append( ' ' );
							i = commentEndPos;
						}
					}

					// add this char to comment-stripped buffer
					buffer.Append( src[i] );
				}

				return buffer.ToString();
			}

			public static int NextLineHeadPos( string str, int startIndex )
			{
				int pos;
				
				// skip until new line codes appear
				pos = startIndex;
				while( str[pos] != '\r' && str[pos] != '\n' )
				{
					if( str.Length <= pos )
					{
						return -1; // no more lines exist
					}

					pos++;
				}

				// then, skip until new line codes disappear
				while( str[pos] == '\r' || str[pos] == '\n' )
				{
					if( str.Length < pos )
					{
						return -1; // fatal error
					}

					pos++;
				}

				return pos;
			}

			public static int LineHeadPos( string str, int startIndex )
			{
				int pos;
				
				// skip until new line codes appear
				pos = startIndex;
				while( str[pos] != '\r' && str[pos] != '\n' )
				{
					if( pos <= 0 )
					{
						return 0;
					}

					pos--;
				}

				return pos + 1;
			}

			/// <summary>
			/// sƂɕ
			/// </summary>
			/// <param name="str">Ώە</param>
			/// <returns>ꂽesi[z</returns>
			public static string[] SplitToLine( string str )
			{
				if( str.IndexOf("\r\n") != -1 ) // CR+LF?
				{
					str = str.Replace( "\r\n", "\n" );
					return str.Split( '\n' );
				}
				else if( str.IndexOf("\r") != -1 ) // CR?
				{
					return str.Split( '\r' );
				}
				else // LF?
				{
					return str.Split( '\n' );
				}
			}
		}
		#endregion
	}
}
