﻿// file: IFileType.cs
// brief: interface of file type object in AiB Edit
// update: 2007-02-25
//=========================================================
using System;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBEdit
{
	/// <summary>
	/// ファイルの種類を抽象化したクラスへのインタフェース。
	/// 文書の種類に応じたアクションを実行。
	/// </summary>
	/// このインタフェースは AiB Edit 本体から
	/// ファイル種に依存した処理を実行する際のインタフェースとなる。
	/// FileType クラスは次の２クラスに処理を委譲する。
	/// ・Parser: アウトライン抽出処理を担当
	/// ・Compiler: コンパイル・ビルド処理を担当
	internal interface IFileType
	{
		/// <summary>
		/// ファイル種類名。MRU 保存時に使う。
		/// </summary>
		string Name{ get; }

		/// <summary>
		/// 指定パスのファイルを扱えるか判定
		/// </summary>
		/// <param name="filePath">判定するファイルのパス</param>
		/// <returns>扱える場合はtrue</returns>
		bool CanHandleFile( string filePath );

		/// <summary>
		/// 文書のアウトラインを表示
		/// </summary>
		/// <returns>ユーザが選択したシンボルがあるインデックス</returns>
		int ShowOutline( Form owner, string docContent, int caretIndex );

		/// <summary>
		/// 編集対象をコンパイルする
		/// </summary>
		/// <param name="doc">編集対象</param>
		/// <returns>コンパイル結果</returns>
		CompileResult Compile( Document doc );

		/// <summary>
		/// ビルドコマンドを実行する
		/// </summary>
		/// <param name="doc">編集対象</param>
		/// <returns>コンパイル結果</returns>
		CompileResult Build( Document doc );
	}
}
