// file: GotoLineDialog.cs
// brief: dialog to ask user which line to go
// update: 2008-12-20
//=========================================================
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBEdit
{
	using AT;
	using Gui;

	class GotoLineDialog : AiBDialogBase
	{
		#region Init/Dispose
		public GotoLineDialog()
		{
			InitializeComponent();
			LocalizeComponents();
			_Button_Cancel.DialogResult = DialogResult.Cancel;
			SizeGripStyle = SizeGripStyle.Hide;
			FormBorderStyle = FormBorderStyle.FixedDialog;
			Font = SystemInformation.MenuFont;
		}

		void Form_Activated( object sender, EventArgs e )
		{
			_ControlBrailler.UpdateDisplay();
		}
		#endregion

		#region Properties
		/// <summary>
		/// [U͂sԍ
		/// </summary>
		public int LineNumber
		{
			get{ return Int32.Parse(_Edit_LineNum.Text); }
			set{ _Edit_LineNum.Text = value.ToString(); }
		}
		#endregion

		#region event handlers
		void _Button_OK_Click( object sender, EventArgs e )
		{
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		void _Edit_LineNum_Enter( object sender, EventArgs e )
		{
			_Edit_LineNum.Select( 0, 100 );
		}

		void _Edit_LineNum_KeyDown( object sender, KeyEventArgs e )
		{
			if( e.KeyCode == Keys.Up )
			{
				LineNumber++;
				AutoSpeaker.Instance.Stop();
				AutoSpeaker.Instance.Speak( LineNumber.ToString() );
			}
			else if( e.KeyCode == Keys.Down )
			{
				if( 0 < LineNumber )
				{
					LineNumber--;
					AutoSpeaker.Instance.Stop();
					AutoSpeaker.Instance.Speak( LineNumber.ToString() );
				}
			}
		}

		void _Edit_LineNum_KeyUp( object sender, KeyEventArgs e )
		{
			if( e.KeyCode == Keys.Up
				|| e.KeyCode == Keys.Down )
			{
				_Edit_LineNum.Select( 0, 100 );
			}
		}

		void _Edit_LineNum_Validating( object sender, CancelEventArgs e )
		{
			try
			{
				Int32.Parse( _Edit_LineNum.Text );
			}
			catch( FormatException )
			{
				e.Cancel = true;
				Win32.MessageBeep_Notify();
			}
		}
		#endregion

		#region UI Component Initialization
		protected override void InstallBraillers()
		{
			_ControlBrailler.Init();
			_ControlBrailler.Add( _Button_OK );
			_ControlBrailler.Add( _Button_Cancel );
			_ControlBrailler.Add( _Edit_LineNum );
		}

		protected override void UninstallBraillers()
		{
			_ControlBrailler.Dispose();
		}

		/// <summary>
		/// _CAÕRg[ǂݏグXN[[_܂B
		/// </summary>
		protected override void InstallReaders()
		{
			_TextBoxReader.Add( _Edit_LineNum );
		}

		/// <summary>
		/// _CAÕRg[ǂݏグXN[[_̃\[X܂B
		/// </summary>
		protected override void UninstallReaders()
		{
			_TextBoxReader.Dispose();
		}

		/// <summary>
		/// [JCY
		/// </summary>
		void LocalizeComponents()
		{
			Localizer localizer = AppLogic.Localizer;

			localizer.TryGetString( Name + "._Label_LineNum.Text", _Label_LineNum );
			localizer.TryGetString( Name + ".Text", this );
		}

		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		void InitializeComponent()
		{
			_Label_LineNum = new Label();
			_Button_OK = new Button();
			_Button_Cancel = new Button();
			_Edit_LineNum = new TextBox();
			SuspendLayout();
			// 
			// _Label_LineNum
			// 
			_Label_LineNum.Location = new System.Drawing.Point( 16, 15 );
			_Label_LineNum.Name = "_Label_LineNum";
			_Label_LineNum.Size = new System.Drawing.Size( 100, 17 );
			_Label_LineNum.TabIndex = 0;
			_Label_LineNum.Text = "&Line number number";
			_Label_LineNum.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// _Button_OK
			// 
			_Button_OK.FlatStyle = FlatStyle.System;
			_Button_OK.Location = new System.Drawing.Point( 44, 52 );
			_Button_OK.Name = "_Button_OK";
			_Button_OK.Size = new System.Drawing.Size( 90, 24 );
			_Button_OK.TabIndex = 2;
			_Button_OK.Text = "OK";
			_Button_OK.Click += _Button_OK_Click;
			// 
			// _Button_Cancel
			// 
			_Button_Cancel.DialogResult = DialogResult.Cancel;
			_Button_Cancel.FlatStyle = FlatStyle.System;
			_Button_Cancel.Location = new System.Drawing.Point( 140, 52 );
			_Button_Cancel.Name = "_Button_Cancel";
			_Button_Cancel.Size = new System.Drawing.Size( 90, 24 );
			_Button_Cancel.TabIndex = 3;
			_Button_Cancel.Text = "Cancel";
			// 
			// _Edit_LineNum
			// 
			_Edit_LineNum.Location = new System.Drawing.Point( 122, 12 );
			_Edit_LineNum.Name = "_Edit_LineNum";
			_Edit_LineNum.Size = new System.Drawing.Size( 88, 24 );
			_Edit_LineNum.TabIndex = 1;
			_Edit_LineNum.Enter += _Edit_LineNum_Enter;
			_Edit_LineNum.KeyUp += _Edit_LineNum_KeyUp;
			_Edit_LineNum.Validating += _Edit_LineNum_Validating;
			_Edit_LineNum.KeyDown += _Edit_LineNum_KeyDown;
			// 
			// GotoLineDialog
			// 
			Activated += Form_Activated;
			AcceptButton = _Button_OK;
			CancelButton = _Button_Cancel;
			ClientSize = new System.Drawing.Size( 242, 88 );
			Controls.Add( _Label_LineNum );
			Controls.Add( _Edit_LineNum );
			Controls.Add( _Button_OK );
			Controls.Add( _Button_Cancel );
			MaximizeBox = false;
			MinimizeBox = false;
			Name = "GotoLineDialog";
			ShowInTaskbar = false;
			Text = "Go to line";
			ResumeLayout( false );
			PerformLayout();
		}
		#endregion

		#region UI Components
		Label	_Label_LineNum;
		Button	_Button_OK;
		Button	_Button_Cancel;
		TextBox	_Edit_LineNum;
		ControlBrailler	_ControlBrailler = new ControlBrailler();
		TextBoxReader	_TextBoxReader	= new TextBoxReader();
		#endregion
	}
}
